/*
 * Decompiled with CFR 0.152.
 */
package hardcorequesting.common.forge.client.interfaces.graphic;

import hardcorequesting.common.forge.bag.LootGroup;
import hardcorequesting.common.forge.client.EditMode;
import hardcorequesting.common.forge.client.interfaces.GuiQuestBook;
import hardcorequesting.common.forge.client.interfaces.edit.PickItemMenu;
import hardcorequesting.common.forge.client.interfaces.graphic.EditableGraphic;
import hardcorequesting.common.forge.client.interfaces.widget.NumberTextBox;
import hardcorequesting.common.forge.util.EditType;
import hardcorequesting.common.forge.util.SaveHelper;
import hardcorequesting.common.forge.util.Translator;
import java.util.ArrayList;
import java.util.Collection;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class EditGroupGraphic
extends EditableGraphic {
    private static final int GROUP_ITEMS_X = 20;
    private static final int GROUP_ITEMS_Y = 40;
    private static final int GROUP_ITEMS_SPACING = 20;
    private static final int ITEMS_PER_LINE = 7;
    private final LootGroup group;

    public EditGroupGraphic(GuiQuestBook gui, LootGroup group) {
        super(gui, EditMode.NORMAL, EditMode.ITEM, EditMode.DELETE);
        this.group = group;
        this.addTextBox(new NumberTextBox(gui, 180, 30, FormattedText.f_130760_, false, 3, group::getLimit, group::setLimit));
    }

    @Override
    public void draw(GuiGraphics graphics, int mX, int mY) {
        int yPos;
        int xPos;
        ItemStack stack;
        int i;
        super.draw(graphics, mX, mY);
        this.gui.drawString(graphics, this.group.getDisplayName(), 20, 20, this.group.getTier().getColor().getHexColor());
        ArrayList<ItemStack> items = new ArrayList<ItemStack>((Collection<ItemStack>)this.group.getItems());
        items.add(ItemStack.f_41583_);
        for (i = 0; i < items.size(); ++i) {
            stack = (ItemStack)items.get(i);
            xPos = i % 7 * 20 + 20;
            yPos = i / 7 * 20 + 40;
            this.gui.drawItemStack(graphics, stack, xPos, yPos, mX, mY, false);
        }
        for (i = 0; i < items.size(); ++i) {
            stack = (ItemStack)items.get(i);
            xPos = i % 7 * 20 + 20;
            yPos = i / 7 * 20 + 40;
            if (!this.gui.inBounds(xPos, yPos, 18, 18, mX, mY)) continue;
            if (stack.m_41619_()) break;
            try {
                graphics.m_280153_(this.gui.getFont(), stack, mX + this.gui.getLeft(), mY + this.gui.getTop());
            }
            catch (Exception exception) {}
            break;
        }
        this.gui.drawString(graphics, (FormattedText)Translator.translatable("hqm.questBook.maxRetrieval", new Object[0]), 180, 20, 0x404040);
        this.gui.drawString(graphics, (FormattedText)Translator.translatable("hqm.questBook.noRestriction", new Object[0]), 180, 48, 0.7f, 0x404040);
    }

    @Override
    public void onClick(int mX, int mY, int b) {
        super.onClick(mX, mY, b);
        ArrayList<ItemStack> items = new ArrayList<ItemStack>((Collection<ItemStack>)this.group.getItems());
        items.add(ItemStack.f_41583_);
        for (int i = 0; i < items.size(); ++i) {
            int xPos = i % 7 * 20 + 20;
            int yPos = i / 7 * 20 + 40;
            if (!this.gui.inBounds(xPos, yPos, 18, 18, mX, mY)) continue;
            if (this.gui.getCurrentMode() == EditMode.ITEM) {
                int amount;
                ItemStack stack;
                ItemStack itemStack = stack = i < items.size() ? (ItemStack)items.get(i) : ItemStack.f_41583_;
                if (!stack.m_41619_()) {
                    stack = stack.m_41777_();
                    amount = stack.m_41613_();
                } else {
                    amount = 1;
                }
                int id = i;
                PickItemMenu.display(this.gui, stack, PickItemMenu.Type.ITEM, amount, result -> this.group.setItem(id, (ItemStack)result.getWithAmount()));
                break;
            }
            if (this.gui.getCurrentMode() != EditMode.DELETE) break;
            this.group.removeItem(i);
            SaveHelper.add(EditType.GROUP_ITEM_REMOVE);
            break;
        }
    }
}

