/*
 * Decompiled with CFR 0.152.
 */
package hardcorequesting.common.forge.client.interfaces.graphic;

import hardcorequesting.common.forge.client.EditMode;
import hardcorequesting.common.forge.client.interfaces.GuiQuestBook;
import hardcorequesting.common.forge.client.interfaces.edit.EditRepTierValueMenu;
import hardcorequesting.common.forge.client.interfaces.edit.WrappedTextMenu;
import hardcorequesting.common.forge.client.interfaces.graphic.EditableGraphic;
import hardcorequesting.common.forge.client.interfaces.widget.LargeButton;
import hardcorequesting.common.forge.client.interfaces.widget.ScrollBar;
import hardcorequesting.common.forge.reputation.Reputation;
import hardcorequesting.common.forge.reputation.ReputationManager;
import hardcorequesting.common.forge.reputation.ReputationMarker;
import hardcorequesting.common.forge.util.EditType;
import hardcorequesting.common.forge.util.SaveHelper;
import hardcorequesting.common.forge.util.Translator;
import hardcorequesting.common.forge.util.WrappedText;
import java.util.List;
import java.util.UUID;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class EditReputationGraphic
extends EditableGraphic {
    public static final int VISIBLE_REPUTATION_TIERS = 9;
    public static final int VISIBLE_REPUTATIONS = 10;
    public static final int REPUTATION_LIST_X = 20;
    public static final int REPUTATION_MARKER_LIST_X = 180;
    public static final int REPUTATION_LIST_Y = 20;
    public static final int REPUTATION_MARKER_LIST_Y = 35;
    public static final int REPUTATION_NEUTRAL_Y = 20;
    public static final int REPUTATION_OFFSET = 20;
    public static final int FONT_HEIGHT = 9;
    public static Reputation selectedReputation;
    private final ScrollBar reputationScroll;
    private final ScrollBar reputationTierScroll;

    public EditReputationGraphic(GuiQuestBook gui) {
        super(gui, EditMode.NORMAL, EditMode.CREATE, EditMode.RENAME, EditMode.REPUTATION_VALUE, EditMode.DELETE);
        this.addClickable(new LargeButton(this.gui, "Create New", 180, 20){

            @Override
            public boolean isVisible() {
                return EditReputationGraphic.this.gui.getCurrentMode() == EditMode.CREATE && selectedReputation == null;
            }

            @Override
            public void onClick() {
                ReputationManager.getInstance().addReputation(new Reputation());
                SaveHelper.add(EditType.REPUTATION_ADD);
            }
        });
        this.addClickable(new LargeButton(this.gui, "hqm.questBook.createTier", 20, 20){

            @Override
            public boolean isVisible() {
                return EditReputationGraphic.this.gui.getCurrentMode() == EditMode.CREATE && selectedReputation != null;
            }

            @Override
            public void onClick() {
                selectedReputation.add(new ReputationMarker(WrappedText.create("Unnamed"), 0, false));
                SaveHelper.add(EditType.REPUTATION_MARKER_CREATE);
            }
        });
        this.reputationTierScroll = new ScrollBar(gui, ScrollBar.Size.LONG, 312, 23, 180){

            @Override
            public boolean isVisible() {
                return selectedReputation != null && selectedReputation.getMarkerCount() > 9;
            }
        };
        this.addScrollBar(this.reputationTierScroll);
        this.reputationScroll = new ScrollBar(gui, ScrollBar.Size.LONG, 160, 23, 20){

            @Override
            public boolean isVisible() {
                return (EditReputationGraphic.this.gui.getCurrentMode() != EditMode.CREATE || selectedReputation == null) && ReputationManager.getInstance().size() > 10;
            }
        };
        this.addScrollBar(this.reputationScroll);
    }

    @Override
    public void draw(GuiGraphics graphics, int mX, int mY) {
        boolean hover;
        super.draw(graphics, mX, mY);
        if (this.gui.getCurrentMode() != EditMode.CREATE || selectedReputation == null) {
            int x = 20;
            int y = 20;
            List<Reputation> reputationList = ReputationManager.getInstance().getReputationList();
            for (Reputation reputation : this.reputationScroll.getVisibleEntries(reputationList, 10)) {
                MutableComponent str = reputation.getName();
                hover = this.gui.inBounds(x, y, this.gui.getStringWidth((FormattedText)str), 9, mX, mY);
                boolean selected = reputation.equals(selectedReputation);
                this.gui.drawString(graphics, (FormattedText)str, x, y, selected ? (hover ? 0x40CC40 : 0x409040) : (hover ? 0xAAAAAA : 0x404040));
                y += 20;
            }
        }
        if (selectedReputation != null) {
            MutableComponent neutralName;
            this.gui.drawString(graphics, (FormattedText)neutralName, 180, 20, this.gui.inBounds(180, 20, this.gui.getStringWidth((FormattedText)(neutralName = Translator.translatable("hqm.rep.neutral", selectedReputation.getNeutralName()))), 9, mX, mY) ? 0xAAAAAA : 0x404040);
            int x = 180;
            int y = 35;
            for (ReputationMarker marker : this.reputationTierScroll.getVisibleEntries(selectedReputation.getMarkers(), 9)) {
                MutableComponent title;
                hover = this.gui.inBounds(x, y, this.gui.getStringWidth((FormattedText)(title = marker.getTitle())), 9, mX, mY);
                this.gui.drawString(graphics, (FormattedText)title, x, y, hover ? 0xAAAAAA : 0x404040);
                y += 20;
            }
        }
    }

    @Override
    public void onClick(int mX, int mY, int b) {
        super.onClick(mX, mY, b);
        UUID playerId = this.gui.getPlayer().m_20148_();
        ReputationManager reputationManager = ReputationManager.getInstance();
        if (this.gui.getCurrentMode() != EditMode.CREATE || selectedReputation == null) {
            int x = 20;
            int y = 20;
            List<Reputation> reputationList = reputationManager.getReputationList();
            for (Reputation reputation : this.reputationScroll.getVisibleEntries(reputationList, 10)) {
                if (this.gui.inBounds(x, y, this.gui.getStringWidth((FormattedText)reputation.getName()), 9, mX, mY)) {
                    if (this.gui.getCurrentMode() == EditMode.NORMAL) {
                        selectedReputation = reputation.equals(selectedReputation) ? null : reputation;
                    } else if (this.gui.getCurrentMode() == EditMode.RENAME) {
                        WrappedTextMenu.display(this.gui, reputation.getRawName(), true, reputation::setName);
                    } else if (this.gui.getCurrentMode() == EditMode.DELETE) {
                        if (selectedReputation == reputation) {
                            selectedReputation = null;
                        }
                        reputationManager.removeReputation(reputation);
                        SaveHelper.add(EditType.REPUTATION_REMOVE);
                    }
                    return;
                }
                y += 20;
            }
        }
        if (selectedReputation != null) {
            MutableComponent neutralName = Translator.translatable("hqm.rep.neutral", selectedReputation.getNeutralName());
            if (this.gui.inBounds(180, 20, this.gui.getStringWidth((FormattedText)neutralName), 9, mX, mY)) {
                if (this.gui.getCurrentMode() == EditMode.RENAME) {
                    WrappedTextMenu.display(this.gui, selectedReputation.getRawNeutralName(), true, selectedReputation::setNeutralName);
                }
                return;
            }
            int x = 180;
            int y = 35;
            for (ReputationMarker marker : this.reputationTierScroll.getVisibleEntries(selectedReputation.getMarkers(), 9)) {
                MutableComponent title = marker.getTitle();
                if (this.gui.inBounds(x, y, this.gui.getStringWidth((FormattedText)title), 9, mX, mY)) {
                    if (this.gui.getCurrentMode() == EditMode.RENAME) {
                        WrappedTextMenu.display(this.gui, marker.getRawName(), true, marker::setName);
                    } else if (this.gui.getCurrentMode() == EditMode.REPUTATION_VALUE) {
                        EditRepTierValueMenu.display(this.gui, marker.getValue(), value -> {
                            marker.setValue((int)value);
                            selectedReputation.sort();
                            SaveHelper.add(EditType.REPUTATION_MARKER_CHANGE);
                        });
                    } else if (this.gui.getCurrentMode() == EditMode.DELETE) {
                        selectedReputation.remove(marker);
                        SaveHelper.add(EditType.REPUTATION_MARKER_REMOVE);
                    }
                    return;
                }
                y += 20;
            }
        }
    }
}

