/*
 * Decompiled with CFR 0.152.
 */
package hardcorequesting.common.forge.client.interfaces.graphic;

import hardcorequesting.common.forge.client.EditButton;
import hardcorequesting.common.forge.client.EditMode;
import hardcorequesting.common.forge.client.KeyboardHandler;
import hardcorequesting.common.forge.client.interfaces.GuiQuestBook;
import hardcorequesting.common.forge.client.interfaces.graphic.Graphic;
import hardcorequesting.common.forge.quests.Quest;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public abstract class EditableGraphic
extends Graphic {
    protected final GuiQuestBook gui;
    private final EditButton[] editButtons;

    public EditableGraphic(GuiQuestBook gui, EditMode ... modes) {
        this.gui = gui;
        this.editButtons = EditButton.createButtons(this::setEditMode, modes);
    }

    @Override
    public void draw(GuiGraphics graphics, int mX, int mY) {
        super.draw(graphics, mX, mY);
        if (Quest.canQuestsBeEdited()) {
            for (EditButton button : this.editButtons) {
                button.draw(this.gui, graphics, mX, mY);
            }
        }
    }

    @Override
    public void drawTooltip(GuiGraphics graphics, int mX, int mY) {
        super.drawTooltip(graphics, mX, mY);
        if (Quest.canQuestsBeEdited()) {
            for (EditButton button : this.editButtons) {
                button.drawInfo(this.gui, graphics, mX, mY);
            }
        }
    }

    @Override
    public void onClick(int mX, int mY, int button) {
        super.onClick(mX, mY, button);
        if (Quest.canQuestsBeEdited()) {
            for (EditButton editButton : this.editButtons) {
                if (editButton.onClick(this.gui, mX, mY)) break;
            }
        }
    }

    @Override
    public boolean keyPressed(int keyCode) {
        return super.keyPressed(keyCode) || KeyboardHandler.handleEditModeHotkey(keyCode, this.editButtons);
    }

    protected void setEditMode(EditMode mode) {
        this.gui.setCurrentMode(mode);
    }
}

