/*
 * Decompiled with CFR 0.152.
 */
package hardcorequesting.common.forge.client.interfaces.graphic;

import com.mojang.blaze3d.systems.RenderSystem;
import hardcorequesting.common.forge.client.interfaces.widget.Clickable;
import hardcorequesting.common.forge.client.interfaces.widget.Drawable;
import hardcorequesting.common.forge.client.interfaces.widget.ScrollBar;
import hardcorequesting.common.forge.client.interfaces.widget.TextBox;
import hardcorequesting.common.forge.client.interfaces.widget.TextBoxGroup;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public abstract class Graphic {
    private final List<Drawable> drawables = new ArrayList<Drawable>();
    private final List<Clickable> clickables = new ArrayList<Clickable>();
    private final List<ScrollBar> scrollBars = new ArrayList<ScrollBar>();
    private final TextBoxGroup textBoxes = new TextBoxGroup();

    public Graphic() {
        this.addClickable(this.textBoxes);
    }

    public final void drawFull(GuiGraphics graphics, int mX, int mY) {
        this.draw(graphics, mX, mY);
        this.drawTooltip(graphics, mX, mY);
    }

    public void draw(GuiGraphics graphics, int mX, int mY) {
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        for (Drawable drawable : this.drawables) {
            drawable.render(graphics, mX, mY);
        }
    }

    public void drawTooltip(GuiGraphics graphics, int mX, int mY) {
        for (Drawable drawable : this.drawables) {
            drawable.renderTooltip(graphics, mX, mY);
        }
    }

    public void onClick(int mX, int mY, int b) {
        for (Clickable clickable : this.clickables) {
            if (!clickable.onClick(mX, mY)) continue;
            return;
        }
    }

    public boolean keyPressed(int keyCode) {
        return this.textBoxes.onKeyStroke(keyCode);
    }

    public boolean charTyped(char c) {
        return this.textBoxes.onCharTyped(c);
    }

    public void onDrag(int mX, int mY, int b) {
        for (Clickable clickable : this.clickables) {
            if (!clickable.onDrag(mX, mY)) continue;
            return;
        }
    }

    public void onRelease(int mX, int mY, int b) {
        for (Clickable clickable : this.clickables) {
            if (!clickable.onRelease(mX, mY)) continue;
            return;
        }
    }

    public void onScroll(double x, double y, double scroll) {
        for (ScrollBar scrollBar : this.scrollBars) {
            scrollBar.onScroll(x, y, scroll);
        }
    }

    protected void addScrollBar(ScrollBar scrollBar) {
        this.addClickable(scrollBar);
        this.scrollBars.add(scrollBar);
    }

    protected void addTextBox(TextBox box) {
        this.textBoxes.add(box);
    }

    protected <T extends Drawable & Clickable> void addClickable(T widget) {
        this.drawables.add(widget);
        this.clickables.add(widget);
    }

    protected void reloadTextBoxes() {
        this.textBoxes.getTextBoxes().forEach(TextBox::reloadText);
    }
}

