/*
 * Decompiled with CFR 0.152.
 */
package hardcorequesting.common.forge.client.interfaces.graphic;

import com.mojang.blaze3d.platform.NativeImage;
import hardcorequesting.common.forge.HardcoreQuestingCore;
import hardcorequesting.common.forge.client.BookPage;
import hardcorequesting.common.forge.client.EditMode;
import hardcorequesting.common.forge.client.interfaces.GuiQuestBook;
import hardcorequesting.common.forge.client.interfaces.ResourceHelper;
import hardcorequesting.common.forge.client.interfaces.edit.TextMenu;
import hardcorequesting.common.forge.client.interfaces.graphic.EditableGraphic;
import hardcorequesting.common.forge.client.interfaces.widget.ExtendedScrollBar;
import hardcorequesting.common.forge.client.interfaces.widget.ScrollBar;
import hardcorequesting.common.forge.client.sounds.SoundHandler;
import hardcorequesting.common.forge.quests.Quest;
import hardcorequesting.common.forge.quests.QuestLine;
import hardcorequesting.common.forge.util.Translator;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.texture.DynamicTexture;
import net.minecraft.network.chat.FormattedText;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class MainPageGraphic
extends EditableGraphic {
    private static final String FRONT_KEY = "hqm_front_texture";
    private static final int DESCRIPTION_X = 180;
    private static final int DESCRIPTION_Y = 20;
    public static final int VISIBLE_MAIN_DESCRIPTION_LINES = 21;
    private final ExtendedScrollBar<FormattedText> mainDescriptionScroll;
    private List<FormattedText> cachedMainDescription;

    public MainPageGraphic(GuiQuestBook gui) {
        super(gui, EditMode.NORMAL, EditMode.RENAME);
        this.mainDescriptionScroll = new ExtendedScrollBar(gui, ScrollBar.Size.LONG, 312, 18, 180, 21, this::getDescriptionLines);
        this.addScrollBar(this.mainDescriptionScroll);
    }

    @Override
    public void draw(GuiGraphics graphics, int mX, int mY) {
        super.draw(graphics, mX, mY);
        QuestLine questLine = QuestLine.getActiveQuestLine();
        this.gui.drawString(graphics, this.mainDescriptionScroll.getVisibleEntries(), 180, 20, 0.7f, 0x404040);
        this.gui.drawCenteredString(graphics, (FormattedText)Translator.translatable("hqm.questBook.start", new Object[0]), 0, 195, 0.7f, 170, 39, 0x707070);
        if (SoundHandler.hasLoreMusic() && !SoundHandler.isLorePlaying()) {
            this.gui.drawCenteredString(graphics, (FormattedText)Translator.translatable("hqm.questBook.playAgain", new Object[0]), 170, 195, 0.7f, 160, 39, 0x707070);
        }
        if (questLine.front == null) {
            File file = new File(HardcoreQuestingCore.configDir.toFile(), "front.png");
            if (file.exists()) {
                try {
                    NativeImage img = NativeImage.m_85058_((InputStream)new FileInputStream(file));
                    DynamicTexture dm = new DynamicTexture(img);
                    questLine.front = Minecraft.m_91087_().m_91097_().m_118490_(FRONT_KEY, dm);
                }
                catch (IOException ignored) {
                    questLine.front = ResourceHelper.getResource("front");
                }
            } else {
                questLine.front = ResourceHelper.getResource("front");
            }
        }
        if (questLine.front != null) {
            this.gui.applyColor(-1);
            this.gui.drawRect(graphics, questLine.front, 20, 20, 0, 0, 140, 180);
        }
    }

    @Override
    public void onClick(int mX, int mY, int button) {
        super.onClick(mX, mY, button);
        if (mX > 0 && mX < 170 && mY > 205) {
            this.gui.setPage(BookPage.MenuPage.INSTANCE);
            SoundHandler.stopLoreMusic();
        } else if (mX > 170 && mX < 340 && mY > 205) {
            if (SoundHandler.hasLoreMusic() && !SoundHandler.isLorePlaying()) {
                SoundHandler.playLoreMusic();
            }
        } else if (Quest.canQuestsBeEdited() && this.gui.getCurrentMode() == EditMode.RENAME && this.gui.inBounds(180, 20, 130, 132, mX, mY)) {
            TextMenu.display(this.gui, Quest.getRawMainDescription(), false, desc -> {
                QuestLine.getActiveQuestLine().setMainDescription((String)desc);
                this.cachedMainDescription = null;
            });
        }
    }

    private List<FormattedText> getDescriptionLines() {
        if (this.cachedMainDescription == null) {
            this.cachedMainDescription = this.gui.getLinesFromText(Translator.plain(Quest.getRawMainDescription()), 0.7f, 130);
        }
        return this.cachedMainDescription;
    }
}

