/*
 * Decompiled with CFR 0.152.
 */
package hardcorequesting.common.forge.client.interfaces.graphic;

import com.mojang.blaze3d.systems.RenderSystem;
import hardcorequesting.common.forge.client.BookPage;
import hardcorequesting.common.forge.client.EditMode;
import hardcorequesting.common.forge.client.interfaces.GuiQuestBook;
import hardcorequesting.common.forge.client.interfaces.ResourceHelper;
import hardcorequesting.common.forge.client.interfaces.graphic.EditableGraphic;
import hardcorequesting.common.forge.client.interfaces.graphic.QuestSetsGraphic;
import hardcorequesting.common.forge.client.interfaces.widget.ExtendedScrollBar;
import hardcorequesting.common.forge.client.interfaces.widget.LargeButton;
import hardcorequesting.common.forge.client.interfaces.widget.ScrollBar;
import hardcorequesting.common.forge.config.HQMConfig;
import hardcorequesting.common.forge.death.DeathStatsManager;
import hardcorequesting.common.forge.items.ModItems;
import hardcorequesting.common.forge.quests.QuestingDataManager;
import hardcorequesting.common.forge.reputation.Reputation;
import hardcorequesting.common.forge.reputation.ReputationManager;
import hardcorequesting.common.forge.team.PlayerEntry;
import hardcorequesting.common.forge.team.Team;
import hardcorequesting.common.forge.util.OPBookHelper;
import hardcorequesting.common.forge.util.Translator;
import java.util.List;
import java.util.UUID;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;

public class MenuPageGraphic
extends EditableGraphic {
    private static final int VISIBLE_DISPLAY_REPUTATIONS = 4;
    private static final int INFO_RIGHT_X = 180;
    private static final int INFO_LIVES_Y = 20;
    private static final int INFO_DEATHS_Y = 55;
    private static final int INFO_TEAM_Y = 95;
    private static final int INFO_LEFT_X = 20;
    private static final int INFO_QUESTS_Y = 20;
    private static final int INFO_REPUTATION_Y = 110;
    private static final int INFO_HEARTS_X = 5;
    private static final int INFO_HEARTS_Y = 12;
    private static final int INFO_HEARTS_SPACING = 18;
    private static final int TEAM_TEXT_Y = 12;
    private static final int TEAM_CLICK_TEXT_Y = 30;
    private static final int DEATH_TEXT_Y = 0;
    private static final int DEATH_CLICK_TEXT_Y = 10;
    private static final int QUEST_CLICK_TEXT_Y = 67;
    private static final int INFO_REPUTATION_OFFSET_X = 5;
    private static final int INFO_REPUTATION_OFFSET_Y = 12;
    private static final int REPUTATION_OFFSET_Y = 24;
    private final ExtendedScrollBar<Reputation> reputationDisplayScroll;

    public MenuPageGraphic(GuiQuestBook gui) {
        super(gui, EditMode.NORMAL, EditMode.BAG, EditMode.REPUTATION);
        this.addClickable(new LargeButton(this.gui, "Reset", 90, 190){

            @Override
            public boolean isEnabled() {
                return Screen.m_96637_() && Screen.m_96638_();
            }

            @Override
            public boolean isVisible() {
                return MenuPageGraphic.this.gui.isOpBook;
            }

            @Override
            public void onClick() {
                OPBookHelper.reset(MenuPageGraphic.this.gui.getPlayer().m_20148_());
            }
        });
        this.reputationDisplayScroll = new ExtendedScrollBar(gui, ScrollBar.Size.NORMAL, 160, 125, 20, 4, () -> ReputationManager.getInstance().getReputationList());
        this.addScrollBar(this.reputationDisplayScroll);
    }

    @Override
    public void draw(GuiGraphics graphics, int mX, int mY) {
        MutableComponent str;
        super.draw(graphics, mX, mY);
        Player player = this.gui.getPlayer();
        QuestingDataManager manager = QuestingDataManager.getInstance();
        this.gui.drawString(graphics, (FormattedText)Translator.translatable("hqm.questBook.lives", new Object[0]), 180, 20, 0x404040);
        if (HQMConfig.getInstance().ENABLE_TEAMS) {
            this.gui.drawString(graphics, (FormattedText)Translator.translatable("hqm.questBook.party", new Object[0]), 180, 95, 0x404040);
        }
        this.gui.drawString(graphics, (FormattedText)Translator.translatable("hqm.questBook.quests", new Object[0]), 20, 20, 0x404040);
        this.gui.drawString(graphics, (FormattedText)Translator.translatable("hqm.questBook.reputation", new Object[0]), 20, 110, 0x404040);
        QuestSetsGraphic.drawQuestInfo(graphics, this.gui, null, 20, 33);
        this.gui.drawString(graphics, (FormattedText)Translator.translatable("hqm.questBook.showQuests", new Object[0]), 20, 87, 0.7f, 0x707070);
        if (manager.isHardcoreActive()) {
            int spacing;
            int count;
            int heartX;
            boolean almostOut;
            boolean bl = almostOut = manager.getQuestingData(player).getLives() == manager.getQuestingData(player).getLivesToStayAlive();
            if (almostOut) {
                this.gui.drawString(graphics, (FormattedText)Translator.translatable("hqm.questBook.deadOut", new Object[0]).m_130940_(ChatFormatting.DARK_RED), 230, 22, 0.7f, 0x404040);
            }
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            int lives = manager.getQuestingData(player).getLives();
            if (lives < 8) {
                heartX = 185;
                count = lives;
                spacing = 18;
            } else {
                heartX = 205;
                count = 3;
                spacing = 3;
                this.gui.drawString(graphics, Translator.plain(lives + " x"), 185, 37, 0.7f, 0x404040);
            }
            for (int i = 0; i < count; ++i) {
                this.gui.drawItemStack(graphics, new ItemStack((ItemLike)ModItems.heart.get(), 1), heartX + spacing * i, 32, almostOut);
            }
        } else {
            this.gui.drawString(graphics, this.gui.getLinesFromText((FormattedText)Translator.translatable("hqm.questBook.infiniteLives", new Object[0]), 0.5f, 140), 180, 32, 0.5f, 0x707070);
        }
        int deaths = DeathStatsManager.getInstance().getDeathStat(player.m_20148_()).getTotalDeaths();
        this.gui.drawString(graphics, (FormattedText)Translator.translatable("hqm.questBook.deaths", Translator.plural("hqm.times", deaths)), 180, 55, 0.7f, 0x404040);
        this.gui.drawString(graphics, (FormattedText)Translator.translatable("hqm.questBook.moreInfo", new Object[0]), 180, 65, 0.7f, 0x707070);
        if (!HQMConfig.getInstance().ENABLE_TEAMS) {
            return;
        }
        Team team = manager.getQuestingData(player).getTeam();
        if (team.isSingle()) {
            int invites;
            int n = invites = team.getInvites() == null ? 0 : team.getInvites().size();
            str = invites > 0 ? Translator.translatable("hqm.questBook.invites", Translator.plural("hqm.invite", invites)) : Translator.translatable("hqm.questBook.notInParty", new Object[0]);
        } else {
            int players = 0;
            for (PlayerEntry teamPlayer : team.getPlayers()) {
                if (!teamPlayer.isInTeam()) continue;
                ++players;
            }
            str = Translator.translatable("hqm.questBook.inParty", Translator.player(players));
        }
        this.gui.drawString(graphics, (FormattedText)str, 180, 107, 0.7f, 0x404040);
        this.gui.drawString(graphics, (FormattedText)Translator.translatable("hqm.questBook.openParty", new Object[0]), 180, 125, 0.7f, 0x707070);
        if (this.gui.isOpBook) {
            this.gui.drawString(graphics, (FormattedText)Translator.translatable("hqm.questBook.resetParty", new Object[0]), 22, 182, 0.6f, 0x404040);
            this.gui.drawString(graphics, this.gui.getLinesFromText((FormattedText)Translator.translatable("hqm.questBook.shiftCtrlConfirm", new Object[0]), 0.6f, 70), 22, 192, 0.6f, 0xFF5555);
        }
        this.drawReputations(graphics, this.gui, mX, mY, player.m_20148_());
    }

    private void drawReputations(GuiGraphics graphics, GuiQuestBook gui, int mX, int mY, UUID playerId) {
        FormattedText info = null;
        List<Reputation> reputations = ReputationManager.getInstance().getReputationList();
        reputations.sort((reputation1, reputation2) -> Integer.compare(Math.abs(reputation2.getValue(playerId)), Math.abs(reputation1.getValue(playerId))));
        int repY = 122;
        for (Reputation reputation : this.reputationDisplayScroll.getVisibleEntries()) {
            gui.applyColor(-1);
            ResourceHelper.bindResource(GuiQuestBook.MAP_TEXTURE);
            info = reputation.drawAndGetTooltip(graphics, gui, 25, repY, mX, mY, info, playerId, false, null, null, false, null, null, false);
            repY += 24;
        }
        if (info != null) {
            gui.renderTooltip(graphics, info, mX + gui.getLeft(), mY + gui.getTop());
        }
    }

    @Override
    public void onClick(int mX, int mY, int button) {
        super.onClick(mX, mY, button);
        if (HQMConfig.getInstance().ENABLE_TEAMS && this.gui.inBounds(180, 125, 170, 6, mX, mY)) {
            this.gui.setPage(BookPage.TeamPage.INSTANCE);
        } else if (this.gui.inBounds(180, 65, 170, 6, mX, mY)) {
            this.gui.setPage(BookPage.DeathInfoPage.INSTANCE);
        } else if (this.gui.inBounds(20, 87, 170, 6, mX, mY)) {
            this.gui.setPage(BookPage.SetsPage.INSTANCE);
        }
    }

    @Override
    protected void setEditMode(EditMode mode) {
        if (mode == EditMode.BAG) {
            this.gui.setPage(BookPage.BagsPage.INSTANCE);
        } else if (mode == EditMode.REPUTATION) {
            this.gui.setPage(BookPage.ReputationPage.INSTANCE);
        } else {
            super.setEditMode(mode);
        }
    }
}

