/*
 * Decompiled with CFR 0.152.
 */
package hardcorequesting.common.forge.client.interfaces.graphic;

import hardcorequesting.common.forge.client.EditMode;
import hardcorequesting.common.forge.client.interfaces.GuiQuestBook;
import hardcorequesting.common.forge.client.interfaces.edit.EditCommandRewardsMenu;
import hardcorequesting.common.forge.client.interfaces.edit.WrappedTextMenu;
import hardcorequesting.common.forge.client.interfaces.graphic.EditableGraphic;
import hardcorequesting.common.forge.client.interfaces.graphic.QuestRewardsGraphic;
import hardcorequesting.common.forge.client.interfaces.graphic.task.TaskGraphic;
import hardcorequesting.common.forge.client.interfaces.graphic.task.TaskGraphics;
import hardcorequesting.common.forge.client.interfaces.widget.ExtendedScrollBar;
import hardcorequesting.common.forge.client.interfaces.widget.LargeButton;
import hardcorequesting.common.forge.client.interfaces.widget.ScrollBar;
import hardcorequesting.common.forge.event.EventTrigger;
import hardcorequesting.common.forge.network.GeneralUsage;
import hardcorequesting.common.forge.quests.Quest;
import hardcorequesting.common.forge.quests.QuestingDataManager;
import hardcorequesting.common.forge.quests.task.QuestTask;
import hardcorequesting.common.forge.quests.task.TaskType;
import hardcorequesting.common.forge.util.EditType;
import hardcorequesting.common.forge.util.OPBookHelper;
import hardcorequesting.common.forge.util.SaveHelper;
import hardcorequesting.common.forge.util.Translator;
import hardcorequesting.common.forge.util.WrappedText;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.Nullable;

@OnlyIn(value=Dist.CLIENT)
public final class QuestGraphic
extends EditableGraphic {
    private static final int VISIBLE_DESCRIPTION_LINES = 7;
    private static final int VISIBLE_TASKS = 3;
    public static final int START_X = 20;
    private static final int TASK_LABEL_START_Y = 100;
    private static final int TASK_MARGIN = 2;
    private static final int TITLE_START_Y = 15;
    private static final int DESCRIPTION_START_Y = 30;
    private static final int TASK_SELECTION_ROWS = 8;
    private static final int TASK_SELECTION_COLUMNS = 2;
    private final UUID playerId;
    private final Quest quest;
    private QuestTask<?> selectedTask;
    private TaskGraphic taskGraphic;
    private final QuestRewardsGraphic rewardsGraphic;
    private final ExtendedScrollBar<FormattedText> descriptionScroll;
    private final ScrollBar taskScroll;
    private List<TaskType<?>> visibleTaskTypes;
    private List<FormattedText> cachedDescription;

    public QuestGraphic(UUID playerId, final Quest quest, GuiQuestBook gui) {
        super(gui, EditMode.NORMAL, EditMode.RENAME, EditMode.TASK, EditMode.ITEM, EditMode.LOCATION, EditMode.MOB, EditMode.REPUTATION_TASK, EditMode.REPUTATION_REWARD, EditMode.COMMAND_CREATE, EditMode.COMMAND_CHANGE, EditMode.DELETE);
        this.playerId = playerId;
        this.quest = quest;
        this.rewardsGraphic = new QuestRewardsGraphic(quest, playerId, gui);
        this.onOpen(gui.getPlayer());
        this.descriptionScroll = new ExtendedScrollBar(gui, ScrollBar.Size.SMALL, 155, 28, 20, 7, this::getCachedDescription);
        this.addScrollBar(this.descriptionScroll);
        this.taskScroll = new ScrollBar(gui, ScrollBar.Size.TINY, 155, 100, 20){

            @Override
            public boolean isVisible() {
                return quest.getTasks().size() > 3 && QuestGraphic.this.getVisibleTasks() > 3;
            }
        };
        this.addScrollBar(this.taskScroll);
        ArrayList taskTypes = new ArrayList(TaskType.values());
        this.visibleTaskTypes = taskTypes;
        int buttons = Math.min(TaskType.values().size(), 16);
        for (int ordinal = 0; ordinal < buttons; ++ordinal) {
            final int i = ordinal;
            this.addClickable(new LargeButton(gui, null, null, 185 + ordinal % 2 * 65, 44 + ordinal / 2 * 20){

                @Override
                public boolean isVisible() {
                    return QuestGraphic.this.isSelectingTaskType() && i < QuestGraphic.this.visibleTaskTypes.size();
                }

                @Override
                protected FormattedText getName() {
                    return QuestGraphic.this.visibleTaskTypes.get(i).getName();
                }

                @Override
                protected FormattedText getDescription() {
                    return QuestGraphic.this.visibleTaskTypes.get(i).getDescription();
                }

                @Override
                public void onClick() {
                    QuestGraphic.this.visibleTaskTypes.get(i).addTask(quest);
                }
            });
        }
        this.addScrollBar(new ExtendedScrollBar<TaskType<?>>(gui, ScrollBar.Size.LONG, 313, 30, 185, 8, 2, () -> taskTypes){

            @Override
            public boolean isVisible() {
                return super.isVisible() && QuestGraphic.this.isSelectingTaskType();
            }

            @Override
            protected void onUpdate() {
                QuestGraphic.this.visibleTaskTypes = this.getVisibleEntries();
            }
        });
    }

    private boolean isSelectingTaskType() {
        return Quest.canQuestsBeEdited() && this.selectedTask == null && this.gui.getCurrentMode() == EditMode.TASK;
    }

    private List<FormattedText> getCachedDescription() {
        if (this.cachedDescription == null) {
            this.cachedDescription = this.gui.getLinesFromText((FormattedText)this.quest.getDescription().getText(), 0.7f, 130);
        }
        return this.cachedDescription;
    }

    @Override
    public void draw(GuiGraphics graphics, int mX, int mY) {
        if (!Quest.canQuestsBeEdited() && this.selectedTask != null && !this.selectedTask.isVisible(this.playerId)) {
            this.setSelectedTask(this.quest.getTasks().size() > 0 ? this.quest.getTasks().get(0) : null);
        }
        this.gui.drawString(graphics, (FormattedText)this.quest.getName(), 20, 15, 0x404040);
        List<FormattedText> description = this.descriptionScroll.getVisibleEntries();
        this.gui.drawString(graphics, description, 20, 30, 0.7f, 0x404040);
        int id = 0;
        for (QuestTask<?> task : this.taskScroll.getVisibleEntries(this.quest.getTasks(), 3)) {
            boolean isVisible = task.isVisible(this.playerId);
            if (!isVisible && !Quest.canQuestsBeEdited()) continue;
            boolean completed = task.isCompleted(this.playerId);
            int yPos = this.getTaskY(id);
            boolean inBounds = this.gui.inBounds(20, yPos, this.gui.getStringWidth((FormattedText)task.getName()), 9, mX, mY);
            boolean isSelected = task == this.selectedTask;
            this.gui.drawString(graphics, (FormattedText)task.getName(), 20, yPos, completed ? (isSelected ? (inBounds ? 0x40BB40 : 0x40A040) : (inBounds ? 0x10A010 : 0x107010)) : (isSelected ? (inBounds ? 0xAAAAAA : 0x888888) : (inBounds ? 0x666666 : (isVisible ? 0x404040 : 0xDDDDDD))));
            ++id;
        }
        super.draw(graphics, mX, mY);
        this.rewardsGraphic.draw(graphics, mX, mY);
        if (this.taskGraphic != null) {
            this.taskGraphic.draw(graphics, mX, mY);
        } else if (Quest.canQuestsBeEdited() && this.gui.getCurrentMode() == EditMode.TASK) {
            this.gui.drawString(graphics, this.gui.getLinesFromText((FormattedText)Translator.translatable("hqm.quest.createTasks", new Object[0]), 0.7f, 130), 180, 20, 0.7f, 0x404040);
        }
    }

    @Override
    public void drawTooltip(GuiGraphics graphics, int mX, int mY) {
        super.drawTooltip(graphics, mX, mY);
        if (this.taskGraphic != null) {
            this.taskGraphic.drawTooltip(graphics, mX, mY);
        }
        this.rewardsGraphic.drawTooltip(graphics, mX, mY);
    }

    private int getVisibleTasks() {
        if (Quest.canQuestsBeEdited()) {
            return this.quest.getTasks().size();
        }
        int count = 0;
        for (QuestTask<?> task : this.quest.getTasks()) {
            if (!task.isVisible(this.playerId)) continue;
            ++count;
        }
        return count;
    }

    private int getTaskY(int id) {
        return 100 + id * 11;
    }

    @Override
    public void onClick(int mX, int mY, int b) {
        int id = 0;
        for (QuestTask<?> task : this.taskScroll.getVisibleEntries(this.quest.getTasks(), 3)) {
            if (!task.isVisible(this.playerId) && !Quest.canQuestsBeEdited()) continue;
            if (this.gui.inBounds(20, this.getTaskY(id), this.gui.getStringWidth((FormattedText)task.getName()), 9, mX, mY)) {
                if (this.gui.isOpBook && Screen.m_96638_()) {
                    OPBookHelper.reverseTaskCompletion(task, this.playerId);
                    return;
                }
                if (Quest.canQuestsBeEdited() && this.gui.getCurrentMode() == EditMode.TASK) {
                    this.gui.setCurrentMode(EditMode.NORMAL);
                }
                if (Quest.canQuestsBeEdited() && (this.gui.getCurrentMode() == EditMode.RENAME || this.gui.getCurrentMode() == EditMode.DELETE)) {
                    if (this.gui.getCurrentMode() == EditMode.RENAME) {
                        WrappedTextMenu.display(this.gui, task.getRawName(), true, task::setName);
                        break;
                    }
                    if (this.gui.getCurrentMode() != EditMode.DELETE) break;
                    if (this.selectedTask == task) {
                        this.setSelectedTask(null);
                    }
                    this.quest.removeTask(task);
                    SaveHelper.add(EditType.TASK_REMOVE);
                    break;
                }
                if (task == this.selectedTask) {
                    this.setSelectedTask(null);
                    break;
                }
                this.setSelectedTask(task);
                break;
            }
            ++id;
        }
        this.rewardsGraphic.onClick(mX, mY, b);
        if (this.taskGraphic != null) {
            this.taskGraphic.onClick(mX, mY, b);
        }
        super.onClick(mX, mY, b);
        if (this.gui.getCurrentMode() == EditMode.RENAME) {
            if (this.gui.inBounds(20, 15, 140, 9, mX, mY)) {
                WrappedTextMenu.display(this.gui, this.quest.getRawName(), true, this.quest::setName);
            } else if (this.gui.inBounds(20, 30, 130, 44, mX, mY)) {
                WrappedTextMenu.display(this.gui, this.quest.getDescription(), false, description -> {
                    this.cachedDescription = null;
                    this.quest.setDescription((WrappedText)description);
                });
            }
        }
        if (Quest.canQuestsBeEdited() && this.selectedTask != null && this.gui.getCurrentMode() == EditMode.TASK) {
            this.setSelectedTask(null);
        }
    }

    @Override
    public void onDrag(int mX, int mY, int b) {
        super.onDrag(mX, mY, b);
        this.rewardsGraphic.onDrag(mX, mY, b);
        if (this.taskGraphic != null) {
            this.taskGraphic.onDrag(mX, mY, b);
        }
    }

    @Override
    public void onRelease(int mX, int mY, int b) {
        super.onRelease(mX, mY, b);
        this.rewardsGraphic.onRelease(mX, mY, b);
        if (this.taskGraphic != null) {
            this.taskGraphic.onRelease(mX, mY, b);
        }
    }

    @Override
    public void onScroll(double mX, double mY, double scroll) {
        super.onScroll(mX, mY, scroll);
        this.rewardsGraphic.onScroll(mX, mY, scroll);
        if (this.taskGraphic != null) {
            this.taskGraphic.onScroll(mX, mY, scroll);
        }
    }

    @Override
    public boolean keyPressed(int keyCode) {
        return super.keyPressed(keyCode) || this.rewardsGraphic.keyPressed(keyCode) || this.taskGraphic != null && this.taskGraphic.keyPressed(keyCode);
    }

    @Override
    public boolean charTyped(char c) {
        return super.charTyped(c) || this.rewardsGraphic.charTyped(c) || this.taskGraphic != null && this.taskGraphic.charTyped(c);
    }

    public void onOpen(Player player) {
        if (this.selectedTask == null) {
            for (QuestTask<?> task : this.quest.getTasks()) {
                if (task.isCompleted(this.playerId)) continue;
                this.setSelectedTask(task);
                break;
            }
        }
        if (this.selectedTask == null && this.quest.getTasks().size() > 0) {
            this.setSelectedTask(this.quest.getTasks().get(0));
        }
        QuestingDataManager.getInstance().getQuestingData((UUID)this.playerId).selectedQuestId = this.quest.getQuestId();
        int n = QuestingDataManager.getInstance().getQuestingData((UUID)this.playerId).selectedTask = this.selectedTask == null ? -1 : this.selectedTask.getId();
        if (this.selectedTask != null) {
            GeneralUsage.sendBookSelectTaskUpdate(this.selectedTask);
        }
        EventTrigger.instance().onQuestSelected(new EventTrigger.QuestSelectedEvent(player, this.quest.getQuestId()));
    }

    private void setSelectedTask(@Nullable QuestTask<?> task) {
        this.selectedTask = task;
        this.taskGraphic = task == null ? null : TaskGraphics.create(task, this.playerId, this.gui);
    }

    @Override
    protected void setEditMode(EditMode editMode) {
        if (editMode == EditMode.COMMAND_CREATE || editMode == EditMode.COMMAND_CHANGE) {
            EditCommandRewardsMenu.display(this.gui, this.quest);
        } else {
            super.setEditMode(editMode);
        }
    }
}

