/*
 * Decompiled with CFR 0.152.
 */
package hardcorequesting.common.forge.client.interfaces.graphic;

import com.mojang.blaze3d.systems.RenderSystem;
import hardcorequesting.common.forge.client.ClientChange;
import hardcorequesting.common.forge.client.EditMode;
import hardcorequesting.common.forge.client.interfaces.GuiBase;
import hardcorequesting.common.forge.client.interfaces.GuiQuestBook;
import hardcorequesting.common.forge.client.interfaces.edit.PickItemMenu;
import hardcorequesting.common.forge.client.interfaces.edit.ReputationRewardMenu;
import hardcorequesting.common.forge.client.interfaces.graphic.Graphic;
import hardcorequesting.common.forge.client.interfaces.widget.LargeButton;
import hardcorequesting.common.forge.network.NetworkManager;
import hardcorequesting.common.forge.quests.Quest;
import hardcorequesting.common.forge.quests.data.QuestData;
import hardcorequesting.common.forge.quests.reward.QuestRewards;
import hardcorequesting.common.forge.quests.reward.ReputationReward;
import hardcorequesting.common.forge.reputation.Reputation;
import hardcorequesting.common.forge.util.EditType;
import hardcorequesting.common.forge.util.SaveHelper;
import hardcorequesting.common.forge.util.Translator;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.core.NonNullList;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.util.Tuple;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class QuestRewardsGraphic
extends Graphic {
    public static final int START_X = 20;
    private static final int REWARD_STR_Y = 140;
    private static final int REWARD_Y = 150;
    private static final int REWARD_Y_OFFSET = 40;
    private static final int REWARD_OFFSET = 20;
    private static final int ITEM_SIZE = 18;
    private static final int MAX_REWARD_SLOTS = 7;
    private static final int MAX_SELECT_REWARD_SLOTS = 4;
    private static final int REPUTATION_X = 142;
    private static final int REPUTATION_Y = 133;
    private static final int REPUTATION_Y_LOWER = 150;
    private static final int REPUTATION_SIZE = 16;
    private static final int REPUTATION_SRC_X = 30;
    private static final int REPUTATION_SRC_Y = 82;
    private int selectedReward = -1;
    private long lastClicked;
    private final Quest quest;
    private final QuestRewards rewards;
    private final UUID playerId;
    private final GuiQuestBook gui;

    public QuestRewardsGraphic(final Quest quest, final UUID playerId, GuiQuestBook gui) {
        this.quest = quest;
        this.rewards = quest.getRewards();
        this.playerId = playerId;
        this.gui = gui;
        this.addClickable(new LargeButton(gui, "hqm.quest.claim", 100, 190){

            @Override
            public boolean isEnabled() {
                return QuestRewardsGraphic.this.rewards.hasReward(playerId) && (!QuestRewardsGraphic.this.rewards.hasChoiceReward() || QuestRewardsGraphic.this.selectedReward != -1) && quest.isEnabled(playerId);
            }

            @Override
            public boolean isVisible() {
                return QuestRewardsGraphic.this.rewards.hasReward(playerId);
            }

            @Override
            public void onClick() {
                NetworkManager.sendToServer(ClientChange.CLAIM_QUEST.build(new Tuple((Object)quest.getQuestId(), (Object)(QuestRewardsGraphic.this.rewards.hasChoiceReward() ? QuestRewardsGraphic.this.selectedReward : -1))));
            }
        });
    }

    @Override
    public void draw(GuiGraphics graphics, int mX, int mY) {
        QuestData data = this.quest.getQuestData(this.playerId);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        if (this.selectedReward != -1 && !this.rewards.hasReward(data, this.playerId)) {
            this.selectedReward = -1;
        }
        this.drawItemRewards(graphics, mX, mY);
        super.draw(graphics, mX, mY);
        this.drawReputationIcon(graphics, mX, mY, data);
    }

    @Override
    public void drawTooltip(GuiGraphics graphics, int mX, int mY) {
        this.drawItemRewardTooltips(graphics, mX, mY);
        super.drawTooltip(graphics, mX, mY);
        this.drawRepIconTooltip(graphics, mX, mY);
    }

    private void drawItemRewards(GuiGraphics graphics, int mX, int mY) {
        NonNullList<ItemStack> itemRewards = this.rewards.getReward();
        NonNullList<ItemStack> choiceRewards = this.rewards.getRewardChoice();
        if (!itemRewards.isEmpty() || Quest.canQuestsBeEdited()) {
            this.gui.drawString(graphics, (FormattedText)Translator.translatable("hqm.quest.rewards", new Object[0]), 20, 140, 0x404040);
            this.drawRewards(graphics, this.gui, itemRewards, 150, -1, mX, mY, 7);
            if (!choiceRewards.isEmpty() || Quest.canQuestsBeEdited()) {
                this.gui.drawString(graphics, (FormattedText)Translator.translatable("hqm.quest.pickOne", new Object[0]), 20, 180, 0x404040);
                this.drawRewards(graphics, this.gui, choiceRewards, 190, this.selectedReward, mX, mY, 4);
            }
        } else if (!choiceRewards.isEmpty()) {
            this.gui.drawString(graphics, (FormattedText)Translator.translatable("hqm.quest.pickOneReward", new Object[0]), 20, 140, 0x404040);
            this.drawRewards(graphics, this.gui, choiceRewards, 150, this.selectedReward, mX, mY, 4);
        }
    }

    private void drawItemRewardTooltips(GuiGraphics graphics, int mX, int mY) {
        NonNullList<ItemStack> itemRewards = this.rewards.getReward();
        NonNullList<ItemStack> choiceRewards = this.rewards.getRewardChoice();
        if (!itemRewards.isEmpty() || Quest.canQuestsBeEdited()) {
            this.drawRewardMouseOver(graphics, this.gui, itemRewards, 150, -1, mX, mY);
            if (!choiceRewards.isEmpty() || Quest.canQuestsBeEdited()) {
                this.drawRewardMouseOver(graphics, this.gui, choiceRewards, 190, this.selectedReward, mX, mY);
            }
        } else if (!choiceRewards.isEmpty()) {
            this.drawRewardMouseOver(graphics, this.gui, choiceRewards, 150, this.selectedReward, mX, mY);
        }
    }

    private void drawReputationIcon(GuiGraphics graphics, int mX, int mY, QuestData data) {
        List<ReputationReward> reputationRewards = this.rewards.getReputationRewards();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        if (reputationRewards != null || Quest.canQuestsBeEdited()) {
            int backgroundIndex;
            boolean claimed;
            boolean bl = claimed = data.teamRewardClaimed || reputationRewards == null;
            int n = claimed ? 2 : (backgroundIndex = this.isOnReputationIcon(this.gui, mX, mY) ? 1 : 0);
            if (claimed) {
                foregroundIndex = 3;
            } else {
                boolean positive = false;
                boolean negative = false;
                for (ReputationReward reputationReward : reputationRewards) {
                    if (reputationReward.getValue() < 0) {
                        negative = true;
                        continue;
                    }
                    if (reputationReward.getValue() <= 0) continue;
                    positive = true;
                }
                foregroundIndex = negative == positive ? 2 : (positive ? 0 : 1);
            }
            int y = this.getRepIconY();
            this.gui.drawRect(graphics, GuiBase.MAP_TEXTURE, 142, y, 30 + backgroundIndex * 16, 82, 16, 16);
            this.gui.drawRect(graphics, GuiBase.MAP_TEXTURE, 142, y, 30 + (foregroundIndex += 3) * 16, 82, 16, 16);
        }
    }

    private void drawRepIconTooltip(GuiGraphics graphics, int mX, int mY) {
        QuestData data = this.quest.getQuestData(this.playerId);
        List<ReputationReward> reputationRewards = this.rewards.getReputationRewards();
        if (reputationRewards != null && this.isOnReputationIcon(this.gui, mX, mY)) {
            ArrayList<Object> str = new ArrayList<Object>();
            for (ReputationReward reputationReward : reputationRewards) {
                if (reputationReward.getValue() == 0 || reputationReward.getReward() == null || !((Reputation)reputationReward.getReward()).isValid()) continue;
                str.add(reputationReward.getLabel());
            }
            List<FormattedText> commentLines = this.gui.getLinesFromText((FormattedText)Translator.translatable("hqm.quest.partyRepReward" + (data.teamRewardClaimed ? "Claimed" : ""), new Object[0]), 1.0f, 200);
            if (commentLines != null) {
                str.add(FormattedText.f_130760_);
                for (FormattedText commentLine : commentLines) {
                    str.add(Translator.text(Translator.rawString(commentLine)).m_130940_(ChatFormatting.DARK_GRAY));
                }
            }
            this.gui.renderTooltipL(graphics, str, mX + this.gui.getLeft(), mY + this.gui.getTop());
        }
    }

    @Override
    public void onClick(int mX, int mY, int b) {
        NonNullList<ItemStack> itemRewards = this.rewards.getReward();
        NonNullList<ItemStack> choiceRewards = this.rewards.getRewardChoice();
        List<ReputationReward> reputationRewards = this.rewards.getReputationRewards();
        if (!itemRewards.isEmpty() || Quest.canQuestsBeEdited()) {
            this.handleRewardClick(this.gui, itemRewards, 150, false, mX, mY);
            if (!choiceRewards.isEmpty() || Quest.canQuestsBeEdited()) {
                this.handleRewardClick(this.gui, choiceRewards, 190, true, mX, mY);
            }
        } else if (!choiceRewards.isEmpty()) {
            this.handleRewardClick(this.gui, choiceRewards, 150, true, mX, mY);
        }
        if (Quest.canQuestsBeEdited() && this.gui.getCurrentMode() == EditMode.REPUTATION_REWARD && this.isOnReputationIcon(this.gui, mX, mY)) {
            ReputationRewardMenu.display(this.gui, reputationRewards, newRewards -> {
                this.rewards.setReputationRewards(newRewards.isEmpty() ? null : newRewards);
                SaveHelper.add(EditType.REPUTATION_REWARD_CHANGE);
            });
        }
        super.onClick(mX, mY, b);
    }

    private NonNullList<ItemStack> getEditFriendlyRewards(NonNullList<ItemStack> rewards, int max) {
        if (rewards.isEmpty()) {
            return NonNullList.m_122780_((int)1, (Object)ItemStack.f_41583_);
        }
        if (Quest.canQuestsBeEdited() && rewards.size() < max) {
            NonNullList rewardsWithEmpty = NonNullList.m_122779_();
            rewardsWithEmpty.addAll(rewards);
            rewardsWithEmpty.add((Object)ItemStack.f_41583_);
            return rewardsWithEmpty;
        }
        return rewards;
    }

    private void drawRewards(GuiGraphics graphics, GuiQuestBook gui, NonNullList<ItemStack> rewards, int y, int selected, int mX, int mY, int max) {
        rewards = this.getEditFriendlyRewards(rewards, max);
        for (int i = 0; i < rewards.size(); ++i) {
            gui.drawItemStack(graphics, (ItemStack)rewards.get(i), 20 + i * 20, y, mX, mY, selected == i);
        }
    }

    private void drawRewardMouseOver(GuiGraphics graphics, GuiQuestBook gui, NonNullList<ItemStack> rewards, int y, int selected, int mX, int mY) {
        if (rewards != null) {
            for (int i = 0; i < rewards.size(); ++i) {
                if (!gui.inBounds(20 + i * 20, y, 18, 18, mX, mY)) continue;
                if (((ItemStack)rewards.get(i)).m_41619_()) break;
                List str = ((ItemStack)rewards.get(i)).m_41651_((Player)Minecraft.m_91087_().f_91074_, (TooltipFlag)(Minecraft.m_91087_().f_91066_.f_92125_ ? TooltipFlag.Default.f_256730_ : TooltipFlag.Default.f_256752_));
                if (selected == i) {
                    str.add(Component.m_237119_());
                    str.add(Translator.translatable("hqm.quest.selected", new Object[0]).m_130940_(ChatFormatting.DARK_GREEN));
                }
                graphics.m_280666_(this.gui.getFont(), str, gui.getLeft() + mX, gui.getTop() + mY);
                break;
            }
        }
    }

    private void handleRewardClick(GuiQuestBook gui, NonNullList<ItemStack> rawRewards, int y, boolean canSelect, int mX, int mY) {
        NonNullList<ItemStack> itemRewards = this.getEditFriendlyRewards(rawRewards, canSelect ? 4 : 7);
        boolean doubleClick = false;
        for (int i = 0; i < itemRewards.size(); ++i) {
            if (!gui.inBounds(20 + i * 20, y, 18, 18, mX, mY)) continue;
            if (gui.getCurrentMode() == EditMode.NORMAL) {
                long tickCount = Minecraft.m_91087_().f_91073_.m_46467_();
                long lastDiff = tickCount - this.lastClicked;
                if (lastDiff < 0L) {
                    this.lastClicked = tickCount;
                } else if (lastDiff < 6L) {
                    doubleClick = true;
                } else {
                    this.lastClicked = tickCount;
                }
            }
            if (canSelect && (!Quest.canQuestsBeEdited() || gui.getCurrentMode() == EditMode.NORMAL && !doubleClick)) {
                if (this.selectedReward == i) {
                    this.selectedReward = -1;
                    break;
                }
                if (((ItemStack)itemRewards.get(i)).m_41619_()) break;
                this.selectedReward = i;
                break;
            }
            if (!Quest.canQuestsBeEdited()) break;
            if (gui.getCurrentMode() == EditMode.DELETE) {
                if (i >= rawRewards.size()) break;
                rawRewards.remove(i);
                if (canSelect && this.selectedReward != -1) {
                    if (this.selectedReward == i) {
                        this.selectedReward = -1;
                    } else if (this.selectedReward > i) {
                        --this.selectedReward;
                    }
                }
                if (canSelect) {
                    this.rewards.setRewardChoice(rawRewards);
                } else {
                    this.rewards.setReward(rawRewards);
                }
                SaveHelper.add(EditType.REWARD_REMOVE);
                break;
            }
            if (gui.getCurrentMode() != EditMode.ITEM && !doubleClick) break;
            int id = i;
            PickItemMenu.display(gui, (ItemStack)itemRewards.get(i), PickItemMenu.Type.ITEM, ((ItemStack)itemRewards.get(i)).m_41619_() ? 1 : ((ItemStack)itemRewards.get(i)).m_41613_(), result -> this.rewards.setItemReward((ItemStack)result.getWithAmount(), id, !canSelect));
            break;
        }
    }

    private int getRepIconY() {
        return this.rewards.getReward().size() <= 7 - (Quest.canQuestsBeEdited() ? 2 : 1) ? 150 : 133;
    }

    private boolean isOnReputationIcon(GuiQuestBook gui, int mX, int mY) {
        return gui.inBounds(142, this.getRepIconY(), 16, 16, mX, mY);
    }
}

