/*
 * Decompiled with CFR 0.152.
 */
package hardcorequesting.common.forge.client.interfaces.graphic;

import com.mojang.blaze3d.platform.InputConstants;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.datafixers.util.Either;
import dev.architectury.fluid.FluidStack;
import hardcorequesting.common.forge.client.BookPage;
import hardcorequesting.common.forge.client.EditMode;
import hardcorequesting.common.forge.client.interfaces.GuiBase;
import hardcorequesting.common.forge.client.interfaces.GuiQuestBook;
import hardcorequesting.common.forge.client.interfaces.edit.PickItemMenu;
import hardcorequesting.common.forge.client.interfaces.edit.PickReputationMenu;
import hardcorequesting.common.forge.client.interfaces.edit.PickTriggerMenu;
import hardcorequesting.common.forge.client.interfaces.edit.RepeatInfoMenu;
import hardcorequesting.common.forge.client.interfaces.edit.RequiredParentCountMenu;
import hardcorequesting.common.forge.client.interfaces.graphic.EditableGraphic;
import hardcorequesting.common.forge.quests.Quest;
import hardcorequesting.common.forge.quests.QuestSet;
import hardcorequesting.common.forge.quests.RepeatInfo;
import hardcorequesting.common.forge.quests.task.QuestTask;
import hardcorequesting.common.forge.reputation.Reputation;
import hardcorequesting.common.forge.reputation.ReputationBar;
import hardcorequesting.common.forge.util.EditType;
import hardcorequesting.common.forge.util.OPBookHelper;
import hardcorequesting.common.forge.util.SaveHelper;
import hardcorequesting.common.forge.util.Translator;
import hardcorequesting.common.forge.util.WrappedText;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class QuestSetMapGraphic
extends EditableGraphic {
    private final QuestSet set;
    private final BookPage.SetMapPage page;
    private Quest draggedQuest;
    private Quest selectedQuest;

    public QuestSetMapGraphic(GuiQuestBook gui, QuestSet set, BookPage.SetMapPage page) {
        super(gui, EditMode.NORMAL, EditMode.MOVE, EditMode.CREATE, EditMode.REQUIREMENT, EditMode.SIZE, EditMode.ITEM, EditMode.REPEATABLE, EditMode.TRIGGER, EditMode.REQUIRED_PARENTS, EditMode.QUEST_SELECTION, EditMode.QUEST_OPTION, EditMode.SWAP, EditMode.REP_BAR_CREATE, EditMode.REP_BAR_CHANGE, EditMode.DELETE);
        this.set = set;
        this.page = page;
    }

    @Override
    public void draw(GuiGraphics graphics, int mX, int mY) {
        super.draw(graphics, mX, mY);
        if (this.gui.isOpBook) {
            this.gui.drawString(graphics, this.gui.getLinesFromText((FormattedText)Translator.translatable("hqm.questBook.shiftSetReset", new Object[0]), 0.7f, 130), 184, 192, 0.7f, 0x707070);
        }
        Player player = this.gui.getPlayer();
        for (ReputationBar bar : this.set.getReputationBars()) {
            bar.draw(graphics, this.gui, mX, mY, player.m_20148_());
        }
        HashMap<Quest, Boolean> isVisibleCache = new HashMap<Quest, Boolean>();
        HashMap<Quest, Boolean> isLinkFreeCache = new HashMap<Quest, Boolean>();
        this.drawConnectingLines(graphics, player, isVisibleCache, isLinkFreeCache);
        this.drawQuestIcons(graphics, mX, mY, player, isVisibleCache, isLinkFreeCache);
    }

    @Override
    public void drawTooltip(GuiGraphics graphics, int mX, int mY) {
        super.drawTooltip(graphics, mX, mY);
        Player player = this.gui.getPlayer();
        HashMap<Quest, Boolean> isVisibleCache = new HashMap<Quest, Boolean>();
        HashMap<Quest, Boolean> isLinkFreeCache = new HashMap<Quest, Boolean>();
        for (Quest quest : this.set.getQuests().values()) {
            boolean editing;
            boolean bl = editing = Quest.canQuestsBeEdited() && !Screen.m_96637_();
            if (!editing && !quest.isVisible(player, isVisibleCache, isLinkFreeCache) || !quest.isMouseInObject(mX, mY)) continue;
            boolean shouldDrawText = false;
            boolean enabled = quest.isEnabled(player, isVisibleCache, isLinkFreeCache);
            ArrayList<FormattedText> tooltip = new ArrayList<FormattedText>();
            if (enabled || editing) {
                tooltip.add((FormattedText)quest.getName());
            }
            if (!enabled) {
                tooltip.add((FormattedText)Translator.translatable("hqm.questBook.lockedQuest", new Object[0]).m_130940_(ChatFormatting.DARK_GRAY));
            }
            if (!enabled || editing) {
                this.addParentTooltip(player.m_20148_(), quest, editing, tooltip);
                shouldDrawText |= this.addExternalParentTooltip(player.m_20148_(), quest, editing, tooltip);
                this.addRequirementTooltip(quest, editing, tooltip);
            }
            if (enabled || editing) {
                if (quest.isCompleted(player)) {
                    tooltip.add((FormattedText)Translator.translatable("hqm.questBook.completed", new Object[0]).m_130940_(ChatFormatting.DARK_GREEN));
                }
                if (quest.hasReward(player.m_20148_())) {
                    tooltip.add((FormattedText)Translator.translatable("hqm.questBook.unclaimedReward", new Object[0]).m_130940_(ChatFormatting.DARK_PURPLE));
                }
                tooltip.addAll(enabled ? quest.getRepeatInfo().getMessage(quest, player) : quest.getRepeatInfo().getShortMessage());
                if (editing) {
                    this.addTaskTooltip(player.m_20148_(), quest, tooltip);
                    quest.getTriggerType().getMessage(quest).ifPresent(tooltip::add);
                    this.addInvisibilityTooltip(player, isVisibleCache, isLinkFreeCache, quest, tooltip);
                    this.addOptionLinkTooltip(quest, tooltip);
                }
                this.addChildTooltip(quest, editing, tooltip);
                shouldDrawText = true;
            }
            if (editing) {
                tooltip.add(FormattedText.f_130760_);
                tooltip.add((FormattedText)Translator.translatable("hqm.questBook.ctrlNonEditor", new Object[0]).m_130940_(ChatFormatting.DARK_GRAY));
            }
            if (this.gui.isOpBook && Screen.m_96638_()) {
                if (quest.isCompleted(player)) {
                    tooltip.add(FormattedText.f_130760_);
                    tooltip.add((FormattedText)Translator.translatable("hqm.questBook.resetQuest", new Object[0]).m_130940_(ChatFormatting.DARK_RED));
                } else {
                    tooltip.add(FormattedText.f_130760_);
                    tooltip.add((FormattedText)Translator.translatable("hqm.questBook.completeQuest", new Object[0]).m_130940_(ChatFormatting.GOLD));
                }
            }
            if (!shouldDrawText || this.gui.getCurrentMode() == EditMode.MOVE) break;
            this.gui.renderTooltipL(graphics, tooltip, mX + this.gui.getLeft(), mY + this.gui.getTop());
            break;
        }
    }

    private int getParentCount(Quest quest) {
        return quest.getRequirements().size();
    }

    private int getCompletedParents(Quest quest, UUID playerId) {
        int completed = 0;
        for (Quest parent : quest.getRequirements()) {
            if (!parent.isCompleted(playerId)) continue;
            ++completed;
        }
        return completed;
    }

    private List<Quest> getExternalQuests(Quest quest) {
        ArrayList<Quest> externalQuests = new ArrayList<Quest>();
        for (Quest parent : quest.getRequirements()) {
            if (parent.hasSameSetAs(quest)) continue;
            externalQuests.add(parent);
        }
        return externalQuests;
    }

    private int getCompletedExternal(Quest quest, UUID playerId) {
        int completed = 0;
        for (Quest parent : quest.getRequirements()) {
            if (parent.hasSameSetAs(quest) || !parent.isCompleted(playerId)) continue;
            ++completed;
        }
        return completed;
    }

    private void addParentTooltip(UUID playerId, Quest quest, boolean editing, List<FormattedText> tooltip) {
        int totalParentCount = this.getParentCount(quest);
        if (editing && totalParentCount > 0) {
            boolean holdingR = InputConstants.m_84830_((long)Minecraft.m_91087_().m_91268_().m_85439_(), (int)82);
            int totalCompletedCount = this.getCompletedParents(quest, playerId);
            tooltip.add((FormattedText)Translator.translatable("hqm.questBook.parentCount", totalParentCount - totalCompletedCount, Translator.quest(totalParentCount)).m_130946_(" ").m_7220_((Component)this.holdingText(holdingR, "R")).m_130940_(ChatFormatting.DARK_GRAY));
            if (holdingR) {
                for (Quest parent : quest.getRequirements()) {
                    MutableComponent component = parent.getName().m_130940_(ChatFormatting.DARK_GRAY);
                    tooltip.add((FormattedText)component);
                    if (!parent.isCompleted(playerId)) continue;
                    MutableComponent completedComponent = Translator.box(Translator.translatable("hqm.questBook.completed", new Object[0])).m_130940_(ChatFormatting.WHITE);
                    component.m_130946_(" ").m_7220_((Component)completedComponent);
                }
            }
        }
    }

    private boolean addExternalParentTooltip(UUID playerId, Quest quest, boolean editing, List<FormattedText> tooltip) {
        int allowedUncompleted;
        List<Quest> externalQuests = this.getExternalQuests(quest);
        int externalParents = externalQuests.size();
        int completedExternal = this.getCompletedExternal(quest, playerId);
        int n = allowedUncompleted = quest.getUseModifiedParentRequirement() ? Math.max(0, quest.getRequirements().size() - quest.getParentRequirementCount()) : 0;
        if (externalParents - completedExternal > allowedUncompleted || editing && externalParents > 0) {
            int parents = this.getParentCount(quest);
            int completedParents = this.getCompletedParents(quest, playerId);
            MutableComponent component = Translator.translatable("hqm.questBook.parentCountElsewhere", parents - completedParents, Translator.quest(parents)).m_130940_(ChatFormatting.RED);
            tooltip.add((FormattedText)component);
            if (editing) {
                boolean holdingE = InputConstants.m_84830_((long)Minecraft.m_91087_().m_91268_().m_85439_(), (int)69);
                component.m_130946_(" ").m_7220_((Component)this.holdingText(holdingE, "E"));
                if (holdingE) {
                    for (Quest parent : externalQuests) {
                        MutableComponent questComponent = Translator.text(parent.getName() + " (" + parent.getQuestSet().getName() + ")").m_130940_(ChatFormatting.RED);
                        tooltip.add((FormattedText)questComponent);
                        if (!parent.isCompleted(playerId)) continue;
                        MutableComponent completedComponent = Translator.box(Translator.translatable("hqm.questBook.completed", new Object[0])).m_130940_(ChatFormatting.WHITE);
                        questComponent.m_130946_(" ").m_7220_((Component)completedComponent);
                    }
                }
            }
            return true;
        }
        return false;
    }

    private void addRequirementTooltip(Quest quest, boolean editing, List<FormattedText> tooltip) {
        if (editing && quest.getUseModifiedParentRequirement()) {
            int parentCount;
            int amount = quest.getParentRequirementCount();
            MutableComponent component = amount < (parentCount = this.getParentCount(quest)) ? Translator.translatable("hqm.questBook.reqOnly", Translator.quest(amount)) : (amount > parentCount ? Translator.translatable("hqm.questBook.reqMore", Translator.quest(amount)) : Translator.translatable("hqm.questBook.reqAll", Translator.quest(amount)));
            tooltip.add((FormattedText)component.m_130940_(ChatFormatting.LIGHT_PURPLE));
        }
    }

    private void addTaskTooltip(UUID playerId, Quest quest, List<FormattedText> tooltip) {
        int totalTasks = quest.getTasks().size();
        int completedTasks = 0;
        for (QuestTask<?> task : quest.getTasks()) {
            if (!task.isCompleted(playerId)) continue;
            ++completedTasks;
        }
        if (totalTasks == 0) {
            tooltip.add((FormattedText)Translator.translatable("hqm.questBook.noTasks", new Object[0]).m_130940_(ChatFormatting.DARK_RED));
        } else {
            boolean holdingT = InputConstants.m_84830_((long)Minecraft.m_91087_().m_91268_().m_85439_(), (int)84);
            tooltip.add((FormattedText)Translator.translatable("hqm.questBook.completedTasks", completedTasks, totalTasks).m_130946_(" ").m_7220_((Component)this.holdingText(holdingT, "T")).m_130940_(ChatFormatting.DARK_AQUA));
            if (holdingT) {
                for (QuestTask<?> task : quest.getTasks()) {
                    MutableComponent component = task.getName().m_130940_(ChatFormatting.DARK_AQUA);
                    tooltip.add((FormattedText)component);
                    if (!task.isCompleted(playerId)) continue;
                    component.m_130946_(" ").m_7220_((Component)Translator.box(Translator.translatable("hqm.questBook.completed", new Object[0])).m_130940_(ChatFormatting.WHITE));
                }
            }
        }
    }

    private void addInvisibilityTooltip(Player player, HashMap<Quest, Boolean> isVisibleCache, HashMap<Quest, Boolean> isLinkFreeCache, Quest quest, List<FormattedText> tooltip) {
        if (!quest.isVisible(player, isVisibleCache, isLinkFreeCache)) {
            Optional<Object> invisibilityMessage;
            if (quest.isLinkFree(player, isLinkFreeCache)) {
                boolean parentInvisible = false;
                for (Quest parent : quest.getRequirements()) {
                    if (parent.isVisible(player, isVisibleCache, isLinkFreeCache)) continue;
                    parentInvisible = true;
                    break;
                }
                switch (quest.getTriggerType()) {
                    case ANTI_TRIGGER: {
                        invisibilityMessage = Optional.of(Translator.translatable("hqm.questBook.invisLocked", new Object[0]));
                        break;
                    }
                    case QUEST_TRIGGER: {
                        invisibilityMessage = Optional.of(Translator.translatable("hqm.questBook.invisPerm", new Object[0]));
                        parentInvisible = false;
                        break;
                    }
                    case TASK_TRIGGER: {
                        invisibilityMessage = Optional.of(Translator.plural("hqm.questBook.invisCount", quest.getTriggerTasks()));
                        break;
                    }
                    default: {
                        invisibilityMessage = Optional.empty();
                    }
                }
                if (parentInvisible) {
                    MutableComponent parentText = Translator.translatable("hqm.questBook.invisInherit", new Object[0]);
                    if (invisibilityMessage.isPresent()) {
                        parentText = Translator.translatable("hqm.questBook.and", parentText, invisibilityMessage.get());
                    }
                    invisibilityMessage = Optional.of(parentText);
                }
            } else {
                invisibilityMessage = Optional.of(Translator.translatable("hqm.questBook.invisOption", new Object[0]));
            }
            invisibilityMessage.ifPresent(component -> tooltip.add((FormattedText)component.m_130940_(ChatFormatting.BLUE)));
        }
    }

    private void addOptionLinkTooltip(Quest quest, List<FormattedText> tooltip) {
        ArrayList<UUID> ids = new ArrayList<UUID>();
        for (Quest option : quest.getOptionLinks()) {
            ids.add(option.getQuestId());
        }
        for (Quest option : quest.getReversedOptionLinks()) {
            UUID id = option.getQuestId();
            if (ids.contains(id)) continue;
            ids.add(id);
        }
        int optionLinks = ids.size();
        if (optionLinks > 0) {
            boolean holdingO = InputConstants.m_84830_((long)Minecraft.m_91087_().m_91268_().m_85439_(), (int)79);
            tooltip.add((FormattedText)Translator.translatable("hqm.questBook.optionLinks", Translator.quest(optionLinks)).m_130946_(" ").m_7220_((Component)this.holdingText(holdingO, "O")).m_130940_(ChatFormatting.DARK_BLUE));
            if (holdingO) {
                for (UUID id : ids) {
                    Quest option = Quest.getQuest(id);
                    MutableComponent component = option.getName().m_130940_(ChatFormatting.DARK_BLUE);
                    tooltip.add((FormattedText)component);
                    if (option.hasSameSetAs(quest)) continue;
                    component.m_130946_(" (" + option.getQuestSet().getName() + ")");
                }
            }
        }
    }

    private void addChildTooltip(Quest quest, boolean editing, List<FormattedText> tooltip) {
        ArrayList<Quest> externalQuests = new ArrayList<Quest>();
        int childCount = 0;
        for (Quest child : quest.getReversedRequirement()) {
            if (quest.hasSameSetAs(child)) continue;
            ++childCount;
            externalQuests.add(child);
        }
        if (childCount > 0) {
            MutableComponent component = Translator.translatable("hqm.questBook.childUnlocks", Translator.quest(childCount)).m_130940_(ChatFormatting.RED);
            tooltip.add((FormattedText)component);
            if (editing) {
                boolean holdingU = InputConstants.m_84830_((long)Minecraft.m_91087_().m_91268_().m_85439_(), (int)85);
                component.m_130946_(" ").m_7220_((Component)this.holdingText(holdingU, "U"));
                if (holdingU) {
                    for (Quest child : externalQuests) {
                        tooltip.add((FormattedText)Translator.text(child.getName() + " (" + child.getQuestSet().getName() + ")").m_130940_(ChatFormatting.RED));
                    }
                }
            }
        }
    }

    private MutableComponent holdingText(boolean holding, String letter) {
        return Translator.box(Translator.translatable("hqm.questBook." + (holding ? "holding" : "hold"), letter));
    }

    private void drawConnectingLines(GuiGraphics graphics, Player player, HashMap<Quest, Boolean> isVisibleCache, HashMap<Quest, Boolean> isLinkFreeCache) {
        int color;
        for (Quest child : this.set.getQuests().values()) {
            if (!Quest.canQuestsBeEdited() && !child.isVisible(player, isVisibleCache, isLinkFreeCache)) continue;
            for (Quest parent : child.getRequirements()) {
                if (!Quest.canQuestsBeEdited() && !parent.isVisible(player, isVisibleCache, isLinkFreeCache) || !parent.hasSameSetAs(child)) continue;
                color = Quest.canQuestsBeEdited() && (!child.isVisible(player, isVisibleCache, isLinkFreeCache) || !parent.isVisible(player, isVisibleCache, isLinkFreeCache)) ? 0x55404040 : -12566464;
                this.gui.drawLine(graphics, this.gui.getLeft() + parent.getGuiCenterX(), this.gui.getTop() + parent.getGuiCenterY(), this.gui.getLeft() + child.getGuiCenterX(), this.gui.getTop() + child.getGuiCenterY(), 5, color);
            }
        }
        if (Quest.canQuestsBeEdited()) {
            for (Quest child : this.set.getQuests().values()) {
                for (Quest parent : child.getOptionLinks()) {
                    if (!parent.hasSameSetAs(child)) continue;
                    color = !child.isVisible(player, isVisibleCache, isLinkFreeCache) || !parent.isVisible(player, isVisibleCache, isLinkFreeCache) ? 1430274269 : -12566307;
                    this.gui.drawLine(graphics, this.gui.getLeft() + parent.getGuiCenterX(), this.gui.getTop() + parent.getGuiCenterY(), this.gui.getLeft() + child.getGuiCenterX(), this.gui.getTop() + child.getGuiCenterY(), 5, color);
                }
            }
        }
    }

    private void drawQuestIcons(GuiGraphics graphics, int x, int y, Player player, HashMap<Quest, Boolean> isVisibleCache, HashMap<Quest, Boolean> isLinkFreeCache) {
        for (Quest quest : this.set.getQuests().values()) {
            if (!Quest.canQuestsBeEdited() && !quest.isVisible(player, isVisibleCache, isLinkFreeCache)) continue;
            RenderSystem.enableBlend();
            RenderSystem.blendFunc((int)770, (int)771);
            int color = quest == this.draggedQuest || quest == this.selectedQuest ? -4456517 : (quest.getQuestId().equals(Quest.speciallySelectedQuestId) ? -476161 : quest.getColorFilter(player, this.gui.getTick()));
            this.gui.applyColor(color);
            this.gui.drawRect(graphics, GuiBase.MAP_TEXTURE, quest.getGuiX(), quest.getGuiY(), quest.getGuiU(), quest.getGuiV(player, x, y), quest.getGuiW(), quest.getGuiH());
            int iconX = quest.getGuiCenterX() - 8;
            int iconY = quest.getGuiCenterY() - 8;
            if (quest.useBigIcon()) {
                // empty if block
            }
            int iconX_ = ++iconX;
            int iconY_ = ++iconY;
            quest.getIconStack().ifLeft(itemStack -> this.gui.drawItemStack(graphics, (ItemStack)itemStack, iconX_, iconY_, true)).ifRight(fluidStack -> this.gui.drawFluid((FluidStack)fluidStack, graphics.m_280168_(), iconX_, iconY_));
        }
    }

    @Override
    public void onClick(int mX, int mY, int b) {
        block33: {
            Player player;
            block32: {
                super.onClick(mX, mY, b);
                player = this.gui.getPlayer();
                if (!Quest.canQuestsBeEdited() || this.gui.getCurrentMode() != EditMode.CREATE && this.gui.getCurrentMode() != EditMode.REP_BAR_CREATE) break block32;
                switch (this.gui.getCurrentMode()) {
                    case CREATE: {
                        if (mX > 0) {
                            Quest newQuest = new Quest(WrappedText.create("Unnamed"), WrappedText.create("Unnamed quest"), 0, 0, false);
                            newQuest.setGuiCenterX(mX);
                            newQuest.setGuiCenterY(mY);
                            newQuest.setQuestSet(this.set);
                            SaveHelper.add(EditType.QUEST_CREATE);
                            break;
                        }
                        break block33;
                    }
                    case REP_BAR_CREATE: {
                        PickReputationMenu.display(this.gui, reputation -> {
                            this.set.addRepBar(new ReputationBar((Reputation)reputation, mX, mY));
                            SaveHelper.add(EditType.REPUTATION_BAR_ADD);
                        });
                        break;
                    }
                }
                break block33;
            }
            HashMap<Quest, Boolean> isVisibleCache = new HashMap<Quest, Boolean>();
            HashMap<Quest, Boolean> isLinkFreeCache = new HashMap<Quest, Boolean>();
            block18: for (Quest quest : this.set.getQuests().values()) {
                if (!Quest.canQuestsBeEdited() && !quest.isVisible(player, isVisibleCache, isLinkFreeCache) || !quest.isMouseInObject(mX, mY)) continue;
                if (Quest.canQuestsBeEdited()) {
                    switch (this.gui.getCurrentMode()) {
                        case MOVE: {
                            this.draggedQuest = quest;
                            SaveHelper.add(EditType.QUEST_MOVE);
                            break;
                        }
                        case REQUIREMENT: {
                            if (this.selectedQuest == quest) {
                                if (Screen.m_96638_()) {
                                    this.selectedQuest.clearRequirements();
                                }
                                this.selectedQuest = null;
                                break;
                            }
                            if (this.selectedQuest == null) {
                                this.selectedQuest = quest;
                                break;
                            }
                            this.selectedQuest.addRequirement(quest.getQuestId());
                            break;
                        }
                        case SIZE: {
                            int cX = quest.getGuiCenterX();
                            int cY = quest.getGuiCenterY();
                            quest.setBigIcon(!quest.useBigIcon());
                            quest.setGuiCenterX(cX);
                            quest.setGuiCenterY(cY);
                            SaveHelper.add(EditType.QUEST_SIZE_CHANGE);
                            break;
                        }
                        case ITEM: {
                            PickItemMenu.display(this.gui, quest.getIconStack(), PickItemMenu.Type.ITEM_FLUID, result -> {
                                try {
                                    quest.setIconStack((Either<ItemStack, FluidStack>)((Either)result.get()));
                                }
                                catch (Exception e) {
                                    System.out.println("Tell LordDusk that he found the issue.");
                                }
                                SaveHelper.add(EditType.ICON_CHANGE);
                            });
                            break;
                        }
                        case DELETE: {
                            Quest.removeQuest(quest);
                            SaveHelper.add(EditType.QUEST_REMOVE);
                            break;
                        }
                        case SWAP: {
                            if (this.gui.modifyingQuestSet == null || this.gui.modifyingQuestSet == this.set) break block18;
                            quest.setQuestSet(this.gui.modifyingQuestSet);
                            SaveHelper.add(EditType.QUEST_CHANGE_SET);
                            break;
                        }
                        case REPEATABLE: {
                            RepeatInfoMenu.display(this.gui, quest.getRepeatInfo(), repeatInfo -> {
                                quest.setRepeatInfo((RepeatInfo)repeatInfo);
                                SaveHelper.add(EditType.REPEATABILITY_CHANGED);
                            });
                            break;
                        }
                        case REQUIRED_PARENTS: {
                            RequiredParentCountMenu.display(this.gui, quest.getUseModifiedParentRequirement(), quest.getParentRequirementCount(), value -> {
                                quest.setParentRequirementCount(value);
                                SaveHelper.add(EditType.PARENT_REQUIREMENT_CHANGED);
                            });
                            break;
                        }
                        case QUEST_SELECTION: {
                            if (Quest.speciallySelectedQuestId == quest.getQuestId()) {
                                Quest.speciallySelectedQuestId = null;
                                break;
                            }
                            Quest.speciallySelectedQuestId = quest.getQuestId();
                            break;
                        }
                        case QUEST_OPTION: {
                            if (this.selectedQuest == quest) {
                                if (Screen.m_96638_()) {
                                    this.selectedQuest.clearOptionLinks();
                                }
                                this.selectedQuest = null;
                                break;
                            }
                            if (this.selectedQuest == null) {
                                this.selectedQuest = quest;
                                break;
                            }
                            this.selectedQuest.addOptionLink(quest.getQuestId());
                            break;
                        }
                        case TRIGGER: {
                            PickTriggerMenu.display(this.gui, quest.getTriggerType(), quest.getTriggerTasks(), result -> {
                                quest.setTriggerType(result.type());
                                quest.setTriggerTasks(Math.max(1, result.count()));
                                SaveHelper.add(EditType.VISIBILITY_CHANGED);
                            });
                            break;
                        }
                        case NORMAL: {
                            if (this.gui.isOpBook && Screen.m_96638_()) {
                                OPBookHelper.reverseQuestCompletion(quest, player.m_20148_());
                                break;
                            }
                        }
                        default: {
                            this.gui.setPage(this.page.forQuest(quest));
                            break;
                        }
                    }
                    break;
                }
                if (this.gui.isOpBook && Screen.m_96638_()) {
                    OPBookHelper.reverseQuestCompletion(quest, player.m_20148_());
                    break;
                }
                this.gui.setPage(this.page.forQuest(quest));
                break;
            }
        }
        if (Quest.canQuestsBeEdited()) {
            for (ReputationBar reputationBar : new ArrayList<ReputationBar>(this.set.getReputationBars())) {
                reputationBar.mouseClicked(this.gui, this.set, mX, mY);
            }
        }
    }

    @Override
    public void onRelease(int mX, int mY, int b) {
        super.onRelease(mX, mY, b);
        this.draggedQuest = null;
    }

    @Override
    public void onDrag(int mX, int mY, int b) {
        super.onDrag(mX, mY, b);
        if (this.draggedQuest != null && Quest.canQuestsBeEdited() && this.gui.getCurrentMode() == EditMode.MOVE) {
            this.draggedQuest.setGuiCenterX(mX);
            this.draggedQuest.setGuiCenterY(mY);
        }
    }

    @Override
    protected void setEditMode(EditMode mode) {
        this.draggedQuest = null;
        this.selectedQuest = null;
        super.setEditMode(mode);
    }
}

