/*
 * Decompiled with CFR 0.152.
 */
package hardcorequesting.common.forge.client.interfaces.graphic;

import hardcorequesting.common.forge.client.BookPage;
import hardcorequesting.common.forge.client.EditMode;
import hardcorequesting.common.forge.client.interfaces.GuiQuestBook;
import hardcorequesting.common.forge.client.interfaces.edit.TextMenu;
import hardcorequesting.common.forge.client.interfaces.edit.WrappedTextMenu;
import hardcorequesting.common.forge.client.interfaces.graphic.EditableGraphic;
import hardcorequesting.common.forge.client.interfaces.widget.ExtendedScrollBar;
import hardcorequesting.common.forge.client.interfaces.widget.LargeButton;
import hardcorequesting.common.forge.client.interfaces.widget.ScrollBar;
import hardcorequesting.common.forge.config.HQMConfig;
import hardcorequesting.common.forge.quests.Quest;
import hardcorequesting.common.forge.quests.QuestSet;
import hardcorequesting.common.forge.util.EditType;
import hardcorequesting.common.forge.util.SaveHelper;
import hardcorequesting.common.forge.util.Translator;
import hardcorequesting.common.forge.util.WrappedText;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class QuestSetsGraphic
extends EditableGraphic {
    private static final int TEXT_SPACING = 20;
    private static final int LIST_X = 25;
    private static final int LIST_Y = 20;
    private static final int DESCRIPTION_X = 180;
    private static final int DESCRIPTION_Y = 20;
    private static final int VISIBLE_DESCRIPTION_LINES = 7;
    private static final int VISIBLE_SETS = 7;
    private static final int LINE_2_X = 10;
    private static final int LINE_2_Y = 12;
    private static final int INFO_Y = 100;
    private static int lastClicked = -1;
    private static QuestSet lastLastQuestSet = null;
    private static QuestSet selectedSet;
    private final BookPage.SetsPage page;
    private final ExtendedScrollBar<QuestSet> setScroll;
    private final ScrollBar descriptionScroll;

    public QuestSetsGraphic(BookPage.SetsPage page, GuiQuestBook gui) {
        super(gui, EditMode.NORMAL, EditMode.CREATE, EditMode.RENAME, EditMode.SWAP_SELECT, EditMode.DELETE);
        this.addClickable(new LargeButton(this.gui, "hqm.questBook.open", 245, 190){

            @Override
            public boolean isVisible() {
                return selectedSet != null;
            }

            @Override
            public void onClick() {
                QuestSetsGraphic.this.gui.setPage(QuestSetsGraphic.this.page.forSet(selectedSet));
            }
        });
        this.addClickable(new LargeButton(this.gui, "hqm.questBook.createSet", 185, 50){

            @Override
            public boolean isVisible() {
                return Quest.canQuestsBeEdited() && QuestSetsGraphic.this.gui.getCurrentMode() == EditMode.CREATE;
            }

            @Override
            public void onClick() {
                int i = 0;
                for (QuestSet set : Quest.getQuestSets()) {
                    if (!set.getName().startsWith("Unnamed set")) continue;
                    ++i;
                }
                Quest.getQuestSets().add(new QuestSet("Unnamed set" + (Serializable)(i == 0 ? "" : Integer.valueOf(i)), WrappedText.create("No description")));
                SaveHelper.add(EditType.SET_CREATE);
            }
        });
        this.page = page;
        this.descriptionScroll = new ScrollBar(gui, ScrollBar.Size.SMALL, 312, 18, 180){

            @Override
            public boolean isVisible() {
                return selectedSet != null && selectedSet.getDescription(QuestSetsGraphic.this.gui).size() > 7;
            }
        };
        this.addScrollBar(this.descriptionScroll);
        this.setScroll = new ExtendedScrollBar(gui, ScrollBar.Size.LONG, 160, 18, 25, 7, Quest::getQuestSets);
        this.addScrollBar(this.setScroll);
    }

    public static void loginReset() {
        lastClicked = -1;
        lastLastQuestSet = null;
        selectedSet = null;
    }

    @Override
    public void draw(GuiGraphics graphics, int mX, int mY) {
        super.draw(graphics, mX, mY);
        Player player = this.gui.getPlayer();
        List<QuestSet> questSets = Quest.getQuestSets();
        HashMap<Quest, Boolean> isVisibleCache = new HashMap<Quest, Boolean>();
        HashMap<Quest, Boolean> isLinkFreeCache = new HashMap<Quest, Boolean>();
        int setY = 20;
        for (QuestSet questSet : this.setScroll.getVisibleEntries()) {
            String name = questSet.getName(questSets.indexOf(questSet));
            int total = questSet.getQuests().size();
            boolean enabled = questSet.isEnabled(player, isVisibleCache, isLinkFreeCache);
            int completedCount = enabled ? questSet.getCompletedCount(player, isVisibleCache, isLinkFreeCache) : 0;
            boolean completed = true;
            int unclaimed = 0;
            for (Quest quest : questSet.getQuests().values()) {
                if (completed && !quest.isCompleted(player) && quest.isLinkFree(player, isLinkFreeCache)) {
                    completed = false;
                }
                if (!quest.isCompleted(player) || !quest.hasReward(player.m_20148_())) continue;
                ++unclaimed;
            }
            boolean selected = questSet == selectedSet;
            boolean inBounds = this.gui.inBounds(25, setY, this.gui.getStringWidth(name), 9, mX, mY);
            int color = this.gui.modifyingQuestSet == questSet ? HQMConfig.CURRENTLY_MODIFYING_QUEST_SET : (enabled ? (completed ? (selected ? (inBounds ? HQMConfig.COMPLETED_SELECTED_IN_BOUNDS_SET : HQMConfig.COMPLETED_SELECTED_OUT_OF_BOUNDS_SET) : (inBounds ? HQMConfig.COMPLETED_UNSELECTED_IN_BOUNDS_SET : HQMConfig.COMPLETED_UNSELECTED_OUT_OF_BOUNDS_SET)) : (selected ? (inBounds ? HQMConfig.UNCOMPLETED_SELECTED_IN_BOUNDS_SET : HQMConfig.UNCOMPLETED_SELECTED_OUT_OF_BOUNDS_SET) : (inBounds ? HQMConfig.UNCOMPLETED_UNSELECTED_IN_BOUNDS_SET : HQMConfig.UNCOMPLETED_UNSELECTED_OUT_OF_BOUNDS_SET))) : HQMConfig.DISABLED_SET);
            this.gui.drawString(graphics, Translator.plain(name), 25, setY, color);
            MutableComponent info = enabled ? (completed ? Translator.translatable("hqm.questBook.allQuests", new Object[0]) : Translator.translatable("hqm.questBook.percentageQuests", completedCount * 100 / total)) : Translator.translatable("hqm.questBook.locked", new Object[0]);
            this.gui.drawString(graphics, (FormattedText)info, 35, setY + 12, 0.7f, color);
            if (enabled && unclaimed != 0) {
                MutableComponent toClaim = Translator.translatable("hqm.questBook.unclaimedRewards", Translator.quest(unclaimed)).m_130940_(ChatFormatting.DARK_PURPLE);
                this.gui.drawString(graphics, (FormattedText)toClaim, 35, setY + 12 + 8, 0.7f, -1);
            }
            setY += 29;
        }
        if (Quest.canQuestsBeEdited() && this.gui.getCurrentMode() == EditMode.CREATE) {
            this.gui.drawString(graphics, this.gui.getLinesFromText((FormattedText)Translator.translatable("hqm.questBook.createNewSet", new Object[0]), 0.7f, 130), 180, 20, 0.7f, 0x404040);
        } else {
            if (selectedSet != null) {
                List<FormattedText> description = this.descriptionScroll.getVisibleEntries(selectedSet.getDescription(this.gui), 7);
                this.gui.drawString(graphics, description, 180, 20, 0.7f, 0x404040);
            }
            QuestSetsGraphic.drawQuestInfo(graphics, this.gui, selectedSet, 180, selectedSet == null ? 20 : 100, isVisibleCache, isLinkFreeCache);
        }
    }

    public static void drawQuestInfo(GuiGraphics graphics, GuiQuestBook gui, QuestSet set, int x, int y) {
        QuestSetsGraphic.drawQuestInfo(graphics, gui, set, x, y, new HashMap<Quest, Boolean>(), new HashMap<Quest, Boolean>());
    }

    private static void drawQuestInfo(GuiGraphics graphics, GuiQuestBook gui, QuestSet set, int x, int y, HashMap<Quest, Boolean> isVisibleCache, HashMap<Quest, Boolean> isLinkFreeCache) {
        int completed = 0;
        int reward = 0;
        int enabled = 0;
        int total = 0;
        int realTotal = 0;
        Player player = gui.getPlayer();
        for (Quest quest : Quest.getQuests().values()) {
            if (set != null && !quest.hasSet(set)) continue;
            ++realTotal;
            if (!quest.isVisible(player, isVisibleCache, isLinkFreeCache)) continue;
            ++total;
            if (!quest.isEnabled(player, isVisibleCache, isLinkFreeCache)) continue;
            ++enabled;
            if (!quest.isCompleted(player)) continue;
            ++completed;
            if (!quest.hasReward(player.m_20148_())) continue;
            ++reward;
        }
        ArrayList<FormattedText> info = new ArrayList<FormattedText>();
        info.add((FormattedText)Translator.translatable("hqm.questBook.totalQuests", Translator.quest(total)).m_130940_(ChatFormatting.DARK_GRAY));
        info.add((FormattedText)Translator.translatable("hqm.questBook.unlockedQuests", Translator.quest(enabled)).m_130940_(ChatFormatting.DARK_AQUA));
        info.add((FormattedText)Translator.translatable("hqm.questBook.completedQuests", Translator.quest(completed)).m_130940_(ChatFormatting.DARK_GREEN));
        info.add((FormattedText)Translator.translatable("hqm.questBook.availableQuests", Translator.quest(enabled - completed)).m_130940_(ChatFormatting.BLUE));
        if (reward > 0) {
            info.add((FormattedText)Translator.translatable("hqm.questBook.unclaimedQuests", Translator.quest(reward)).m_130940_(ChatFormatting.DARK_PURPLE));
        }
        if (Quest.canQuestsBeEdited() && !Screen.m_96637_()) {
            info.add((FormattedText)Translator.translatable("hqm.questBook.inclInvisiQuests", Translator.quest(realTotal)).m_130940_(ChatFormatting.GRAY));
        }
        gui.drawString(graphics, info, x, y, 0.7f, 0x404040);
    }

    @Override
    public void onClick(int mX, int mY, int b) {
        super.onClick(mX, mY, b);
        List<QuestSet> questSets = Quest.getQuestSets();
        int setY = 20;
        block5: for (QuestSet questSet : this.setScroll.getVisibleEntries()) {
            if (this.gui.inBounds(25, setY, this.gui.getStringWidth(questSet.getName(questSets.indexOf(questSet))), 9, mX, mY)) {
                switch (this.gui.getCurrentMode()) {
                    case DELETE: {
                        if (!questSet.getQuests().isEmpty()) {
                            ArrayList<Quest> quests = new ArrayList<Quest>(questSet.getQuests().values());
                            for (Quest q : quests) {
                                questSet.removeQuest(q);
                                Quest.removeQuest(q);
                            }
                        }
                        for (int j = questSet.getId() + 1; j < Quest.getQuestSets().size(); ++j) {
                            Quest.getQuestSets().get(j).decreaseId();
                        }
                        Quest.getQuestSets().remove(questSet);
                        SaveHelper.add(EditType.SET_REMOVE);
                        break;
                    }
                    case SWAP_SELECT: {
                        this.gui.modifyingQuestSet = this.gui.modifyingQuestSet == questSet ? null : questSet;
                        break;
                    }
                    case RENAME: {
                        TextMenu.display(this.gui, questSet.getName(), true, result -> {
                            if (!questSet.setName((String)result)) {
                                this.gui.getPlayer().m_213846_((Component)Component.m_237115_((String)"hqm.editMode.rename.invalid_set").m_6270_(Style.f_131099_.m_131136_(Boolean.valueOf(true)).m_131140_(ChatFormatting.RED)));
                            }
                        });
                        break;
                    }
                    default: {
                        int thisClicked = this.gui.getPlayer().f_19797_ - lastClicked;
                        if (thisClicked < 0) {
                            lastClicked = -1;
                        }
                        if (lastClicked != -1 && thisClicked < 6) {
                            if (selectedSet == null && lastLastQuestSet != null) {
                                selectedSet = lastLastQuestSet;
                            }
                            if (selectedSet == null) break block5;
                            this.gui.setPage(this.page.forSet(selectedSet));
                            lastLastQuestSet = null;
                            break;
                        }
                        selectedSet = questSet == selectedSet ? null : questSet;
                        lastClicked = this.gui.getPlayer().f_19797_;
                        lastLastQuestSet = questSet;
                        break;
                    }
                }
                break;
            }
            setY += 29;
        }
        if (Quest.canQuestsBeEdited() && this.gui.getCurrentMode() == EditMode.RENAME && this.gui.inBounds(180, 20, 130, 44, mX, mY)) {
            WrappedTextMenu.display(this.gui, selectedSet.getRawDescription(), false, selectedSet::setDescription);
        }
    }
}

