/*
 * Decompiled with CFR 0.152.
 */
package hardcorequesting.common.forge.client.interfaces.graphic;

import hardcorequesting.common.forge.client.interfaces.GuiQuestBook;
import hardcorequesting.common.forge.client.interfaces.RenderRotation;
import hardcorequesting.common.forge.client.interfaces.graphic.Graphic;
import hardcorequesting.common.forge.team.TeamLiteStat;
import hardcorequesting.common.forge.util.Translator;
import java.util.List;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.FormattedText;

public class TeamListGraphic
extends Graphic {
    private static final int TEAM_X = 20;
    private static final int TEAM_X_2ND_PAGE = 180;
    private static final int TEAM_Y = 20;
    private static final int TEAM_OFFSET = 50;
    private static final int TEAM_LINE_OFFSET = 10;
    private static final int TEAM_LINE_INDENT = 5;
    private static final int TEAMS_PER_PAGE = 4;
    private static final int TEAMS_PER_PAIR = 8;
    private static final int ARROW_X_LEFT = 30;
    private static final int ARROW_X_RIGHT = 288;
    private static final int ARROW_Y = 212;
    private static final int ARROW_SRC_X = 181;
    private static final int ARROW_SRC_Y = 69;
    private static final int ARROW_W = 20;
    private static final int ARROW_H = 9;
    private int pagePair = 0;
    private final GuiQuestBook gui;

    public TeamListGraphic(GuiQuestBook gui) {
        this.gui = gui;
    }

    @Override
    public void draw(GuiGraphics graphics, int mX, int mY) {
        super.draw(graphics, mX, mY);
        this.drawArrow(graphics, mX, mY, true);
        this.drawArrow(graphics, mX, mY, false);
        List<TeamLiteStat> teamStats = TeamLiteStat.getTeamStats();
        int start = this.pagePair * 8;
        int end = Math.min(start + 8, teamStats.size());
        for (int i = start; i < end; ++i) {
            TeamLiteStat teamStat = teamStats.get(i);
            int x = i - start < 4 ? 20 : 180;
            int y = 20 + (i - start) % 4 * 50;
            this.gui.drawString(graphics, Translator.plain(teamStat.getName()), x, y, 0x404040);
            this.gui.drawString(graphics, (FormattedText)Translator.translatable("hqm.teamList.done", Float.valueOf(teamStat.getProgress())), x + 5, y + 10, 0.7f, 0x404040);
            this.gui.drawString(graphics, (FormattedText)Translator.translatable("hqm.teamList.players", teamStat.getPlayers()), x + 5, y + 20, 0.7f, 0x404040);
            this.gui.drawString(graphics, (FormattedText)Translator.translatable("hqm.teamList.lives", teamStat.getLives()), x + 5, y + 30, 0.7f, 0x404040);
        }
        this.gui.drawCenteredString(graphics, (FormattedText)Translator.translatable("hqm.teamList.page", this.pagePair * 2 + 1), 0, 202, 0.7f, 170, 30, 0x707070);
        if (end - start > 4) {
            this.gui.drawCenteredString(graphics, (FormattedText)Translator.translatable("hqm.teamList.page", this.pagePair * 2 + 2), 170, 202, 0.7f, 170, 30, 0x707070);
        }
    }

    @Override
    public void onClick(int mX, int mY, int b) {
        super.onClick(mX, mY, b);
        if (this.isArrowEnabled(true) && this.gui.inBounds(30, 212, 20, 9, mX, mY)) {
            --this.pagePair;
        } else if (this.isArrowEnabled(false) && this.gui.inBounds(288, 212, 20, 9, mX, mY)) {
            ++this.pagePair;
        }
    }

    private void drawArrow(GuiGraphics graphics, int mX, int mY, boolean left) {
        int x = left ? 30 : 288;
        int srcY = 0;
        if (this.isArrowEnabled(left)) {
            srcY = this.gui.inBounds(x, 212, 20, 9, mX, mY) ? 2 : 1;
        }
        this.gui.drawRect(graphics, x, 212, 181, 69 + srcY * 20, 9, 20, left ? RenderRotation.ROTATE_90 : RenderRotation.ROTATE_270);
    }

    private boolean isArrowEnabled(boolean left) {
        return left && this.pagePair > 0 || !left && (double)this.pagePair < Math.ceil((float)TeamLiteStat.getTeamStats().size() / 8.0f) - 1.0;
    }
}

