/*
 * Decompiled with CFR 0.152.
 */
package hardcorequesting.common.forge.client.interfaces.graphic;

import com.mojang.blaze3d.systems.RenderSystem;
import hardcorequesting.common.forge.client.BookPage;
import hardcorequesting.common.forge.client.interfaces.GuiBase;
import hardcorequesting.common.forge.client.interfaces.GuiQuestBook;
import hardcorequesting.common.forge.client.interfaces.ResourceHelper;
import hardcorequesting.common.forge.client.interfaces.graphic.Graphic;
import hardcorequesting.common.forge.client.interfaces.widget.ExtendedScrollBar;
import hardcorequesting.common.forge.client.interfaces.widget.LargeButton;
import hardcorequesting.common.forge.client.interfaces.widget.ScrollBar;
import hardcorequesting.common.forge.client.interfaces.widget.TextBox;
import hardcorequesting.common.forge.quests.QuestingDataManager;
import hardcorequesting.common.forge.team.PlayerEntry;
import hardcorequesting.common.forge.team.Team;
import hardcorequesting.common.forge.team.TeamError;
import hardcorequesting.common.forge.util.Translator;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;

public class TeamMenuGraphic
extends Graphic {
    private static final int TITLE_X = 20;
    private static final int TITLE_Y = 20;
    private static final int PLAYER_X = 25;
    private static final int PLAYER_Y = 32;
    private static final int PLAYER_SPACING = 11;
    private static final int VISIBLE_INVITES = 16;
    private static final int VISIBLE_MEMBERS = 16;
    private static final int INFO_BOX_X = 180;
    private static final int INFO_BOX_SIZE = 16;
    private static final int INFO_BOX_TEXT_OFFSET_X = 20;
    private static final int INFO_BOX_TEXT_OFFSET_Y = 6;
    private static final int INFO_BOX_SRC_X = 240;
    private static final int INFO_BOX_SRC_Y = 224;
    private static final int REWARD_SETTING_Y = 20;
    private final GuiQuestBook gui;
    private final UUID playerId;
    private final ScrollBar memberScroll;
    private final ExtendedScrollBar<Team> inviteScroll;
    private final LargeButton inviteButton;
    private final TextBox teamName;
    private final TextBox inviteName;
    private Team inviteTeam;
    private PlayerEntry selectedEntry;

    public TeamMenuGraphic(final GuiQuestBook gui, UUID playerId) {
        this.gui = gui;
        this.playerId = playerId;
        this.addClickable(new LargeButton(gui, "hqm.party.create", 250, 20){

            @Override
            public boolean isEnabled() {
                return TeamMenuGraphic.this.teamName.getText().length() > 0;
            }

            @Override
            public boolean isVisible() {
                return TeamMenuGraphic.this.inviteTeam == null && TeamMenuGraphic.this.getTeam().isSingle();
            }

            @Override
            public void onClick() {
                TeamMenuGraphic.this.getTeam().create(TeamMenuGraphic.this.teamName.getText());
            }
        });
        this.inviteButton = new LargeButton(gui, "hqm.party.invitePlayer", 250, 20){

            @Override
            public boolean isEnabled() {
                return TeamMenuGraphic.this.inviteName.getText().length() > 0;
            }

            @Override
            public boolean isVisible() {
                return !TeamMenuGraphic.this.getTeam().isSingle() && TeamMenuGraphic.this.getEntry(TeamMenuGraphic.this.getTeam()).isOwner();
            }

            @Override
            public void onClick() {
                TeamMenuGraphic.this.getTeam().invite(TeamMenuGraphic.this.inviteName.getText());
            }
        };
        this.addClickable(this.inviteButton);
        this.addClickable(new LargeButton(gui, "hqm.party.accept", 180, 20){

            @Override
            public boolean isVisible() {
                return TeamMenuGraphic.this.inviteTeam != null;
            }

            @Override
            public void onClick() {
                TeamMenuGraphic.this.inviteTeam.accept();
                TeamMenuGraphic.this.inviteTeam = null;
            }
        });
        this.addClickable(new LargeButton(gui, "hqm.party.decline", 240, 20){

            @Override
            public boolean isVisible() {
                return TeamMenuGraphic.this.inviteTeam != null;
            }

            @Override
            public void onClick() {
                TeamMenuGraphic.this.inviteTeam.decline();
                TeamMenuGraphic.this.inviteTeam = null;
            }
        });
        this.addClickable(new LargeButton(gui, "hqm.party.decideLater", 180, 40){

            @Override
            public boolean isVisible() {
                return TeamMenuGraphic.this.inviteTeam != null;
            }

            @Override
            public void onClick() {
                TeamMenuGraphic.this.inviteTeam = null;
            }
        });
        this.addClickable(new LargeButton(gui, null, 250, 50){

            @Override
            public boolean isEnabled() {
                return !TeamMenuGraphic.this.selectedEntry.isOwner();
            }

            @Override
            public boolean isVisible() {
                return TeamMenuGraphic.this.selectedEntry != null && TeamMenuGraphic.this.getEntry(TeamMenuGraphic.this.getTeam()).isOwner();
            }

            @Override
            public void onClick() {
                TeamMenuGraphic.this.getTeam().kick(TeamMenuGraphic.this.selectedEntry.getUUID());
                TeamMenuGraphic.this.selectedEntry = null;
            }

            @Override
            protected FormattedText getName() {
                return Translator.translatable(TeamMenuGraphic.this.selectedEntry.isInTeam() ? "hqm.party.kickPlayer" : "hqm.party.removeInvite", new Object[0]);
            }
        });
        this.addClickable(new LargeButton(gui, "hqm.party.leave", 250, 160){

            @Override
            public boolean isEnabled() {
                return Screen.m_96638_();
            }

            @Override
            public boolean isVisible() {
                return !TeamMenuGraphic.this.getTeam().isSingle() && !TeamMenuGraphic.this.getEntry(TeamMenuGraphic.this.getTeam()).isOwner();
            }

            @Override
            public void onClick() {
                TeamMenuGraphic.this.getTeam().leave();
            }
        });
        this.addClickable(new LargeButton(gui, "hqm.party.disband", 250, 160){

            @Override
            public boolean isEnabled() {
                return Screen.m_96638_() && Screen.m_96637_();
            }

            @Override
            public boolean isVisible() {
                return !TeamMenuGraphic.this.getTeam().isSingle() && TeamMenuGraphic.this.selectedEntry != null && TeamMenuGraphic.this.selectedEntry.isOwner();
            }

            @Override
            public void onClick() {
                TeamMenuGraphic.this.getTeam().disband();
                TeamMenuGraphic.this.selectedEntry = null;
            }
        });
        this.addClickable(new LargeButton(gui, "hqm.party.list", 250, 190){

            @Override
            public void onClick() {
                gui.setPage(BookPage.TeamListPage.INSTANCE);
            }
        });
        this.teamName = new TextBox(gui, "", 180, 26, true, Integer.MAX_VALUE, 0.7f){

            @Override
            protected boolean isVisible() {
                return TeamMenuGraphic.this.getTeam().isSingle() && TeamMenuGraphic.this.inviteTeam == null;
            }

            @Override
            protected boolean isTextValid(String newText) {
                return super.isTextValid(newText) && this.gui.getStringWidth(newText) <= 140;
            }
        };
        this.addTextBox(this.teamName);
        this.inviteName = new TextBox(gui, "", 180, 26, true, Integer.MAX_VALUE, 0.7f){

            @Override
            protected boolean isVisible() {
                return !TeamMenuGraphic.this.getTeam().isSingle() && TeamMenuGraphic.this.getEntry(TeamMenuGraphic.this.getTeam()).isOwner();
            }
        };
        this.addTextBox(this.inviteName);
        this.inviteScroll = new ExtendedScrollBar<Team>((GuiBase)gui, ScrollBar.Size.LONG, 155, 22, 25, 16, () -> this.getTeam().getInvites()){

            @Override
            public boolean isVisible() {
                return TeamMenuGraphic.this.inviteTeam == null && TeamMenuGraphic.this.getTeam().isSingle() && super.isVisible();
            }
        };
        this.addScrollBar(this.inviteScroll);
        this.memberScroll = new ScrollBar(gui, ScrollBar.Size.LONG, 155, 22, 25){

            @Override
            public boolean isVisible() {
                return TeamMenuGraphic.this.inviteTeam != null && TeamMenuGraphic.this.inviteTeam.getPlayers().size() > 16 || !TeamMenuGraphic.this.getTeam().isSingle() && TeamMenuGraphic.this.getTeam().getPlayers().size() > 16;
            }
        };
        this.addScrollBar(this.memberScroll);
    }

    @Override
    public void draw(GuiGraphics graphics, int mX, int mY) {
        Team team = this.getTeam();
        PlayerEntry entry = this.getEntry(team);
        if (Team.reloadedInvites) {
            if (this.inviteTeam != null) {
                boolean stillThere = false;
                for (Team t : team.getInvites()) {
                    if (!t.getName().equals(this.inviteTeam.getName())) continue;
                    this.inviteTeam = t;
                    stillThere = true;
                }
                if (!stillThere) {
                    this.inviteTeam = null;
                }
            }
            Team.reloadedInvites = false;
        }
        super.draw(graphics, mX, mY);
        ResourceHelper.bindResource(GuiQuestBook.MAP_TEXTURE);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        if (team.isSingle() && this.inviteTeam == null) {
            if (!team.getInvites().isEmpty()) {
                this.gui.drawString(graphics, (FormattedText)Translator.translatable("hqm.party.invites", new Object[0]), 20, 20, 0x404040);
                int inviteY = 32;
                for (Team invite : this.inviteScroll.getVisibleEntries()) {
                    this.gui.drawString(graphics, Translator.plain(invite.getName()), 25, inviteY, 0x404040);
                    inviteY += 11;
                }
            } else {
                this.gui.drawString(graphics, (FormattedText)Translator.translatable("hqm.party.noInvites", new Object[0]), 20, 20, 0x404040);
            }
            this.gui.drawString(graphics, (FormattedText)Translator.translatable("hqm.party.name", new Object[0]), 180, 20, 0.7f, 0x404040);
        } else {
            boolean isOwner = this.inviteTeam == null && entry.isOwner();
            Team shownTeam = this.inviteTeam == null ? team : this.inviteTeam;
            String title = shownTeam.getName();
            this.gui.drawString(graphics, Translator.plain(title), 20, 20, 0x404040);
            List<PlayerEntry> players = isOwner ? shownTeam.getPlayers() : shownTeam.getTeamMembers();
            int memberY = 32;
            for (PlayerEntry player : this.memberScroll.getVisibleEntries(players, 16)) {
                MutableComponent text = Translator.text(player.getDisplayName());
                if (player.isOwner()) {
                    text.m_130946_(" ").m_7220_((Component)Translator.box(Translator.translatable("hqm.party.owner", new Object[0])).m_130940_(ChatFormatting.GOLD));
                } else if (!player.isInTeam()) {
                    text.m_130946_(" ").m_7220_((Component)Translator.box(Translator.translatable("hqm.party.invite", new Object[0])).m_130940_(ChatFormatting.GRAY));
                }
                int color = 0x404040;
                if (isOwner) {
                    if (player.equals(this.selectedEntry)) {
                        color = 0xD0D0D0;
                    } else if (this.gui.inBounds(25, memberY, (int)((float)this.gui.getStringWidth(player.getDisplayName()) * 0.7f), 6, mX, mY)) {
                        color = 0x808080;
                    }
                }
                this.gui.drawString(graphics, (FormattedText)text, 25, memberY, 0.7f, color);
                memberY += 11;
            }
            if (this.inviteTeam == null) {
                if (entry.isOwner()) {
                    this.gui.drawString(graphics, (FormattedText)Translator.translatable("hqm.party.playerName", new Object[0]), 180, 20, 0.7f, 0x404040);
                    if (this.selectedEntry != null) {
                        this.gui.drawString(graphics, this.gui.getLinesFromText((FormattedText)Translator.translatable("hqm.party.currentSelection", this.selectedEntry.getDisplayName()), 0.7f, 70), 177, 52, 0.7f, 0x404040);
                        if (this.selectedEntry.isOwner()) {
                            this.gui.drawString(graphics, this.gui.getLinesFromText((FormattedText)Translator.translatable("hqm.party.shiftCtrlConfirm", new Object[0]), 0.6f, 70), 177, 162, 0.6f, 0xFF5555);
                        }
                    }
                } else {
                    this.gui.drawString(graphics, this.gui.getLinesFromText((FormattedText)Translator.translatable("hqm.party.shiftConfirm", new Object[0]), 0.7f, 70), 177, 162, 0.7f, 0xFF5555);
                }
            }
            this.gui.drawString(graphics, this.gui.getLinesFromText((FormattedText)Translator.translatable("hqm.party.stats", new Object[0]), 0.7f, 70), 177, 192, 0.7f, 0x404040);
            int infoY = this.getInfoY();
            ResourceHelper.bindResource(GuiQuestBook.MAP_TEXTURE);
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            this.gui.drawRect(graphics, GuiBase.MAP_TEXTURE, 180, infoY, 240, 224, 16, 16);
            this.gui.drawRect(graphics, GuiBase.MAP_TEXTURE, 180, infoY + 20, 240, 224, 16, 16);
            this.gui.drawString(graphics, (FormattedText)Translator.translatable("hqm.party.lifeSetting", shownTeam.getLifeSetting().getTitle()), 200, infoY + 6, 0.7f, 0x404040);
            this.gui.drawString(graphics, (FormattedText)Translator.translatable("hqm.party.rewardSetting", shownTeam.getRewardSetting().getTitle()), 200, infoY + 20 + 6, 0.7f, 0x404040);
        }
    }

    @Override
    public void drawTooltip(GuiGraphics graphics, int mX, int mY) {
        boolean isOwner;
        super.drawTooltip(graphics, mX, mY);
        Team team = this.getTeam();
        PlayerEntry entry = this.getEntry(team);
        boolean bl = isOwner = this.inviteTeam == null && entry.isOwner();
        if (!team.isSingle() || this.inviteTeam != null) {
            Team infoTeam;
            int infoY = this.getInfoY();
            Team team2 = infoTeam = this.inviteTeam == null ? team : this.inviteTeam;
            if (this.gui.inBounds(180, infoY, 16, 16, mX, mY)) {
                ArrayList<Object> tooltip = new ArrayList<Object>();
                tooltip.add(infoTeam.getLifeSetting().getTitle());
                tooltip.addAll(this.gui.getLinesFromText(infoTeam.getLifeSetting().getDescription(), 1.0f, 200));
                if (isOwner) {
                    tooltip.add(FormattedText.f_130760_);
                    tooltip.add(Translator.translatable("hqm.party.change", new Object[0]).m_130940_(ChatFormatting.GOLD));
                }
                this.gui.renderTooltipL(graphics, tooltip, this.gui.getLeft() + mX, this.gui.getTop() + mY);
            } else if (this.gui.inBounds(180, infoY + 20, 16, 16, mX, mY)) {
                ArrayList<Object> tooltip = new ArrayList<Object>();
                tooltip.add(infoTeam.getRewardSetting().getTitle());
                tooltip.addAll(this.gui.getLinesFromText(infoTeam.getRewardSetting().getDescription(), 1.0f, 200));
                if (isOwner) {
                    tooltip.add(FormattedText.f_130760_);
                    tooltip.add(Translator.translatable("hqm.party.change", new Object[0]).m_130940_(ChatFormatting.GOLD));
                }
                this.gui.renderTooltipL(graphics, tooltip, this.gui.getLeft() + mX, this.gui.getTop() + mY);
            }
        }
        if (TeamError.latestError != null) {
            if (this.inviteButton.inButtonBounds(mX, mY)) {
                ArrayList<FormattedText> tooltip = new ArrayList<FormattedText>();
                tooltip.add(TeamError.latestError.getHeader());
                tooltip.addAll(this.gui.getLinesFromText(TeamError.latestError.getMessage(), 1.0f, 150));
                this.gui.renderTooltipL(graphics, tooltip, mX + this.gui.getLeft(), mY + this.gui.getTop());
            } else {
                TeamError.latestError = null;
            }
        }
    }

    @Override
    public void onClick(int mX, int mY, int b) {
        super.onClick(mX, mY, b);
        Team team = this.getTeam();
        if (team.isSingle() && this.inviteTeam == null) {
            int inviteY = 32;
            for (Team invite : this.inviteScroll.getVisibleEntries()) {
                if (this.gui.inBounds(25, inviteY, (int)((float)this.gui.getStringWidth(invite.getName()) * 0.7f), 6, mX, mY)) {
                    this.inviteTeam = invite;
                    break;
                }
                inviteY += 11;
            }
        } else if (!team.isSingle() && this.getEntry(team).isOwner()) {
            int infoY;
            int memberY = 32;
            for (PlayerEntry entry : this.memberScroll.getVisibleEntries(team.getPlayers(), 16)) {
                if (this.gui.inBounds(25, memberY, (int)((float)this.gui.getStringWidth(entry.getDisplayName()) * 0.7f), 6, mX, mY)) {
                    this.selectedEntry = this.selectedEntry == entry ? null : entry;
                    break;
                }
                memberY += 11;
            }
            if (this.gui.inBounds(180, infoY = this.getInfoY(), 16, 16, mX, mY)) {
                team.nextLifeSetting();
            } else if (this.gui.inBounds(180, infoY + 20, 16, 16, mX, mY)) {
                team.nextRewardSetting();
            }
        }
    }

    private int getInfoY() {
        if (this.inviteTeam != null) {
            return 80;
        }
        if (this.getEntry(this.getTeam()).isOwner()) {
            return this.selectedEntry != null ? 80 : 50;
        }
        return 20;
    }

    private Team getTeam() {
        return QuestingDataManager.getInstance().getQuestingData(this.playerId).getTeam();
    }

    private PlayerEntry getEntry(Team team) {
        return team.getEntry(this.playerId);
    }
}

