/*
 * Decompiled with CFR 0.152.
 */
package hardcorequesting.common.forge.client.interfaces.graphic.task;

import hardcorequesting.common.forge.client.EditMode;
import hardcorequesting.common.forge.client.interfaces.GuiQuestBook;
import hardcorequesting.common.forge.client.interfaces.edit.PickAdvancementMenu;
import hardcorequesting.common.forge.client.interfaces.graphic.task.IconTaskGraphic;
import hardcorequesting.common.forge.quests.task.icon.GetAdvancementTask;
import hardcorequesting.common.forge.util.Translator;
import java.util.UUID;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.FormattedText;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class AdvancementTaskGraphic
extends IconTaskGraphic<GetAdvancementTask.Part> {
    private final GetAdvancementTask task;

    public AdvancementTaskGraphic(GetAdvancementTask task, UUID playerId, GuiQuestBook gui) {
        super(task, playerId, gui);
        this.task = task;
        this.addDetectButton(task);
    }

    @Override
    protected void drawElementText(GuiGraphics graphics, GetAdvancementTask.Part part, int id, int x, int y) {
        if (this.task.advanced(id, this.playerId)) {
            this.gui.drawString(graphics, (FormattedText)Translator.translatable("hqm.advancementMenu.visited", new Object[0]).m_130940_(ChatFormatting.DARK_GREEN), x, y, 0.7f, 0x404040);
        }
    }

    @Override
    protected boolean handleEditPartClick(EditMode mode, GetAdvancementTask.Part part, int id) {
        if (mode == EditMode.LOCATION) {
            PickAdvancementMenu.display(this.gui, part.getAdvancement(), result -> this.task.setAdvancement(id, (String)result));
            return true;
        }
        return super.handleEditPartClick(mode, part, id);
    }
}

