/*
 * Decompiled with CFR 0.152.
 */
package hardcorequesting.common.forge.client.interfaces.graphic.task;

import dev.architectury.fluid.FluidStack;
import hardcorequesting.common.forge.client.EditMode;
import hardcorequesting.common.forge.client.interfaces.GuiQuestBook;
import hardcorequesting.common.forge.client.interfaces.graphic.task.ListTaskGraphic;
import hardcorequesting.common.forge.quests.Quest;
import hardcorequesting.common.forge.quests.task.CompleteQuestTask;
import hardcorequesting.common.forge.util.EditType;
import hardcorequesting.common.forge.util.Positioned;
import hardcorequesting.common.forge.util.SaveHelper;
import hardcorequesting.common.forge.util.Translator;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class CompleteQuestTaskGraphic
extends ListTaskGraphic<CompleteQuestTask.Part> {
    private static final int Y_OFFSET = 30;
    private static final int X_TEXT_OFFSET = 23;
    private static final int X_TEXT_INDENT = 0;
    private static final int Y_TEXT_OFFSET = 0;
    private static final int ITEM_SIZE = 18;
    private final CompleteQuestTask task;

    public CompleteQuestTaskGraphic(CompleteQuestTask task, UUID playerId, GuiQuestBook gui) {
        super(task, task.getParts(), playerId, gui);
        this.task = task;
        this.addDetectButton(task);
    }

    @Override
    protected List<Positioned<CompleteQuestTask.Part>> positionParts(List<CompleteQuestTask.Part> parts) {
        ArrayList<Positioned<CompleteQuestTask.Part>> list = new ArrayList<Positioned<CompleteQuestTask.Part>>(parts.size());
        int x = 180;
        int y = 95;
        for (CompleteQuestTask.Part part : parts) {
            list.add(new Positioned<CompleteQuestTask.Part>(x, y, part));
            y += 30;
        }
        return list;
    }

    @Override
    protected void drawPart(GuiGraphics graphics, CompleteQuestTask.Part part, int id, int x, int y, int mX, int mY) {
        part.getIconStack().ifLeft(itemStack -> this.gui.drawItemStack(graphics, (ItemStack)itemStack, x, y, mX, mY, false)).ifRight(fluidStack -> this.gui.drawFluid((FluidStack)fluidStack, graphics, x, y, mX, mY));
        if (part.getQuest() != null) {
            this.gui.drawString(graphics, part.getName(), x + 23, y + 0, 0x404040);
            if (this.task.completed(id, this.playerId)) {
                this.gui.drawString(graphics, (FormattedText)Translator.translatable("hqm.completedMenu.visited", new Object[0]).m_130940_(ChatFormatting.DARK_GREEN), x + 23 + 0, y + 0 + 9, 0.7f, 0x404040);
            }
        } else {
            this.gui.drawString(graphics, (FormattedText)Translator.translatable("hqm.completionTask.firstline", new Object[0]).m_130940_(ChatFormatting.DARK_RED), x + 23, y + 0, 0x404040);
            this.gui.drawString(graphics, (FormattedText)Translator.translatable("hqm.completionTask.secondline", new Object[0]).m_130940_(ChatFormatting.DARK_RED), x + 23, y + 0 + 9, 0x404040);
            this.gui.drawString(graphics, (FormattedText)Translator.translatable("hqm.completionTask.thirdline", new Object[0]).m_130940_(ChatFormatting.DARK_RED), x + 23, y + 0 + 18, 0x404040);
        }
    }

    @Override
    protected boolean handleEditPartClick(EditMode mode, CompleteQuestTask.Part part, int id) {
        if (super.handleEditPartClick(mode, part, id)) {
            return true;
        }
        if (Quest.speciallySelectedQuestId != null) {
            ((CompleteQuestTask.Part)this.parts.getOrCreateForModify(id)).setQuest(Quest.speciallySelectedQuestId);
            SaveHelper.add(EditType.COMPLETE_CHECK_CHANGE);
            return true;
        }
        return false;
    }

    @Override
    protected boolean isInPartBounds(int mX, int mY, Positioned<CompleteQuestTask.Part> pos) {
        return this.gui.inBounds(pos.getX(), pos.getY(), 18, 18, mX, mY);
    }
}

