/*
 * Decompiled with CFR 0.152.
 */
package hardcorequesting.common.forge.client.interfaces.graphic.task;

import hardcorequesting.common.forge.client.interfaces.GuiQuestBook;
import hardcorequesting.common.forge.client.interfaces.edit.IntInputMenu;
import hardcorequesting.common.forge.client.interfaces.graphic.task.TaskGraphic;
import hardcorequesting.common.forge.client.interfaces.widget.LargeButton;
import hardcorequesting.common.forge.quests.Quest;
import hardcorequesting.common.forge.quests.task.DeathTask;
import hardcorequesting.common.forge.util.Translator;
import java.util.UUID;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class DeathTaskGraphic
extends TaskGraphic {
    private final DeathTask task;

    public DeathTaskGraphic(final DeathTask task, UUID playerId, final GuiQuestBook gui) {
        super(playerId, gui, task);
        this.task = task;
        this.addClickable(new LargeButton(gui, "hqm.quest.requirement", 185, 200){

            @Override
            public boolean isVisible() {
                return Quest.canQuestsBeEdited();
            }

            @Override
            public void onClick() {
                IntInputMenu.display(gui, "hqm.deathTask.reqDeathCount", task.getDeathsRequired(), task::setDeaths);
            }
        });
    }

    @Override
    public void draw(GuiGraphics graphics, int mX, int mY) {
        int died = this.task.getDeaths(this.playerId);
        MutableComponent text = died == this.task.getDeathsRequired() ? Translator.translatable("hqm.deathMenu.deaths", Translator.plural("hqm.times", this.task.getDeathsRequired())).m_130940_(ChatFormatting.DARK_GREEN) : Translator.translatable("hqm.deathMenu.deathsOutOf", died, Translator.plural("hqm.times", this.task.getDeathsRequired()));
        this.gui.drawString(graphics, this.gui.getLinesFromText((FormattedText)text, 1.0f, 130), 180, 95, 1.0f, 0x404040);
        super.draw(graphics, mX, mY);
    }
}

