/*
 * Decompiled with CFR 0.152.
 */
package hardcorequesting.common.forge.client.interfaces.graphic.task;

import com.mojang.datafixers.util.Either;
import dev.architectury.fluid.FluidStack;
import hardcorequesting.common.forge.client.EditMode;
import hardcorequesting.common.forge.client.interfaces.GuiQuestBook;
import hardcorequesting.common.forge.client.interfaces.edit.PickItemMenu;
import hardcorequesting.common.forge.client.interfaces.edit.WrappedTextMenu;
import hardcorequesting.common.forge.client.interfaces.graphic.task.ListTaskGraphic;
import hardcorequesting.common.forge.quests.task.icon.IconLayoutTask;
import hardcorequesting.common.forge.util.Positioned;
import hardcorequesting.common.forge.util.WrappedText;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public abstract class IconTaskGraphic<Part extends IconLayoutTask.Part>
extends ListTaskGraphic<Part> {
    private static final int Y_OFFSET = 30;
    private static final int X_TEXT_OFFSET = 23;
    private static final int X_TEXT_INDENT = 0;
    private static final int Y_TEXT_OFFSET = 0;
    private static final int ITEM_SIZE = 18;
    private final IconLayoutTask<Part, ?> task;

    public IconTaskGraphic(IconLayoutTask<Part, ?> task, UUID playerId, GuiQuestBook gui) {
        super(task, task.getParts(), playerId, gui);
        this.task = task;
    }

    protected abstract void drawElementText(GuiGraphics var1, Part var2, int var3, int var4, int var5);

    @Override
    protected List<Positioned<Part>> positionParts(List<Part> parts) {
        ArrayList<Positioned<Part>> list = new ArrayList<Positioned<Part>>(parts.size());
        int x = 180;
        int y = 95;
        for (IconLayoutTask.Part part : parts) {
            list.add(new Positioned<IconLayoutTask.Part>(x, y, part));
            y += 30;
        }
        return list;
    }

    @Override
    protected void drawPart(GuiGraphics graphics, Part part, int id, int x, int y, int mX, int mY) {
        int textX = x + 23;
        int textY = y + 0;
        ((IconLayoutTask.Part)part).getIconStack().ifLeft(itemStack -> this.gui.drawItemStack(graphics, (ItemStack)itemStack, x, y, mX, mY, false)).ifRight(fluidStack -> this.gui.drawFluid((FluidStack)fluidStack, graphics, x, y, mX, mY));
        this.gui.drawString(graphics, (FormattedText)((IconLayoutTask.Part)part).getName(), textX, textY, 0x404040);
        this.drawElementText(graphics, part, id, textX + 0, textY + 9);
    }

    @Override
    protected boolean handleEditPartClick(EditMode mode, Part part, int id) {
        if (mode == EditMode.ITEM) {
            PickItemMenu.display(this.gui, ((IconLayoutTask.Part)part).getIconStack(), PickItemMenu.Type.ITEM_FLUID, result -> this.task.setIcon(id, (Either<ItemStack, FluidStack>)((Either)result.get())));
            return true;
        }
        if (mode == EditMode.RENAME) {
            WrappedTextMenu.display(this.gui, ((IconLayoutTask.Part)part).getRawName(), 110, result -> this.task.setName(id, (WrappedText)result));
            return true;
        }
        return super.handleEditPartClick(mode, part, id);
    }

    @Override
    protected boolean isInPartBounds(int mX, int mY, Positioned<Part> pos) {
        return this.gui.inBounds(pos.getX(), pos.getY(), 18, 18, mX, mY);
    }
}

