/*
 * Decompiled with CFR 0.152.
 */
package hardcorequesting.common.forge.client.interfaces.graphic.task;

import com.mojang.datafixers.util.Either;
import dev.architectury.fluid.FluidStack;
import hardcorequesting.common.forge.client.EditMode;
import hardcorequesting.common.forge.client.interfaces.GuiQuestBook;
import hardcorequesting.common.forge.client.interfaces.edit.PickItemMenu;
import hardcorequesting.common.forge.client.interfaces.graphic.task.ListTaskGraphic;
import hardcorequesting.common.forge.client.interfaces.widget.LargeButton;
import hardcorequesting.common.forge.network.GeneralUsage;
import hardcorequesting.common.forge.quests.Quest;
import hardcorequesting.common.forge.quests.QuestingData;
import hardcorequesting.common.forge.quests.QuestingDataManager;
import hardcorequesting.common.forge.quests.task.item.ItemRequirementTask;
import hardcorequesting.common.forge.util.OPBookHelper;
import hardcorequesting.common.forge.util.Positioned;
import hardcorequesting.common.forge.util.Translator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.UUID;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class ItemTaskGraphic
extends ListTaskGraphic<ItemRequirementTask.Part> {
    private static final int MAX_X = 300;
    private static final int OFFSET = 20;
    private static final int SIZE = 18;
    private long lastClicked;
    private final ItemRequirementTask task;

    public ItemTaskGraphic(ItemRequirementTask task, UUID playerId, GuiQuestBook gui) {
        super(task, task.getParts(), playerId, gui);
        this.task = task;
    }

    public static ItemTaskGraphic createDetectGraphic(ItemRequirementTask task, UUID playerId, GuiQuestBook gui) {
        ItemTaskGraphic graphic = new ItemTaskGraphic(task, playerId, gui);
        graphic.addDetectButton(task);
        return graphic;
    }

    public static ItemTaskGraphic createConsumeGraphic(final ItemRequirementTask task, final UUID playerId, GuiQuestBook gui, boolean hasSubmitButton) {
        ItemTaskGraphic graphic = new ItemTaskGraphic(task, playerId, gui);
        if (hasSubmitButton) {
            graphic.addSubmitButton(task);
        }
        graphic.addClickable(new LargeButton(gui, "hqm.quest.selectTask", 250, 200){

            @Override
            public boolean isEnabled() {
                QuestingData data = QuestingDataManager.getInstance().getQuestingData(playerId);
                if (data != null && data.selectedQuestId != null && data.selectedQuestId.equals(task.getParent().getQuestId())) {
                    return data.selectedTask != task.getId();
                }
                return false;
            }

            @Override
            public boolean isVisible() {
                return !task.isCompleted(playerId);
            }

            @Override
            public void onClick() {
                QuestingDataManager.getInstance().getQuestingData((UUID)playerId).selectedQuestId = task.getParent().getQuestId();
                QuestingDataManager.getInstance().getQuestingData((UUID)playerId).selectedTask = task.getId();
                Minecraft.m_91087_().f_91074_.m_5661_((Component)Component.m_237110_((String)"tile.hqm:item_barrel.selectedTask", (Object[])new Object[]{task.getName()}).m_130940_(ChatFormatting.GREEN), false);
                GeneralUsage.sendBookSelectTaskUpdate(task);
            }
        });
        return graphic;
    }

    @Override
    protected List<Positioned<ItemRequirementTask.Part>> positionParts(List<ItemRequirementTask.Part> parts) {
        ArrayList<Positioned<ItemRequirementTask.Part>> list = new ArrayList<Positioned<ItemRequirementTask.Part>>(parts.size());
        int x = 180;
        int y = 95;
        for (ItemRequirementTask.Part item : parts) {
            list.add(new Positioned<ItemRequirementTask.Part>(x, y, item));
            if ((x += 20) <= 300) continue;
            x = 180;
            y += 20;
        }
        return list;
    }

    @Override
    protected void drawPart(GuiGraphics graphics, ItemRequirementTask.Part part, int id, int x, int y, int mX, int mY) {
        part.stack.ifLeft(itemStack -> this.gui.drawItemStack(graphics, part.getPermutatedItem(), x, y, mX, mY, false)).ifRight(fluidStack -> this.gui.drawFluid((FluidStack)fluidStack, graphics, x, y, mX, mY));
        FormattedText progressText = Translator.plain(this.task.getProgress(this.playerId, id) * 100 / part.required + "%");
        graphics.m_280168_().m_85836_();
        graphics.m_280168_().m_252880_(0.0f, 0.0f, 200.0f);
        float textSize = 0.8f;
        boolean hasCountLine = part.stack.left().map(itemStack -> itemStack.m_41613_() > 1).orElse(false);
        this.gui.drawStringWithShadow(graphics, progressText, (int)((float)(x + 18) - (float)this.gui.getStringWidth(progressText) * textSize), (int)((float)(y + 18 - (hasCountLine ? 9 : 0)) - 9.0f * textSize + 2.0f), textSize, this.task.getProgress(this.playerId, id) == part.required ? 0x308030 : 0xFFFFFF);
        graphics.m_280168_().m_85849_();
    }

    @Override
    protected List<FormattedText> getPartTooltip(Positioned<ItemRequirementTask.Part> pos, int id, int mX, int mY) {
        ItemRequirementTask.Part part = pos.getElement();
        if (this.isInPartBounds(mX, mY, pos)) {
            ArrayList<FormattedText> str = new ArrayList<FormattedText>();
            part.stack.ifRight(fluidStack -> {
                ArrayList<MutableComponent> list = new ArrayList<MutableComponent>();
                str.add((FormattedText)Component.m_237113_((String)fluidStack.getName().getString()));
                if (Minecraft.m_91087_().f_91066_.f_92125_) {
                    String entryId = BuiltInRegistries.f_257020_.m_7981_((Object)fluidStack.getFluid()).toString();
                    list.add(Component.m_237113_((String)entryId).m_130940_(ChatFormatting.DARK_GRAY));
                }
                str.addAll(list);
            }).ifLeft(itemStack -> str.addAll(Screen.m_280152_((Minecraft)Minecraft.m_91087_(), (ItemStack)itemStack)));
            str.add(FormattedText.m_130773_((FormattedText[])new FormattedText[]{Translator.translatable("hqm.questBook.itemRequirementProgress", new Object[0]), Translator.plain(": " + this.task.getProgress(this.playerId, id) + "/" + part.required)}));
            if (part.hasItem() && Quest.canQuestsBeEdited()) {
                str.add(FormattedText.f_130760_);
                str.add((FormattedText)Translator.text(part.getPrecision().getName()).m_130940_(ChatFormatting.DARK_GRAY));
            }
            if (this.gui.isOpBook && Screen.m_96638_()) {
                if (this.task.getProgress(this.playerId, id) == part.required) {
                    str.addAll(Arrays.asList(FormattedText.f_130760_, FormattedText.f_130760_, Translator.translatable("hqm.questBook.resetTask", new Object[0]).m_130940_(ChatFormatting.DARK_RED)));
                } else {
                    str.addAll(Arrays.asList(FormattedText.f_130760_, FormattedText.f_130760_, Translator.translatable("hqm.questBook.completeTask", new Object[0]).m_130940_(ChatFormatting.GOLD)));
                }
            }
            return str;
        }
        return null;
    }

    @Override
    protected boolean isInPartBounds(int mX, int mY, Positioned<ItemRequirementTask.Part> pos) {
        return this.gui.inBounds(pos.getX(), pos.getY(), 18, 18, mX, mY);
    }

    @Override
    protected void handlePartClick(ItemRequirementTask.Part part, int id) {
        if (this.gui.isOpBook && Screen.m_96638_()) {
            OPBookHelper.reverseRequirementCompletion(this.task, id, this.playerId);
        } else if (Quest.canQuestsBeEdited()) {
            super.handlePartClick(part, id);
        }
    }

    @Override
    protected boolean handleEditPartClick(EditMode mode, ItemRequirementTask.Part part, int id) {
        boolean doubleClick = false;
        long tickCount = Minecraft.m_91087_().f_91073_.m_46467_();
        long lastDiff = tickCount - this.lastClicked;
        if (0L <= lastDiff && lastDiff < 6L) {
            doubleClick = true;
        } else {
            this.lastClicked = tickCount;
        }
        if (this.gui.getCurrentMode() == EditMode.ITEM || doubleClick) {
            if (this.task.mayUseFluids()) {
                PickItemMenu.display(this.gui, part.stack, PickItemMenu.Type.ITEM_FLUID, part.required, part.getPrecision(), result -> this.task.setItem((Either<ItemStack, FluidStack>)((Either)result.get()), result.getAmount(), result.getPrecision(), id));
            } else {
                PickItemMenu.display(this.gui, part.getStack(), PickItemMenu.Type.ITEM, part.required, part.getPrecision(), result -> this.task.setItem((Either<ItemStack, FluidStack>)Either.left((Object)((ItemStack)result.get())), result.getAmount(), result.getPrecision(), id));
            }
            return true;
        }
        return super.handleEditPartClick(mode, part, id);
    }
}

