/*
 * Decompiled with CFR 0.152.
 */
package hardcorequesting.common.forge.client.interfaces.graphic.task;

import hardcorequesting.common.forge.client.EditMode;
import hardcorequesting.common.forge.client.interfaces.GuiQuestBook;
import hardcorequesting.common.forge.client.interfaces.edit.PickMobMenu;
import hardcorequesting.common.forge.client.interfaces.graphic.task.IconTaskGraphic;
import hardcorequesting.common.forge.quests.task.icon.KillMobsTask;
import hardcorequesting.common.forge.util.Translator;
import java.util.UUID;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.FormattedText;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class KillMobsTaskGraphic
extends IconTaskGraphic<KillMobsTask.Part> {
    private final KillMobsTask task;

    public KillMobsTaskGraphic(KillMobsTask task, UUID playerId, GuiQuestBook gui) {
        super(task, playerId, gui);
        this.task = task;
    }

    @Override
    protected void drawElementText(GuiGraphics graphics, KillMobsTask.Part part, int index, int x, int y) {
        int killed = this.task.killed(index, this.playerId);
        if (killed == part.getCount()) {
            this.gui.drawString(graphics, (FormattedText)Translator.translatable("hqm.mobTask.allKilled", new Object[0]).m_130940_(ChatFormatting.DARK_GREEN), x, y, 0.7f, 0x404040);
        } else {
            this.gui.drawString(graphics, (FormattedText)Translator.translatable("hqm.mobTask.partKills", killed, 100 * killed / part.getCount()), x, y, 0.7f, 0x404040);
        }
        this.gui.drawString(graphics, (FormattedText)Translator.translatable("hqm.mobTask.totalKills", part.getCount()), x, y + 6, 0.7f, 0x404040);
    }

    @Override
    protected boolean handleEditPartClick(EditMode mode, KillMobsTask.Part part, int id) {
        if (mode == EditMode.MOB) {
            PickMobMenu.display(this.gui, part.getMob(), part.getCount(), "mobTask", result -> this.task.setInfo(id, result.getMobId(), result.getAmount()));
            return true;
        }
        return super.handleEditPartClick(mode, part, id);
    }
}

