/*
 * Decompiled with CFR 0.152.
 */
package hardcorequesting.common.forge.client.interfaces.graphic.task;

import hardcorequesting.common.forge.client.interfaces.GuiQuestBook;
import hardcorequesting.common.forge.client.interfaces.edit.IntInputMenu;
import hardcorequesting.common.forge.client.interfaces.graphic.task.ReputationTaskGraphic;
import hardcorequesting.common.forge.client.interfaces.widget.LargeButton;
import hardcorequesting.common.forge.quests.Quest;
import hardcorequesting.common.forge.quests.task.reputation.KillReputationTask;
import hardcorequesting.common.forge.util.Translator;
import java.util.UUID;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.FormattedText;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class KillReputationTaskGraphic
extends ReputationTaskGraphic {
    private final KillReputationTask task;

    public KillReputationTaskGraphic(final KillReputationTask task, UUID playerId, final GuiQuestBook gui) {
        super(task, playerId, gui, 20);
        this.task = task;
        this.addClickable(new LargeButton(gui, "hqm.quest.requirement", 250, 95){

            @Override
            public boolean isVisible() {
                return Quest.canQuestsBeEdited();
            }

            @Override
            public void onClick() {
                IntInputMenu.display(gui, "hqm.mobTask.reqKills", task.getKillsRequirement(), task::setKills);
            }
        });
    }

    @Override
    protected boolean shouldShowPlayer() {
        return false;
    }

    @Override
    public void draw(GuiGraphics graphics, int mX, int mY) {
        super.draw(graphics, mX, mY);
        int killCount = this.task.getKills(this.playerId);
        if (Quest.canQuestsBeEdited()) {
            this.gui.drawString(graphics, this.gui.getLinesFromText((FormattedText)Translator.translatable("hqm.repKil.kills", killCount, Translator.player(this.task.getKillsRequirement())), 1.0f, 130), 180, 95, 1.0f, 0x404040);
        } else {
            this.gui.drawString(graphics, this.gui.getLinesFromText((FormattedText)(killCount == this.task.getKillsRequirement() ? Translator.translatable("hqm.repKil.killCount", Translator.player(this.task.getKillsRequirement())).m_130940_(ChatFormatting.DARK_GREEN) : Translator.translatable("hqm.repKil.killCountOutOf", killCount, Translator.player(this.task.getKillsRequirement()))), 1.0f, 130), 180, 95, 1.0f, 0x404040);
        }
    }
}

