/*
 * Decompiled with CFR 0.152.
 */
package hardcorequesting.common.forge.client.interfaces.graphic.task;

import hardcorequesting.common.forge.client.EditMode;
import hardcorequesting.common.forge.client.interfaces.GuiQuestBook;
import hardcorequesting.common.forge.client.interfaces.graphic.task.TaskGraphic;
import hardcorequesting.common.forge.quests.Quest;
import hardcorequesting.common.forge.quests.task.PartList;
import hardcorequesting.common.forge.quests.task.QuestTask;
import hardcorequesting.common.forge.util.Positioned;
import java.util.List;
import java.util.UUID;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.FormattedText;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public abstract class ListTaskGraphic<Part>
extends TaskGraphic {
    protected final PartList<Part> parts;

    public ListTaskGraphic(QuestTask<?> task, PartList<Part> parts, UUID playerId, GuiQuestBook gui) {
        super(playerId, gui, task);
        this.parts = parts;
    }

    protected abstract List<Positioned<Part>> positionParts(List<Part> var1);

    protected abstract void drawPart(GuiGraphics var1, Part var2, int var3, int var4, int var5, int var6, int var7);

    protected List<FormattedText> getPartTooltip(Positioned<Part> pos, int id, int mX, int mY) {
        return null;
    }

    protected abstract boolean isInPartBounds(int var1, int var2, Positioned<Part> var3);

    protected void handlePartClick(Part part, int id) {
        if (Quest.canQuestsBeEdited() && this.gui.getCurrentMode() != EditMode.NORMAL) {
            this.handleEditPartClick(this.gui.getCurrentMode(), part, id);
        }
    }

    protected boolean handleEditPartClick(EditMode mode, Part part, int id) {
        if (mode == EditMode.DELETE) {
            this.parts.remove(id);
            return true;
        }
        return false;
    }

    @Override
    public void draw(GuiGraphics graphics, int mX, int mY) {
        List<Positioned<Part>> renderElements = this.positionParts(this.parts.getShownElements());
        for (int i = 0; i < renderElements.size(); ++i) {
            Positioned<Part> pos = renderElements.get(i);
            Part part = pos.getElement();
            this.drawPart(graphics, part, i, pos.getX(), pos.getY(), mX, mY);
        }
        super.draw(graphics, mX, mY);
    }

    @Override
    public void drawTooltip(GuiGraphics graphics, int mX, int mY) {
        List<Positioned<Part>> renderElements = this.positionParts(this.parts.getShownElements());
        for (int i = 0; i < renderElements.size(); ++i) {
            Positioned<Part> pos = renderElements.get(i);
            List<FormattedText> tooltip = this.getPartTooltip(pos, i, mX, mY);
            if (tooltip == null) continue;
            this.gui.renderTooltipL(graphics, tooltip, this.gui.getLeft() + mX, this.gui.getTop() + mY);
            return;
        }
        super.drawTooltip(graphics, mX, mY);
    }

    @Override
    public void onClick(int mX, int mY, int b) {
        int id = this.getClickedPart(mX, mY);
        if (id >= 0) {
            this.handlePartClick(this.parts.getShownElements().get(id), id);
        }
        super.onClick(mX, mY, b);
    }

    protected final int getClickedPart(int mX, int mY) {
        List<Positioned<Part>> elements = this.positionParts(this.parts.getShownElements());
        for (int i = 0; i < elements.size(); ++i) {
            if (!this.isInPartBounds(mX, mY, elements.get(i))) continue;
            return i;
        }
        return -1;
    }
}

