/*
 * Decompiled with CFR 0.152.
 */
package hardcorequesting.common.forge.client.interfaces.graphic.task;

import hardcorequesting.common.forge.client.EditMode;
import hardcorequesting.common.forge.client.interfaces.GuiQuestBook;
import hardcorequesting.common.forge.client.interfaces.edit.LocationMenu;
import hardcorequesting.common.forge.client.interfaces.graphic.task.IconTaskGraphic;
import hardcorequesting.common.forge.quests.task.icon.VisitLocationTask;
import hardcorequesting.common.forge.util.Translator;
import java.util.Objects;
import java.util.UUID;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class LocationTaskGraphic
extends IconTaskGraphic<VisitLocationTask.Part> {
    private final VisitLocationTask task;

    public LocationTaskGraphic(VisitLocationTask task, UUID playerId, GuiQuestBook gui) {
        super(task, playerId, gui);
        this.task = task;
    }

    @Override
    protected void drawElementText(GuiGraphics graphics, VisitLocationTask.Part part, int index, int x, int y) {
        if (this.task.visited(index, this.playerId)) {
            this.gui.drawString(graphics, (FormattedText)Translator.translatable("hqm.locationMenu.visited", new Object[0]).m_130940_(ChatFormatting.DARK_GREEN), x, y, 0.7f, 0x404040);
        } else if (part.getVisibility().doShowCoordinate()) {
            int row = 0;
            if (part.getRadius() >= 0) {
                this.gui.drawString(graphics, Translator.plain("(" + part.getPosition().m_123344_() + ")"), x, y, 0.7f, 0x404040);
                ++row;
            }
            Minecraft mc = Minecraft.m_91087_();
            if (Objects.equals(mc.f_91073_.m_46472_().m_135782_().toString(), part.getDimension())) {
                if (part.getRadius() >= 0) {
                    int distance = (int)mc.f_91074_.m_20275_((double)part.getPosition().m_123341_() + 0.5, (double)part.getPosition().m_123342_() + 0.5, (double)part.getPosition().m_123343_() + 0.5);
                    MutableComponent str = Translator.translatable("hqm.locationMenu.mAway", distance);
                    if (part.getVisibility().doShowRadius()) {
                        str = FormattedText.m_130773_((FormattedText[])new FormattedText[]{str, Translator.plain(" ["), Translator.translatable("hqm.locationMenu.mRadius", part.getRadius()), Translator.plain("]")});
                    }
                    this.gui.drawString(graphics, (FormattedText)str, x, y + 6 * row, 0.7f, 0x404040);
                }
            } else {
                this.gui.drawString(graphics, (FormattedText)Translator.translatable("hqm.locationMenu.wrongDim", new Object[0]), x, y + 6 * row, 0.7f, 0x404040);
            }
        }
    }

    @Override
    protected boolean handleEditPartClick(EditMode mode, VisitLocationTask.Part part, int id) {
        if (mode == EditMode.LOCATION) {
            LocationMenu.display(this.gui, part.getVisibility(), part.getPosition(), part.getRadius(), part.getDimension(), result -> this.task.setInfo(id, result.getVisibility(), result.getPos(), result.getRadius(), result.getDimension()));
            return true;
        }
        return super.handleEditPartClick(mode, part, id);
    }
}

