/*
 * Decompiled with CFR 0.152.
 */
package hardcorequesting.common.forge.client.interfaces.graphic.task;

import hardcorequesting.common.forge.client.EditMode;
import hardcorequesting.common.forge.client.interfaces.GuiBase;
import hardcorequesting.common.forge.client.interfaces.GuiQuestBook;
import hardcorequesting.common.forge.client.interfaces.edit.ReputationTaskPartMenu;
import hardcorequesting.common.forge.client.interfaces.graphic.task.ListTaskGraphic;
import hardcorequesting.common.forge.quests.task.reputation.ReputationTask;
import hardcorequesting.common.forge.util.Positioned;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.FormattedText;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class ReputationTaskGraphic
extends ListTaskGraphic<ReputationTask.Part> {
    private static final int OFFSET_Y = 27;
    private final int startOffsetY;
    private final ReputationTask<?> task;

    public ReputationTaskGraphic(ReputationTask<?> task, UUID playerId, GuiQuestBook gui) {
        this(task, playerId, gui, 0);
    }

    protected ReputationTaskGraphic(ReputationTask<?> task, UUID playerId, GuiQuestBook gui, int startOffsetY) {
        super(task, task.getParts(), playerId, gui);
        this.task = task;
        this.startOffsetY = startOffsetY;
    }

    @Override
    protected List<Positioned<ReputationTask.Part>> positionParts(List<ReputationTask.Part> parts) {
        ArrayList<Positioned<ReputationTask.Part>> list = new ArrayList<Positioned<ReputationTask.Part>>(parts.size());
        int x = 180;
        int y = 95 + this.startOffsetY;
        for (ReputationTask.Part part : parts) {
            list.add(new Positioned<ReputationTask.Part>(x, y, part));
            y += 27;
        }
        return list;
    }

    protected boolean shouldShowPlayer() {
        return true;
    }

    @Override
    protected void drawPart(GuiGraphics graphics, ReputationTask.Part part, int id, int x, int y, int mX, int mY) {
        this.gui.applyColor(-1);
        if (part.getReputation() == null) {
            this.gui.drawRect(graphics, GuiBase.MAP_TEXTURE, x + 0, y + 5, 0, 101, 125, 3);
        } else {
            part.getReputation().draw(graphics, this.gui, x, y, mX, mY, this.shouldShowPlayer() ? this.playerId : null, true, part.getLower(), part.getUpper(), part.isInverted(), null, null, this.task.isCompleted(this.playerId));
        }
    }

    @Override
    protected List<FormattedText> getPartTooltip(Positioned<ReputationTask.Part> pos, int id, int mX, int mY) {
        FormattedText text;
        ReputationTask.Part part = pos.getElement();
        if (part.getReputation() != null && (text = part.getReputation().getTooltip(this.gui, pos.getX(), pos.getY(), mX, mY, this.playerId)) != null) {
            return Collections.singletonList(text);
        }
        return null;
    }

    @Override
    protected boolean isInPartBounds(int mX, int mY, Positioned<ReputationTask.Part> pos) {
        return this.gui.inBounds(pos.getX(), pos.getY(), 125, 20, mX, mY);
    }

    @Override
    protected boolean handleEditPartClick(EditMode mode, ReputationTask.Part part, int id) {
        if (this.gui.getCurrentMode() == EditMode.REPUTATION_TASK) {
            ReputationTaskPartMenu.display(this.gui, this.playerId, part, newPart -> this.task.setSetting(id, (ReputationTask.Part)newPart));
            return true;
        }
        return super.handleEditPartClick(mode, part, id);
    }
}

