/*
 * Decompiled with CFR 0.152.
 */
package hardcorequesting.common.forge.client.interfaces.graphic.task;

import hardcorequesting.common.forge.client.EditMode;
import hardcorequesting.common.forge.client.interfaces.GuiQuestBook;
import hardcorequesting.common.forge.client.interfaces.edit.PickMobMenu;
import hardcorequesting.common.forge.client.interfaces.graphic.task.IconTaskGraphic;
import hardcorequesting.common.forge.quests.task.icon.TameMobsTask;
import hardcorequesting.common.forge.util.Translator;
import java.util.UUID;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class TameMobsTaskGraphic
extends IconTaskGraphic<TameMobsTask.Part> {
    private final TameMobsTask task;

    public TameMobsTaskGraphic(TameMobsTask task, UUID playerId, GuiQuestBook gui) {
        super(task, playerId, gui);
        this.task = task;
    }

    @Override
    protected void drawElementText(GuiGraphics graphics, TameMobsTask.Part part, int index, int x, int y) {
        int tamed = this.task.tamed(index, this.playerId);
        if (tamed == part.getCount()) {
            this.gui.drawString(graphics, (FormattedText)Translator.translatable("hqm.tameTask.allTamed", new Object[0]).m_130940_(ChatFormatting.DARK_GREEN), x, y, 0.7f, 0x404040);
        } else {
            this.gui.drawString(graphics, (FormattedText)Translator.translatable("hqm.tameTask.partTames", tamed, 100 * tamed / part.getCount()), x, y, 0.7f, 0x404040);
        }
        this.gui.drawString(graphics, (FormattedText)Translator.translatable("hqm.tameTask.totalTames", part.getCount()), x, y + 6, 0.7f, 0x404040);
    }

    @Override
    protected boolean handleEditPartClick(EditMode mode, TameMobsTask.Part part, int id) {
        if (mode == EditMode.MOB) {
            PickMobMenu.display(this.gui, part.getTame() == null ? null : ResourceLocation.m_135820_((String)part.getTame()), part.getCount(), "tameTask", PickMobMenu.EXTRA_TAME_ENTRIES, result -> this.task.setInfo(id, result.getMobId().toString(), result.getAmount()));
            return true;
        }
        return super.handleEditPartClick(mode, part, id);
    }
}

