/*
 * Decompiled with CFR 0.152.
 */
package hardcorequesting.common.forge.client.interfaces.graphic.task;

import hardcorequesting.common.forge.client.ClientChange;
import hardcorequesting.common.forge.client.EditMode;
import hardcorequesting.common.forge.client.interfaces.GuiQuestBook;
import hardcorequesting.common.forge.client.interfaces.edit.WrappedTextMenu;
import hardcorequesting.common.forge.client.interfaces.graphic.Graphic;
import hardcorequesting.common.forge.client.interfaces.widget.ExtendedScrollBar;
import hardcorequesting.common.forge.client.interfaces.widget.LargeButton;
import hardcorequesting.common.forge.client.interfaces.widget.ScrollBar;
import hardcorequesting.common.forge.network.NetworkManager;
import hardcorequesting.common.forge.quests.task.QuestTask;
import hardcorequesting.common.forge.util.WrappedText;
import java.util.List;
import java.util.UUID;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.FormattedText;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public abstract class TaskGraphic
extends Graphic {
    protected static final int START_X = 180;
    protected static final int START_Y = 95;
    private static final int VISIBLE_DESCRIPTION_LINES = 7;
    private static final int TASK_DESCRIPTION_X = 180;
    private static final int TASK_DESCRIPTION_Y = 20;
    private final ExtendedScrollBar<FormattedText> taskDescriptionScroll;
    protected final UUID playerId;
    protected final GuiQuestBook gui;
    private final QuestTask<?> task;
    private List<FormattedText> cachedDescription;

    protected TaskGraphic(UUID playerId, GuiQuestBook gui, QuestTask<?> task) {
        this.playerId = playerId;
        this.gui = gui;
        this.task = task;
        this.taskDescriptionScroll = new ExtendedScrollBar(gui, ScrollBar.Size.SMALL, 312, 18, 180, 7, this::getCachedDescription);
        this.addScrollBar(this.taskDescriptionScroll);
    }

    protected void addSubmitButton(final QuestTask<?> task) {
        this.addClickable(new LargeButton(this.gui, "hqm.quest.manualSubmit", 185, 200){

            @Override
            public boolean isVisible() {
                return !task.isCompleted(TaskGraphic.this.playerId);
            }

            @Override
            public void onClick() {
                NetworkManager.sendToServer(ClientChange.UPDATE_TASK.build(task));
            }
        });
    }

    protected void addDetectButton(final QuestTask<?> task) {
        this.addClickable(new LargeButton(this.gui, "hqm.quest.manualDetect", 185, 200){

            @Override
            public boolean isVisible() {
                return !task.isCompleted(TaskGraphic.this.playerId);
            }

            @Override
            public void onClick() {
                NetworkManager.sendToServer(ClientChange.UPDATE_TASK.build(task));
            }
        });
    }

    @Override
    public void draw(GuiGraphics graphics, int mX, int mY) {
        super.draw(graphics, mX, mY);
        this.gui.drawString(graphics, this.taskDescriptionScroll.getVisibleEntries(), 180, 20, 0.7f, 0x404040);
    }

    @Override
    public void onClick(int mX, int mY, int b) {
        super.onClick(mX, mY, b);
        if (this.gui.getCurrentMode() == EditMode.RENAME && this.gui.inBounds(180, 20, 130, 44, mX, mY)) {
            WrappedTextMenu.display(this.gui, this.task.getRawDescription(), false, this::setDescription);
        }
    }

    private List<FormattedText> getCachedDescription() {
        if (this.cachedDescription == null) {
            this.cachedDescription = this.gui.getLinesFromText((FormattedText)this.task.getDescription(), 0.7f, 130);
        }
        return this.cachedDescription;
    }

    private void setDescription(WrappedText description) {
        this.task.setDescription(description);
        this.cachedDescription = null;
    }
}

