/*
 * Decompiled with CFR 0.152.
 */
package hardcorequesting.common.forge.client.interfaces.widget;

import hardcorequesting.common.forge.client.interfaces.GuiBase;
import hardcorequesting.common.forge.client.interfaces.widget.Clickable;
import hardcorequesting.common.forge.client.interfaces.widget.Drawable;
import java.util.List;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.FormattedText;

public abstract class AbstractCheckBox
implements Drawable,
Clickable {
    private static final int CHECK_BOX_SRC_X = 192;
    private static final int CHECK_BOX_SRC_Y = 102;
    private static final int CHECK_BOX_SIZE = 7;
    private final int x;
    private final int y;
    private final GuiBase gui;
    private final List<FormattedText> cached;

    protected AbstractCheckBox(GuiBase gui, FormattedText label, int x, int y) {
        this(gui, label, x, y, Integer.MAX_VALUE);
    }

    protected AbstractCheckBox(GuiBase gui, FormattedText label, int x, int y, int width) {
        this.x = x;
        this.y = y;
        this.gui = gui;
        this.cached = gui.getLinesFromText(label, 0.7f, width);
    }

    @Override
    public void render(GuiGraphics graphics, int mX, int mY) {
        if (!this.isVisible()) {
            return;
        }
        boolean selected = this.getValue();
        boolean hover = this.gui.inBounds(this.x, this.y, 7, 7, mX, mY);
        this.gui.applyColor(-1);
        this.gui.drawRect(graphics, GuiBase.MAP_TEXTURE, this.x, this.y, 192 + (selected ? 7 : 0), 102 + (hover ? 7 : 0), 7, 7);
        this.gui.drawString(graphics, this.cached, this.x + 12, this.y + 2, 0.7f, 0x404040);
    }

    @Override
    public boolean onClick(int mX, int mY) {
        if (this.isVisible() && this.gui.inBounds(this.x, this.y, 7, 7, mX, mY)) {
            this.setValue(!this.getValue());
            return true;
        }
        return false;
    }

    protected boolean isVisible() {
        return true;
    }

    public abstract boolean getValue();

    public abstract void setValue(boolean var1);
}

