/*
 * Decompiled with CFR 0.152.
 */
package hardcorequesting.common.forge.client.interfaces.widget;

import com.mojang.blaze3d.systems.RenderSystem;
import hardcorequesting.common.forge.client.interfaces.GuiBase;
import hardcorequesting.common.forge.client.interfaces.widget.Clickable;
import hardcorequesting.common.forge.client.interfaces.widget.Drawable;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.FormattedText;

public abstract class ArrowSelectionHelper
implements Drawable,
Clickable {
    private static final int ARROW_SRC_X = 244;
    private static final int ARROW_SRC_Y = 176;
    private static final int ARROW_W = 6;
    private static final int ARROW_H = 10;
    private final int ARROW_X_LEFT;
    private final int ARROW_Y;
    private final int ARROW_DESCRIPTION_Y;
    private final int ARROW_X_RIGHT;
    private final GuiBase gui;
    private boolean clicked;

    public ArrowSelectionHelper(GuiBase gui, int arrowX, int arrowY) {
        this.gui = gui;
        this.ARROW_X_LEFT = arrowX;
        this.ARROW_Y = arrowY;
        this.ARROW_DESCRIPTION_Y = this.ARROW_Y + 20;
        this.ARROW_X_RIGHT = this.ARROW_X_LEFT + 130;
    }

    @Override
    public void render(GuiGraphics graphics, int mX, int mY) {
        if (this.isArrowVisible()) {
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            this.drawArrow(graphics, this.gui, mX, mY, true);
            this.drawArrow(graphics, this.gui, mX, mY, false);
            this.gui.drawCenteredString(graphics, this.getArrowText(), this.ARROW_X_LEFT + 6, this.ARROW_Y, 0.7f, this.ARROW_X_RIGHT - (this.ARROW_X_LEFT + 6), 10, 0x404040);
            FormattedText description = this.getArrowDescription();
            if (description != null) {
                this.gui.drawString(graphics, this.gui.getLinesFromText(description, 0.7f, this.ARROW_X_RIGHT - this.ARROW_X_LEFT + 6), this.ARROW_X_LEFT, this.ARROW_DESCRIPTION_Y, 0.7f, 0x404040);
            }
        }
    }

    @Override
    public boolean onClick(int mX, int mY) {
        if (this.isArrowVisible()) {
            if (this.inArrowBounds(this.gui, mX, mY, true)) {
                this.onArrowClick(true);
                this.clicked = true;
                return true;
            }
            if (this.inArrowBounds(this.gui, mX, mY, false)) {
                this.onArrowClick(false);
                this.clicked = true;
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean onRelease(int mX, int mY) {
        if (this.clicked) {
            this.clicked = false;
            return true;
        }
        return false;
    }

    protected boolean isArrowVisible() {
        return true;
    }

    private void drawArrow(GuiGraphics graphics, GuiBase gui, int mX, int mY, boolean left) {
        int srcX = 244 + (left ? 0 : 6);
        int srcY = 176 + (this.inArrowBounds(gui, mX, mY, left) ? (this.clicked ? 1 : 2) : 0) * 10;
        gui.drawRect(graphics, GuiBase.MAP_TEXTURE, left ? this.ARROW_X_LEFT : this.ARROW_X_RIGHT, this.ARROW_Y, srcX, srcY, 6, 10);
    }

    private boolean inArrowBounds(GuiBase gui, int mX, int mY, boolean left) {
        return gui.inBounds(left ? this.ARROW_X_LEFT : this.ARROW_X_RIGHT, this.ARROW_Y, 6, 10, mX, mY);
    }

    protected abstract void onArrowClick(boolean var1);

    protected abstract FormattedText getArrowText();

    protected FormattedText getArrowDescription() {
        return null;
    }
}

