/*
 * Decompiled with CFR 0.152.
 */
package hardcorequesting.common.forge.client.interfaces.widget;

import com.mojang.blaze3d.systems.RenderSystem;
import hardcorequesting.common.forge.client.interfaces.GuiBase;
import hardcorequesting.common.forge.client.interfaces.widget.Clickable;
import hardcorequesting.common.forge.client.interfaces.widget.Drawable;
import hardcorequesting.common.forge.util.Translator;
import java.util.List;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.FormattedText;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.Nullable;

public abstract class LargeButton
implements Drawable,
Clickable {
    private static final int BUTTON_SRC_X = 54;
    private static final int BUTTON_SRC_Y = 235;
    private static final int BUTTON_WIDTH = 57;
    private static final int BUTTON_HEIGHT = 18;
    private String name;
    private String description;
    private int x;
    private int y;
    private final GuiBase gui;

    public LargeButton(GuiBase gui, String name, int x, int y) {
        this.name = name;
        this.x = x;
        this.y = y;
        this.gui = gui;
    }

    public LargeButton(GuiBase gui, String name, String description, int x, int y) {
        this(gui, name, x, y);
        this.description = description;
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean inButtonBounds(int mX, int mY) {
        return this.gui.inBounds(this.x, this.y, 57, 18, mX, mY);
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean isEnabled() {
        return true;
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean isVisible() {
        return true;
    }

    @OnlyIn(value=Dist.CLIENT)
    public abstract void onClick();

    @Override
    public boolean onClick(int mX, int mY) {
        if (this.isVisible() && this.isEnabled() && this.inButtonBounds(mX, mY)) {
            this.onClick();
            return true;
        }
        return false;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void render(GuiGraphics graphics, int mX, int mY) {
        if (this.isVisible()) {
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            boolean enabled = this.isEnabled();
            this.gui.drawRect(graphics, GuiBase.MAP_TEXTURE, this.x, this.y, 54 + (enabled && this.inButtonBounds(mX, mY) ? 57 : 0), 235, 57, 18);
            this.gui.drawCenteredString(graphics, this.getName(), this.x, this.y, 0.7f, 57, 18, enabled ? 0x404040 : 0xA0A070);
        }
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void renderTooltip(GuiGraphics graphics, int mX, int mY) {
        FormattedText description;
        if (this.isVisible() && this.inButtonBounds(mX, mY) && (description = this.getDescription()) != null) {
            List<FormattedText> lines = this.gui.getLinesFromText(this.getDescription(), 1.0f, 200);
            this.gui.renderTooltipL(graphics, lines, mX + this.gui.getLeft(), mY + this.gui.getTop());
        }
    }

    protected FormattedText getName() {
        return Translator.translatable(this.name, new Object[0]);
    }

    @Nullable
    protected FormattedText getDescription() {
        return this.description != null ? Translator.translatable(this.description, new Object[0]) : null;
    }
}

