/*
 * Decompiled with CFR 0.152.
 */
package hardcorequesting.common.forge.client.interfaces.widget;

import hardcorequesting.common.forge.client.interfaces.GuiBase;
import hardcorequesting.common.forge.client.interfaces.widget.Clickable;
import hardcorequesting.common.forge.client.interfaces.widget.Drawable;
import java.util.ArrayList;
import java.util.List;
import java.util.OptionalInt;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.font.TextFieldHelper;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.Rect2i;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.Style;
import net.minecraft.util.Mth;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class MultilineTextBox
implements Drawable,
Clickable {
    public static final int DEFAULT_TEXT_COLOR = 0x404040;
    private static final int LINES_PER_PAGE = 21;
    private final GuiBase gui;
    private final int x;
    private final int y;
    private final boolean acceptNewlines;
    private final int width;
    private final TextFieldHelper helper;
    private String text;
    private final List<Line> lines = new ArrayList<Line>();
    private boolean dragging;
    private int textColor = 0x404040;
    @Nullable
    private Consumer<String> textListener = null;

    public MultilineTextBox(GuiBase gui, int x, int y, @NotNull String text, int width, boolean acceptNewlines) {
        this.gui = gui;
        this.x = x;
        this.y = y;
        this.acceptNewlines = acceptNewlines;
        this.width = width;
        this.text = this.stripForbidden(text);
        this.helper = new TextFieldHelper(this::getText, this::setText, this::getClipboard, TextFieldHelper.m_95182_((Minecraft)Minecraft.m_91087_()), s -> true);
        this.initLines();
    }

    public String getText() {
        return this.text;
    }

    private void setText(String text) {
        this.text = text;
        this.initLines();
        if (this.textListener != null) {
            this.textListener.accept(text);
        }
    }

    private String getClipboard() {
        return this.stripForbidden(TextFieldHelper.m_95169_((Minecraft)Minecraft.m_91087_()));
    }

    private String stripForbidden(String text) {
        return this.acceptNewlines ? text : text.replace("\n", "");
    }

    @Override
    public void render(GuiGraphics graphics, int mX, int mY) {
        int cursor = this.helper.m_95194_();
        int selection = this.helper.m_95197_();
        int cursorLine = this.getLineFor(cursor);
        int pageStartLine = cursorLine - cursorLine % 21;
        this.gui.drawString(graphics, this.lines.stream().skip(pageStartLine).limit(21L).map(Line::text).map(FormattedText::m_130775_).collect(Collectors.toList()), this.x, this.y, 1.0f, this.textColor);
        this.gui.drawCursor(graphics, this.x + this.getTextX(cursorLine, cursor) - 1, this.y + this.getTextY(cursorLine, pageStartLine) - 3, 10, 1.0f, -7303024);
        if (cursor != selection) {
            int selectStart = Math.min(cursor, selection);
            int selectEnd = Math.max(cursor, selection);
            this.gui.drawSelection(graphics, this.calculateSelectionBoxes(selectStart, selectEnd, pageStartLine));
        }
    }

    @Override
    public boolean onClick(int mX, int mY) {
        OptionalInt cursor = this.getPosAtMouse(mX, mY);
        if (cursor.isPresent()) {
            this.setCursor(cursor.getAsInt());
            this.dragging = true;
            return true;
        }
        return false;
    }

    @Override
    public boolean onDrag(int mX, int mY) {
        OptionalInt cursor;
        if (this.dragging && (cursor = this.getPosAtMouse(mX, mY)).isPresent()) {
            this.helper.m_95179_(cursor.getAsInt(), true);
            return true;
        }
        return false;
    }

    @Override
    public boolean onRelease(int mX, int mY) {
        if (this.dragging) {
            this.dragging = false;
            return true;
        }
        return false;
    }

    private OptionalInt getPosAtMouse(int mX, int mY) {
        if (this.x <= mX && mX < this.x + this.width && this.y <= mY && mY < this.y + 189) {
            int lineId = (mY - this.y) / 9;
            Line line = this.lines.get(Mth.m_14045_((int)lineId, (int)0, (int)(this.lines.size() - 1)));
            if (lineId >= this.lines.size()) {
                return OptionalInt.of(line.end());
            }
            int clickedIndex = this.gui.getFont().m_92865_().m_168626_(line.text(), mX - this.x, Style.f_131099_);
            return OptionalInt.of(line.start() + clickedIndex);
        }
        return OptionalInt.empty();
    }

    @NotNull
    private List<Rect2i> calculateSelectionBoxes(int selectStart, int selectEnd, int pageStartLine) {
        ArrayList<Rect2i> selections = new ArrayList<Rect2i>();
        int startLine = this.getLineFor(selectStart);
        int endLine = this.getLineFor(selectEnd);
        for (int lineId = startLine; lineId <= endLine; ++lineId) {
            if (!this.isLineVisible(lineId, pageStartLine)) continue;
            Line line = this.lines.get(lineId);
            int lineStart = lineId == startLine ? selectStart : line.start();
            int lineEnd = lineId == endLine ? selectEnd : line.end();
            selections.add(new Rect2i(this.x + this.getTextX(lineId, lineStart), this.y + this.getTextY(lineId, pageStartLine) - 1, this.gui.getStringWidth(this.getText().substring(lineStart, lineEnd)), 9));
        }
        return selections;
    }

    private boolean isLineVisible(int line, int pageStartLine) {
        return pageStartLine <= line && line < pageStartLine + 21;
    }

    private int getTextX(int line, int cursor) {
        return this.gui.getStringWidth(this.getText().substring(this.lines.get(line).start(), cursor));
    }

    private int getTextY(int line, int pageStartLine) {
        return (line - pageStartLine) * 9;
    }

    public boolean onKeyStroke(int k) {
        if (k == 265) {
            this.changeLine(-1);
            return true;
        }
        if (k == 264) {
            this.changeLine(1);
            return true;
        }
        if (k == 268) {
            this.setHome();
            return true;
        }
        if (k == 269) {
            this.setEnd();
            return true;
        }
        if (this.acceptNewlines && (k == 335 || k == 257)) {
            this.helper.m_95158_("\n");
            return true;
        }
        return this.helper.m_95145_(k);
    }

    public boolean onCharTyped(char c) {
        return this.helper.m_95143_(c);
    }

    public void setTextAndCursor(String text) {
        this.setText(text);
        this.helper.m_95193_();
    }

    public void setTextColor(int textColor) {
        this.textColor = textColor;
    }

    public void setListener(Consumer<String> listener) {
        this.textListener = listener;
    }

    private void changeLine(int direction) {
        int cursor = this.helper.m_95194_();
        int line = this.getLineFor(cursor);
        int newLineId = line + direction;
        if (0 <= newLineId && newLineId < this.lines.size()) {
            int offset = cursor - this.lines.get(line).start();
            Line newLine = this.lines.get(newLineId);
            int newOffset = Math.min(offset, newLine.text().length());
            this.setCursor(newLine.start() + newOffset);
        }
    }

    private void setHome() {
        Line line = this.lines.get(this.getLineFor(this.helper.m_95194_()));
        this.setCursor(line.start());
    }

    private void setEnd() {
        Line line = this.lines.get(this.getLineFor(this.helper.m_95194_()));
        this.setCursor(line.start() + line.text().length());
    }

    private void setCursor(int cursor) {
        this.helper.m_95179_(cursor, Screen.m_96638_());
    }

    private void initLines() {
        this.lines.clear();
        String text = this.getText();
        this.gui.getFont().m_92865_().m_92364_(text, this.width, Style.f_131099_, true, (style, start, end) -> {
            String lineText = StringUtils.stripEnd((String)text.substring(start, end), (String)" \n");
            this.lines.add(new Line(lineText, start, end));
        });
        if (text.isEmpty() || text.charAt(text.length() - 1) == '\n') {
            this.lines.add(new Line("", text.length(), text.length()));
        }
    }

    private int getLineFor(int cursor) {
        for (int i = 0; i < this.lines.size(); ++i) {
            if (cursor >= this.lines.get((int)i).start) continue;
            return i - 1;
        }
        return this.lines.size() - 1;
    }

    private record Line(String text, int start, int end) {
    }
}

