/*
 * Decompiled with CFR 0.152.
 */
package hardcorequesting.common.forge.client.interfaces.widget;

import hardcorequesting.common.forge.client.interfaces.GuiBase;
import hardcorequesting.common.forge.client.interfaces.widget.TextBox;
import java.util.function.IntConsumer;
import java.util.function.IntSupplier;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.FormattedText;

public class NumberTextBox
extends TextBox {
    public static final int TEXT_OFFSET = -10;
    private final FormattedText title;
    private final IntSupplier getter;
    private final IntConsumer setter;
    private final boolean allowNegative;

    public NumberTextBox(GuiBase gui, int x, int y, FormattedText title, IntSupplier getter, IntConsumer setter) {
        this(gui, x, y, title, false, getter, setter);
    }

    public NumberTextBox(GuiBase gui, int x, int y, FormattedText title, boolean allowNegative, IntSupplier getter, IntConsumer setter) {
        this(gui, x, y, title, allowNegative, 32, getter, setter);
    }

    public NumberTextBox(GuiBase gui, int x, int y, FormattedText title, boolean allowNegative, int charLimit, IntSupplier getter, IntConsumer setter) {
        super(gui, "", x, y, false, charLimit);
        this.title = title;
        this.getter = getter;
        this.setter = setter;
        this.allowNegative = allowNegative;
        this.reloadText();
    }

    @Override
    protected String getStrippedClipboard() {
        return super.getStrippedClipboard().replaceAll(this.allowNegative ? "[^0-9-]" : "[^0-9]", "");
    }

    @Override
    public boolean onCharTyped(char c) {
        if (Character.isDigit(c) || this.allowNegative && c == '-') {
            return super.onCharTyped(c);
        }
        return false;
    }

    @Override
    protected void draw(GuiGraphics graphics, boolean selected, int mX, int mY) {
        super.draw(graphics, selected, mX, mY);
        this.gui.drawString(graphics, this.title, this.x, this.y + -10, 0x404040);
    }

    @Override
    public void textChanged() {
        super.textChanged();
        try {
            int number = this.getText().isEmpty() ? 1 : Integer.parseInt(this.getText());
            this.setter.accept(number);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void reloadText() {
        this.setTextAndCursor(this.isVisible() ? String.valueOf(this.getter.getAsInt()) : "0");
    }
}

