/*
 * Decompiled with CFR 0.152.
 */
package hardcorequesting.common.forge.client.interfaces.widget;

import hardcorequesting.common.forge.client.interfaces.GuiBase;
import hardcorequesting.common.forge.client.interfaces.widget.Clickable;
import hardcorequesting.common.forge.client.interfaces.widget.Drawable;
import java.util.List;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class ScrollBar
implements Drawable,
Clickable {
    private static final int SCROLL_WIDTH = 7;
    private static final int SCROLL_BAR_WIDTH = 5;
    private static final int SCROLL_BAR_HEIGHT = 6;
    private static final int SCROLL_BAR_SRC_X = 250;
    private static final int SCROLL_BAR_SRC_Y = 167;
    private final int x;
    private final int y;
    private final int left;
    private final Size size;
    private double scroll;
    private boolean isScrolling;
    private final GuiBase gui;

    public ScrollBar(GuiBase gui, Size size, int x, int y, int left) {
        this.gui = gui;
        this.x = x;
        this.y = y;
        this.size = size;
        this.left = left;
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean isVisible() {
        return true;
    }

    @OnlyIn(value=Dist.CLIENT)
    protected void onUpdate() {
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void render(GuiGraphics graphics, int mX, int mY) {
        if (this.isVisible()) {
            this.gui.drawRect(graphics, GuiBase.MAP_TEXTURE, this.x, this.y, this.size.u, this.size.v, 7, this.size.length);
            this.gui.drawRect(graphics, GuiBase.MAP_TEXTURE, this.x + 1, (int)((double)(this.y + 1) + this.scroll), 250, 167, 5, 6);
        }
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public boolean onClick(int mX, int mY) {
        if (this.isVisible() && this.gui.inBounds(this.x, this.y, 7, this.size.length, mX, mY)) {
            this.isScrolling = true;
            this.updateScroll(mY);
            return true;
        }
        return false;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public boolean onDrag(int mX, int mY) {
        if (this.isVisible() && this.isScrolling) {
            this.updateScroll(mY);
            return true;
        }
        return false;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public boolean onRelease(int mX, int mY) {
        if (this.isVisible() && this.isScrolling) {
            this.updateScroll(mY);
            this.isScrolling = false;
            return true;
        }
        return false;
    }

    @OnlyIn(value=Dist.CLIENT)
    private void updateScroll(int mY) {
        this.setScroll(mY - this.y - 3);
    }

    public float getScroll() {
        return (float)this.scroll / (float)(this.size.length - 6 - 2);
    }

    public <T> List<T> getVisibleEntries(List<T> list, int visibleEntries) {
        return this.getVisibleEntries(list, 1, visibleEntries);
    }

    public <T> List<T> getVisibleEntries(List<T> list, int columns, int visibleRows) {
        int rows = (int)Math.ceil((double)list.size() / (double)columns);
        int hiddenRows = rows - visibleRows;
        int start = columns * Math.max(0, Math.round((float)hiddenRows * this.getScroll()));
        int end = Math.min(list.size(), start + columns * visibleRows);
        return list.subList(start, end);
    }

    @OnlyIn(value=Dist.CLIENT)
    private void setScroll(double newScroll) {
        double old = this.scroll;
        this.scroll = newScroll;
        if (this.scroll < 0.0) {
            this.scroll = 0.0;
        } else if (this.scroll > (double)(this.size.length - 6 - 2)) {
            this.scroll = this.size.length - 6 - 2;
        }
        if (this.scroll != old) {
            this.onUpdate();
        }
    }

    public void resetScroll() {
        this.scroll = 0.0;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void onScroll(double mX, double mY, double scroll) {
        if (this.isVisible() && this.gui.inBounds(this.left, this.y, this.x + 7 - this.left, this.size.length, mX, mY)) {
            this.setScroll(this.scroll - scroll);
        }
    }

    public static enum Size {
        TINY(242, 102, 29),
        SMALL(249, 102, 64),
        NORMAL(164, 69, 87),
        LONG(171, 69, 186);

        private final int u;
        private final int v;
        private final int length;

        private Size(int u, int v, int length) {
            this.u = u;
            this.v = v;
            this.length = length;
        }
    }
}

