/*
 * Decompiled with CFR 0.152.
 */
package hardcorequesting.common.forge.client.interfaces.widget;

import com.mojang.blaze3d.systems.RenderSystem;
import hardcorequesting.common.forge.client.interfaces.GuiBase;
import hardcorequesting.common.forge.client.interfaces.GuiQuestBook;
import hardcorequesting.common.forge.client.interfaces.ResourceHelper;
import java.util.Collections;
import java.util.Objects;
import net.minecraft.SharedConstants;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.font.TextFieldHelper;
import net.minecraft.client.renderer.Rect2i;
import net.minecraft.network.chat.Style;
import org.jetbrains.annotations.NotNull;

public class TextBox {
    private static final int TEXT_BOX_WIDTH = 64;
    private static final int TEXT_BOX_HEIGHT = 12;
    private static final int TEXT_BOX_SRC_X = 192;
    private static final int TEXT_BOX_SRC_Y = 77;
    private static final int WIDTH = 60;
    protected final GuiBase gui;
    protected final int x;
    protected final int y;
    private final int maxLength;
    private final boolean scrollable;
    private final int offsetY;
    private final float scale;
    private final TextFieldHelper helper;
    private String text;
    private int lastCursor = -1;
    private int visibleStart;
    private String visibleText;

    public TextBox(GuiBase gui, String str, int x, int y, boolean scrollable) {
        this(gui, str, x, y, scrollable, Integer.MAX_VALUE);
    }

    public TextBox(GuiBase gui, String str, int x, int y, boolean scrollable, int charLimit) {
        this(gui, str, x, y, scrollable, charLimit, 1.0f);
    }

    public TextBox(GuiBase gui, String str, int x, int y, boolean scrollable, int charLimit, float scale) {
        this.gui = gui;
        this.x = x;
        this.y = y;
        this.maxLength = charLimit;
        this.scrollable = scrollable;
        this.scale = scale;
        this.offsetY = (int)(12.0f - scale * 9.0f);
        this.text = SharedConstants.m_136190_((String)Objects.requireNonNullElse(str, ""));
        this.helper = new TextFieldHelper(this::getText, this::setText, this::getStrippedClipboard, TextFieldHelper.m_95182_((Minecraft)Minecraft.m_91087_()), this::isTextValid);
        this.updateVisible();
    }

    public String getText() {
        return this.text;
    }

    private void setText(String text) {
        this.text = text;
        this.textChanged();
    }

    protected boolean isTextValid(String newText) {
        return newText.length() <= this.maxLength && (this.scrollable || (float)this.gui.getStringWidth(newText) * this.scale <= 60.0f);
    }

    protected String getStrippedClipboard() {
        return SharedConstants.m_136190_((String)TextFieldHelper.m_95169_((Minecraft)Minecraft.m_91087_()));
    }

    public boolean onKeyStroke(int k) {
        return this.helper.m_95145_(k);
    }

    public boolean onCharTyped(char c) {
        return this.helper.m_95143_(c);
    }

    protected void draw(GuiGraphics graphics, boolean selected, int mX, int mY) {
        this.checkCursor();
        ResourceHelper.bindResource(GuiQuestBook.MAP_TEXTURE);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.gui.drawRect(graphics, GuiBase.MAP_TEXTURE, this.x, this.y, 192, 77 + (selected || this.inBounds(mX, mY) ? 12 : 0), 64, 12);
        this.gui.drawString(graphics, this.visibleText, this.x + 3, this.y + this.offsetY, this.scale, 0x404040);
        if (selected) {
            int cursor = this.helper.m_95194_();
            int selection = this.helper.m_95197_();
            int cursorPositionX = (int)(this.scale * (float)this.gui.getStringWidth(this.visibleText.substring(0, Math.min(this.visibleText.length(), cursor - this.visibleStart))));
            this.gui.drawCursor(graphics, this.x + cursorPositionX + 2, this.y, 10, 1.0f, -7303024);
            if (cursor != selection) {
                int selectStart = Math.min(cursor, selection);
                int selectEnd = Math.max(cursor, selection);
                this.gui.drawSelection(graphics, Collections.singleton(this.getSelectionBox(selectStart, selectEnd)));
            }
        }
    }

    @NotNull
    private Rect2i getSelectionBox(int selectStart, int selectEnd) {
        selectStart = Math.max(this.visibleStart, selectStart);
        selectEnd = Math.min(this.visibleStart + this.visibleText.length(), selectEnd);
        return new Rect2i(this.x + 3 + (int)(this.scale * (float)this.gui.getStringWidth(this.getText().substring(this.visibleStart, selectStart))), this.y + this.offsetY - 1, (int)(this.scale * (float)this.gui.getStringWidth(this.getText().substring(selectStart, selectEnd))), (int)(this.scale * 9.0f));
    }

    protected boolean isVisible() {
        return true;
    }

    public void textChanged() {
        this.updateVisible();
    }

    public void checkCursor() {
        int cursor = this.helper.m_95194_();
        if (this.lastCursor != cursor) {
            this.lastCursor = cursor;
            this.updateVisible();
        }
    }

    private void updateVisible() {
        if (this.scrollable) {
            String text;
            int visibleStart = this.visibleStart;
            int cursor = this.helper.m_95194_();
            if (cursor < visibleStart) {
                visibleStart = cursor;
            }
            while (visibleStart < cursor && (float)this.gui.getStringWidth(text = this.getText().substring(visibleStart, cursor)) * this.scale > 60.0f) {
                ++visibleStart;
            }
            while (0 < visibleStart && (float)this.gui.getStringWidth(text = this.getText().substring(visibleStart - 1)) * this.scale <= 60.0f) {
                --visibleStart;
            }
            this.setVisibleStart(visibleStart);
        } else {
            this.setVisibleStart(0);
        }
    }

    private void setVisibleStart(int visibleStart) {
        this.visibleStart = visibleStart;
        this.visibleText = this.gui.getFont().m_92865_().m_168630_(this.getText().substring(visibleStart), (int)(60.0f / this.scale), Style.f_131099_);
    }

    public void reloadText() {
        this.checkCursor();
    }

    public boolean inBounds(double mX, double mY) {
        return this.gui.inBounds(this.x, this.y, 64, 12, mX, mY);
    }

    protected void setTextAndCursor(String s) {
        this.setText(s);
        this.helper.m_95193_();
    }
}

