/*
 * Decompiled with CFR 0.152.
 */
package hardcorequesting.common.forge.client.interfaces.widget;

import hardcorequesting.common.forge.client.interfaces.widget.Clickable;
import hardcorequesting.common.forge.client.interfaces.widget.Drawable;
import hardcorequesting.common.forge.client.interfaces.widget.TextBox;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class TextBoxGroup
implements Drawable,
Clickable {
    private TextBox selectedTextBox;
    private final List<TextBox> textBoxes = new ArrayList<TextBox>();

    public void add(TextBox textBox) {
        this.textBoxes.add(textBox);
    }

    public List<TextBox> getTextBoxes() {
        return this.textBoxes;
    }

    @Override
    public void render(GuiGraphics graphics, int mX, int mY) {
        for (TextBox textBox : this.textBoxes) {
            if (!textBox.isVisible()) continue;
            textBox.draw(graphics, this.selectedTextBox == textBox, mX, mY);
        }
    }

    @Override
    public boolean onClick(int mX, int mY) {
        for (TextBox textBox : this.textBoxes) {
            if (!textBox.isVisible() || !textBox.inBounds(mX, mY)) continue;
            this.selectedTextBox = this.selectedTextBox == textBox ? null : textBox;
            return true;
        }
        return false;
    }

    public boolean onKeyStroke(int k) {
        if (this.selectedTextBox != null && this.selectedTextBox.isVisible()) {
            return this.selectedTextBox.onKeyStroke(k);
        }
        return false;
    }

    public boolean onCharTyped(char c) {
        if (this.selectedTextBox != null && this.selectedTextBox.isVisible()) {
            return this.selectedTextBox.onCharTyped(c);
        }
        return false;
    }
}

