/*
 * Decompiled with CFR 0.152.
 */
package hardcorequesting.common.forge.client.sounds;

import hardcorequesting.common.forge.client.ClientChange;
import hardcorequesting.common.forge.client.sounds.ClientSound;
import hardcorequesting.common.forge.client.sounds.Sounds;
import hardcorequesting.common.forge.network.NetworkManager;
import hardcorequesting.common.forge.quests.QuestingDataManager;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class SoundHandler {
    private static final String LABEL = "lore";
    private static List<String> paths = new ArrayList<String>();
    private static int loreNumber;
    private static boolean loreMusic;
    @OnlyIn(value=Dist.CLIENT)
    private static SoundInstance loreSound;

    private SoundHandler() {
    }

    @OnlyIn(value=Dist.CLIENT)
    public static boolean loadLoreReading(Path path) {
        return false;
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void playLoreMusic() {
        loreSound = SoundHandler.play(LABEL + loreNumber, 4.0f, 1.0f);
    }

    public static void play(Sounds sound, Player player) {
        if (player instanceof ServerPlayer) {
            NetworkManager.sendToPlayer(ClientChange.SOUND.build((Object)sound), (ServerPlayer)player);
        }
    }

    public static void playToAll(Sounds sound) {
        NetworkManager.sendToAllPlayers(ClientChange.SOUND.build((Object)sound));
    }

    @OnlyIn(value=Dist.CLIENT)
    private static SoundInstance play(String sound, float volume, float pitch) {
        return SoundHandler.play(new ResourceLocation("hardcorequesting", sound), volume, pitch);
    }

    @OnlyIn(value=Dist.CLIENT)
    private static SoundInstance play(ResourceLocation resource, float volume, float pitch) {
        ClientSound soundObj = new ClientSound(resource, volume, pitch, Minecraft.m_91087_().f_91073_.m_213780_());
        Minecraft.m_91087_().m_91106_().m_120367_((SoundInstance)soundObj);
        return soundObj;
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void stopLoreMusic() {
        if (SoundHandler.isLorePlaying()) {
            new Thread(() -> {
                while (SoundHandler.isLorePlaying()) {
                    Minecraft.m_91087_().m_91106_().m_120399_(loreSound);
                }
                loreSound = null;
            }).start();
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static boolean isLorePlaying() {
        boolean value;
        boolean bl = value = loreSound != null && Minecraft.m_91087_().m_91106_().m_120403_(loreSound);
        if (!value) {
            loreSound = null;
        }
        return value;
    }

    public static boolean hasLoreMusic() {
        return loreMusic;
    }

    public static void handleSoundPacket(Sounds sound) {
        SoundHandler.play(sound.getSoundId(), 1.0f, 1.0f);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void triggerFirstLore() {
        NetworkManager.sendToServer(ClientChange.LORE.build(null));
        SoundHandler.playLoreMusic();
    }

    public static void handleLorePacket(Player player) {
        QuestingDataManager.getInstance().getQuestingData((Player)player).playedLore = true;
    }

    static {
        loreMusic = false;
    }
}

