/*
 * Decompiled with CFR 0.152.
 */
package hardcorequesting.common.forge.commands.sub;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import hardcorequesting.common.forge.HardcoreQuestingCore;
import hardcorequesting.common.forge.commands.CommandHandler;
import hardcorequesting.common.forge.config.HQMConfig;
import hardcorequesting.common.forge.quests.QuestingDataManager;
import hardcorequesting.common.forge.util.Translator;
import net.minecraft.commands.CommandRuntimeException;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;

public class LivesSubCommand
implements CommandHandler.SubCommand {
    @Override
    public ArgumentBuilder<CommandSourceStack, ?> build(LiteralArgumentBuilder<CommandSourceStack> builder) {
        return ((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)builder.requires(source -> source.m_6761_(4))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"add").then(((RequiredArgumentBuilder)Commands.m_82129_((String)"targets", (ArgumentType)EntityArgument.m_91470_()).then(Commands.m_82129_((String)"amount", (ArgumentType)IntegerArgumentType.integer((int)1)).executes(context -> {
            if (!QuestingDataManager.getInstance().isHardcoreActive()) {
                ((CommandSourceStack)context.getSource()).m_81352_((Component)Component.m_237115_((String)"hqm.message.noHardcoreYet"));
                return 1;
            }
            for (ServerPlayer player : EntityArgument.m_91477_((CommandContext)context, (String)"targets")) {
                this.addLivesTo((CommandSourceStack)context.getSource(), (Player)player, IntegerArgumentType.getInteger((CommandContext)context, (String)"amount"));
            }
            return 1;
        }))).executes(context -> {
            if (!QuestingDataManager.getInstance().isHardcoreActive()) {
                ((CommandSourceStack)context.getSource()).m_81352_((Component)Component.m_237115_((String)"hqm.message.noHardcoreYet"));
                return 1;
            }
            for (ServerPlayer player : EntityArgument.m_91477_((CommandContext)context, (String)"targets")) {
                this.addLivesTo((CommandSourceStack)context.getSource(), (Player)player, 1);
            }
            return 1;
        }))).executes(context -> {
            if (!QuestingDataManager.getInstance().isHardcoreActive()) {
                ((CommandSourceStack)context.getSource()).m_81352_((Component)Component.m_237115_((String)"hqm.message.noHardcoreYet"));
                return 1;
            }
            if (((CommandSourceStack)context.getSource()).m_81373_() instanceof Player) {
                this.addLivesTo((CommandSourceStack)context.getSource(), (Player)((CommandSourceStack)context.getSource()).m_81373_(), 1);
            }
            return 1;
        }))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"remove").then(((RequiredArgumentBuilder)Commands.m_82129_((String)"targets", (ArgumentType)EntityArgument.m_91470_()).then(Commands.m_82129_((String)"amount", (ArgumentType)IntegerArgumentType.integer((int)1)).executes(context -> {
            if (!QuestingDataManager.getInstance().isHardcoreActive()) {
                ((CommandSourceStack)context.getSource()).m_81352_((Component)Component.m_237115_((String)"hqm.message.noHardcoreYet"));
                return 1;
            }
            for (ServerPlayer player : EntityArgument.m_91477_((CommandContext)context, (String)"targets")) {
                this.removeLivesFrom((CommandSourceStack)context.getSource(), (Player)player, IntegerArgumentType.getInteger((CommandContext)context, (String)"amount"));
            }
            return 1;
        }))).executes(context -> {
            if (!QuestingDataManager.getInstance().isHardcoreActive()) {
                ((CommandSourceStack)context.getSource()).m_81352_((Component)Component.m_237115_((String)"hqm.message.noHardcoreYet"));
                return 1;
            }
            for (ServerPlayer player : EntityArgument.m_91477_((CommandContext)context, (String)"targets")) {
                this.removeLivesFrom((CommandSourceStack)context.getSource(), (Player)player, 1);
            }
            return 1;
        }))).executes(context -> {
            if (!QuestingDataManager.getInstance().isHardcoreActive()) {
                ((CommandSourceStack)context.getSource()).m_81352_((Component)Component.m_237115_((String)"hqm.message.noHardcoreYet"));
                return 1;
            }
            if (((CommandSourceStack)context.getSource()).m_81373_() instanceof Player) {
                this.removeLivesFrom((CommandSourceStack)context.getSource(), (Player)((CommandSourceStack)context.getSource()).m_81373_(), 1);
            }
            return 1;
        }))).then(Commands.m_82129_((String)"targets", (ArgumentType)EntityArgument.m_91470_()).executes(context -> {
            if (!QuestingDataManager.getInstance().isHardcoreActive()) {
                ((CommandSourceStack)context.getSource()).m_81352_((Component)Component.m_237115_((String)"hqm.message.noHardcoreYet"));
                return 1;
            }
            this.currentLives((CommandSourceStack)context.getSource(), (Player)EntityArgument.m_91474_((CommandContext)context, (String)"targets"));
            return 1;
        }))).executes(context -> {
            if (!QuestingDataManager.getInstance().isHardcoreActive()) {
                ((CommandSourceStack)context.getSource()).m_81352_((Component)Component.m_237115_((String)"hqm.message.noHardcoreYet"));
                return 1;
            }
            if (((CommandSourceStack)context.getSource()).m_81373_() instanceof Player) {
                this.currentLives((Player)((CommandSourceStack)context.getSource()).m_81373_());
            }
            return 1;
        });
    }

    @Override
    public int[] getSyntaxOptions(CommandContext<CommandSourceStack> context) {
        return new int[]{0, 1, 2, 3};
    }

    private void removeLivesFrom(CommandSourceStack source, Player player, int amount) {
        QuestingDataManager.getInstance().getQuestingData(player).removeLives(player, amount);
        this.sendChat(source, (Component)Translator.translatable("hqm.message.removeLivesFrom", Translator.lives(amount), player.m_6302_()));
        if (source.m_81373_() != player) {
            this.sendChat(player.m_20203_(), (Component)Translator.translatable("hqm.message.removeLivesBy", Translator.lives(amount), source.m_81368_()));
        }
        this.currentLives(player);
    }

    private void addLivesTo(CommandSourceStack source, Player player, int amount) {
        QuestingDataManager questingDataManager = QuestingDataManager.getInstance();
        if (questingDataManager.getQuestingData(player).getRawLives() + amount <= HQMConfig.getInstance().Hardcore.MAX_LIVES) {
            questingDataManager.getQuestingData(player).addLives(player, amount);
            this.sendChat(source, (Component)Translator.translatable("hqm.message.addLivesTo", Translator.lives(amount), player.m_6302_()));
            if (source.m_81373_() != player) {
                this.sendChat(player.m_20203_(), (Component)Translator.translatable("hqm.message.addLivesBy", Translator.lives(amount), source.m_81368_()));
            }
        } else {
            questingDataManager.getQuestingData(player).addLives(player, amount);
            this.sendChat(source, (Component)Translator.translatable("hqm.message.cantGiveMoreLives", player.m_6302_(), HQMConfig.getInstance().Hardcore.MAX_LIVES));
            this.sendChat(source, (Component)Translator.translatable("hqm.massage.setLivesInstead", player.m_6302_(), HQMConfig.getInstance().Hardcore.MAX_LIVES));
            if (source.m_81373_() != player) {
                this.sendChat(player.m_20203_(), (Component)Translator.translatable("hqm.massage.setLivesBy", HQMConfig.getInstance().Hardcore.MAX_LIVES, source.m_81368_()));
            }
        }
        this.currentLives(player);
    }

    private void getPlayerLives(CommandSourceStack source, String playerName) throws CommandRuntimeException {
        ServerPlayer player = HardcoreQuestingCore.getServer().m_6846_().m_11255_(playerName);
        if (player == null) {
            throw new CommandRuntimeException((Component)Component.m_237115_((String)"hqm.message.noPlayer"));
        }
        int lives = QuestingDataManager.getInstance().getQuestingData((Player)player).getLives();
        this.sendChat(source, (Component)Translator.translatable("hqm.message.hasLivesRemaining", playerName, Translator.lives(lives)));
    }
}

