/*
 * Decompiled with CFR 0.152.
 */
package hardcorequesting.common.forge.config;

import hardcorequesting.common.forge.HardcoreQuestingCore;
import hardcorequesting.common.forge.blue.endless.jankson.Comment;
import hardcorequesting.common.forge.blue.endless.jankson.Jankson;
import hardcorequesting.common.forge.blue.endless.jankson.JsonGrammar;
import hardcorequesting.common.forge.blue.endless.jankson.api.SyntaxError;
import hardcorequesting.common.forge.client.KeyboardHandler;
import hardcorequesting.common.forge.io.SaveHandler;
import hardcorequesting.common.forge.items.BagItem;
import hardcorequesting.common.forge.quests.Quest;
import hardcorequesting.common.forge.team.RewardSetting;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Optional;

public class HQMConfig {
    private static transient HQMConfig instance;
    @Comment(value="Settings related to hardcore mode")
    public Hardcore Hardcore = new Hardcore();
    @Comment(value="Settings related to server start & modes")
    public Starting Starting = new Starting();
    @Comment(value="Settings related to loot bags and loot tiers")
    public Loot Loot = new Loot();
    @Comment(value="Settings related to the interface")
    public Interface Interface = new Interface();
    @Comment(value="Enable this to cause the player to be granted a gift on spawning into the world")
    public boolean SPAWN_BOOK = false;
    @Comment(value="Loose the quest book when you die, if set to false it will stay in your inventory")
    public boolean LOSE_QUEST_BOOK = true;
    @Comment(value="Allow every single player in a party to claim the reward for a quest. Setting this to false will give the party one set of rewards to share.")
    public boolean MULTI_REWARD = true;
    @Comment(value="Allow teams, currently extremely buggy!")
    public boolean ENABLE_TEAMS = true;
    @Comment(value="Use this to specify NBT tags that should be ignored when comparing items with NBT subset")
    public String[] NBT_SUBSET_FILTER = new String[]{"RepairCost"};
    @Comment(value="Settings related to messages sent from the server")
    public Message Message = new Message();
    @Comment(value="Settings related to edit mode")
    public Editing Editing = new Editing();
    public static int OVERLAY_XPOS;
    public static int OVERLAY_YPOS;
    public static int OVERLAY_XPOSDEFAULT;
    public static int OVERLAY_YPOSDEFAULT;
    public static int CURRENTLY_MODIFYING_QUEST_SET;
    public static int COMPLETED_SELECTED_IN_BOUNDS_SET;
    public static int COMPLETED_SELECTED_OUT_OF_BOUNDS_SET;
    public static int COMPLETED_UNSELECTED_IN_BOUNDS_SET;
    public static int COMPLETED_UNSELECTED_OUT_OF_BOUNDS_SET;
    public static int UNCOMPLETED_SELECTED_IN_BOUNDS_SET;
    public static int UNCOMPLETED_SELECTED_OUT_OF_BOUNDS_SET;
    public static int UNCOMPLETED_UNSELECTED_IN_BOUNDS_SET;
    public static int UNCOMPLETED_UNSELECTED_OUT_OF_BOUNDS_SET;
    public static int DISABLED_SET;
    public static int QUEST_INVISIBLE;
    public static int QUEST_DISABLED;
    public static int QUEST_COMPLETE;
    public static int QUEST_COMPLETE_REPEATABLE;
    public static int QUEST_AVAILABLE;

    public static HQMConfig getInstance() {
        if (instance == null) {
            try {
                Jankson jankson = Jankson.builder().build();
                Path path = HardcoreQuestingCore.configDir.resolve("config.json5");
                if (!Files.exists(path.getParent(), new LinkOption[0])) {
                    Files.createDirectories(path.getParent(), new FileAttribute[0]);
                }
                instance = SaveHandler.load(path).flatMap(s -> {
                    try {
                        return Optional.of(jankson.fromJson((String)s, HQMConfig.class));
                    }
                    catch (SyntaxError syntaxError) {
                        syntaxError.printStackTrace();
                        return Optional.empty();
                    }
                }).orElse(new HQMConfig());
                SaveHandler.save(path, jankson.toJson(instance).toJson(JsonGrammar.JSON5));
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        return instance;
    }

    public static void parseSetColours() {
        try {
            COMPLETED_SELECTED_IN_BOUNDS_SET = Long.decode(HQMConfig.getInstance().Interface.QuestSets.COMPLETED_SELECTED_IN_BOUNDS_SET.toLowerCase()).intValue();
            COMPLETED_UNSELECTED_IN_BOUNDS_SET = Long.decode(HQMConfig.getInstance().Interface.QuestSets.COMPLETED_UNSELECTED_IN_BOUNDS_SET.toLowerCase()).intValue();
            UNCOMPLETED_SELECTED_IN_BOUNDS_SET = Long.decode(HQMConfig.getInstance().Interface.QuestSets.UNCOMPLETED_SELECTED_IN_BOUNDS_SET.toLowerCase()).intValue();
            UNCOMPLETED_UNSELECTED_IN_BOUNDS_SET = Long.decode(HQMConfig.getInstance().Interface.QuestSets.UNCOMPLETED_UNSELECTED_IN_BOUNDS_SET.toLowerCase()).intValue();
            DISABLED_SET = Long.decode(HQMConfig.getInstance().Interface.QuestSets.DISABLED_SET.toLowerCase()).intValue();
        }
        catch (NumberFormatException e) {
            HardcoreQuestingCore.LOGGER.error("Unable to parse set colours", (Throwable)e);
        }
    }

    public static void parseQuestColours() {
        try {
            QUEST_INVISIBLE = Long.decode(HQMConfig.getInstance().Interface.Quests.QUEST_INVISIBLE.toLowerCase()).intValue();
            QUEST_DISABLED = Long.decode(HQMConfig.getInstance().Interface.Quests.QUEST_DISABLED.toLowerCase()).intValue();
            QUEST_COMPLETE = Long.decode(HQMConfig.getInstance().Interface.Quests.QUEST_COMPLETE.toLowerCase()).intValue();
            QUEST_COMPLETE_REPEATABLE = Long.decode(HQMConfig.getInstance().Interface.Quests.QUEST_COMPLETE_REPEATABLE.toLowerCase()).intValue();
            QUEST_AVAILABLE = Long.decode(HQMConfig.getInstance().Interface.Quests.QUEST_AVAILABLE.toLowerCase()).intValue();
        }
        catch (NumberFormatException e) {
            HardcoreQuestingCore.LOGGER.error("Unable to parse quest colours", (Throwable)e);
        }
    }

    public static void loadConfig() {
        HQMConfig.parseSetColours();
        HQMConfig.parseQuestColours();
        RewardSetting.isAllModeEnabled = HQMConfig.getInstance().MULTI_REWARD;
        BagItem.displayGui = HQMConfig.getInstance().Loot.REWARD_INTERFACE;
        Quest.isEditing = HQMConfig.getInstance().Editing.USE_EDITOR;
        if (HardcoreQuestingCore.proxy.isClient()) {
            KeyboardHandler.clear();
            KeyboardHandler.initDefault();
        }
    }

    static {
        OVERLAY_XPOSDEFAULT = 2;
        OVERLAY_YPOSDEFAULT = 2;
        CURRENTLY_MODIFYING_QUEST_SET = 0x4040DD;
        COMPLETED_SELECTED_IN_BOUNDS_SET = 0x40BB40;
        COMPLETED_SELECTED_OUT_OF_BOUNDS_SET = 0x40A040;
        COMPLETED_UNSELECTED_IN_BOUNDS_SET = 0x10A010;
        COMPLETED_UNSELECTED_OUT_OF_BOUNDS_SET = 0x107010;
        UNCOMPLETED_SELECTED_IN_BOUNDS_SET = 0xAAAAAA;
        UNCOMPLETED_SELECTED_OUT_OF_BOUNDS_SET = 0x888888;
        UNCOMPLETED_UNSELECTED_IN_BOUNDS_SET = 0x666666;
        UNCOMPLETED_UNSELECTED_OUT_OF_BOUNDS_SET = 0x404040;
        DISABLED_SET = 0xDDDDDD;
        QUEST_INVISIBLE = 0x55FFFFFF;
        QUEST_DISABLED = -7829368;
        QUEST_COMPLETE = -1;
        QUEST_COMPLETE_REPEATABLE = -52;
        QUEST_AVAILABLE = 1430423284;
    }

    public static class Hardcore {
        @Comment(value="How many lives players should start with.")
        public int DEFAULT_LIVES = 3;
        @Comment(value="Define in seconds how long the rot timer is.")
        public int HEART_ROT_TIME = 120;
        @Comment(value="Set to true to enable the heart rot timer")
        public boolean HEART_ROT_ENABLE = false;
        @Comment(value="Use this to set the maximum lives obtainable")
        public int MAX_LIVES = 20;
    }

    public static class Starting {
        @Comment(value="If set to true, new worlds will automatically activate Hardcore mode")
        public boolean AUTO_HARDCORE = false;
        @Comment(value="If set to true, new worlds will automatically activate Questing mode")
        public boolean AUTO_QUESTING = true;
    }

    public static class Loot {
        @Comment(value="Always display the tier name, instead of the individual bag's name, when opening a reward bag.")
        public boolean ALWAYS_USE_TIER = false;
        @Comment(value="Set to true to display an interface with the contents of the reward bag when you open it.")
        public boolean REWARD_INTERFACE = true;
    }

    public static class Interface {
        @Comment(value="Colour settings for quest set rendering")
        public QuestSets QuestSets = new QuestSets();
        @Comment(value="Colour settings for quests")
        public Quests Quests = new Quests();

        public static class QuestSets {
            @Comment(value="Use the HTML format, e.g.: #ffffff")
            public String COMPLETED_SELECTED_IN_BOUNDS_SET = "#40bb40";
            @Comment(value="Use the HTML format, e.g.: #ffffff")
            public String COMPLETED_UNSELECTED_IN_BOUNDS_SET = "#10a010";
            @Comment(value="Use the HTML format, e.g.: #ffffff")
            public String UNCOMPLETED_SELECTED_IN_BOUNDS_SET = "#aaaaaa";
            @Comment(value="Use the HTML format, e.g.: #ffffff")
            public String UNCOMPLETED_UNSELECTED_IN_BOUNDS_SET = "#666666";
            @Comment(value="Use the HTML format, e.g.: #ffffff")
            public String DISABLED_SET = "#dddddd";
        }

        public static class Quests {
            public String QUEST_INVISIBLE = "#55FFFFFF";
            @Comment(value="Use the HTML format with alpha, e.g.: #55FFFFFF")
            public String QUEST_DISABLED = "#FF888888";
            @Comment(value="Use the HTML format with alpha, e.g.: #55FFFFFF")
            public String QUEST_COMPLETE = "#FFFFFFFF";
            @Comment(value="Use the HTML format with alpha, e.g.: #55FFFFFF")
            public String QUEST_COMPLETE_REPEATABLE = "#FFFFFFCC";
            @Comment(value="Use the HTML format with alpha, e.g: #55FFFFFF")
            public String QUEST_AVAILABLE = "#554286f4";
            @Comment(value="Set to true to disable the default colour pulse and use the colour specified above")
            public boolean SINGLE_COLOUR = false;
        }
    }

    public static class Message {
        @Comment(value="Set to true to enable sending a status message if Hardcore Questing mode is off")
        public boolean NO_HARDCORE_MESSAGE = false;
        @Comment(value="Set to false to prevent the 'use /hqm op instead' message when operators use '/hqm edit' instead.")
        public boolean OP_REMINDER = true;
    }

    public static class Editing {
        @Comment(value="Set to true to automatically enable edit mode when entering worlds in single-player. Has no effect in multiplayer.")
        public boolean USE_EDITOR = false;
    }
}

