/*
 * Decompiled with CFR 0.152.
 */
package hardcorequesting.common.forge.death;

import com.google.common.collect.ImmutableList;
import hardcorequesting.common.forge.death.DeathStatsManager;
import hardcorequesting.common.forge.death.DeathType;
import hardcorequesting.common.forge.util.Translator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class DeathStat {
    private static final Map<DeathType, Comparator<DeathStat>> deathTypeComparator = new EnumMap<DeathType, Comparator<DeathStat>>(DeathType.class);
    protected final Map<DeathType, Integer> deaths = new EnumMap<DeathType, Integer>(DeathType.class);
    private final UUID uuid;
    private String cachedName;
    int totalDeaths;

    public DeathStat(UUID uuid) {
        for (DeathType type : DeathType.values()) {
            this.deaths.put(type, 0);
        }
        this.totalDeaths = -1;
        this.uuid = uuid;
    }

    public UUID getUuid() {
        return this.uuid;
    }

    @OnlyIn(value=Dist.CLIENT)
    public MutableComponent getName() throws IllegalArgumentException {
        Player player;
        if (Minecraft.m_91087_().f_91073_ != null && (player = Minecraft.m_91087_().f_91073_.m_46003_(this.uuid)) != null) {
            this.cachedName = player.m_6302_();
        }
        return Translator.text(Objects.requireNonNullElse(this.cachedName, "<invalid>"));
    }

    public String getCachedName() {
        return this.cachedName;
    }

    public void setCachedName(String cachedName) {
        this.cachedName = cachedName;
    }

    public List<FormattedText> getDescription(DeathType type) {
        return Collections.singletonList(type.getName().m_130946_(": " + this.deaths.get((Object)type)));
    }

    public void increaseDeath(DeathType type) {
        this.increaseDeath(type, 1, true);
    }

    public void increaseDeath(DeathType type, int count, boolean resync) {
        this.deaths.merge(type, count, Integer::sum);
        this.totalDeaths = -1;
        if (resync) {
            DeathStatsManager.getInstance().resync();
        }
    }

    public int getTotalDeaths() {
        if (this.totalDeaths == -1) {
            this.totalDeaths = 0;
            for (int death : this.deaths.values()) {
                this.totalDeaths += death;
            }
        }
        return this.totalDeaths;
    }

    public int getDeaths(DeathType type) {
        return this.deaths.get((Object)type);
    }

    static {
        for (DeathType type : DeathType.values()) {
            deathTypeComparator.put(type, Comparator.comparingInt(stat -> stat.getDeaths(type)).reversed());
        }
    }

    public static class DeathStatTotal
    extends DeathStat {
        public Map<DeathType, Integer> counts = new EnumMap<DeathType, Integer>(DeathType.class);

        public DeathStatTotal(List<DeathStat> clientDeathList) {
            super(null);
            for (DeathType type : DeathType.values()) {
                int counter = 0;
                for (DeathStat deathStat : clientDeathList) {
                    this.deaths.merge(type, deathStat.getDeaths(type), Integer::sum);
                    if (deathStat.getDeaths(type) <= 0) continue;
                    ++counter;
                }
                this.counts.put(type, counter);
            }
        }

        @Override
        public List<FormattedText> getDescription(DeathType type) {
            ArrayList<FormattedText> description = new ArrayList<FormattedText>(super.getDescription(type));
            description.add(FormattedText.f_130760_);
            int count = this.counts.get((Object)type);
            if (count == 0) {
                description.add((FormattedText)Translator.translatable("hqm.deathStat.noOneDied", new Object[0]).m_130940_(ChatFormatting.DARK_RED));
            } else {
                description.add((FormattedText)Translator.plural("hqm.player", count).m_130946_(" ").m_7220_((Component)Translator.translatable("hqm.deathStat.diedThisWay", new Object[0])).m_130940_(ChatFormatting.DARK_GREEN));
            }
            return description;
        }

        @Override
        public MutableComponent getName() {
            return Translator.translatable("hqm.deathStat.everyone", new Object[0]);
        }
    }

    public static class DeathStatBest
    extends DeathStat {
        private static final ChatFormatting[] colourPrefixes = new ChatFormatting[]{ChatFormatting.YELLOW, ChatFormatting.GRAY, ChatFormatting.GOLD};
        private static final String[] placePrefixes = new String[]{"first", "second", "third"};
        private final Map<DeathType, List<FormattedText>> messages = new EnumMap<DeathType, List<FormattedText>>(DeathType.class);

        public DeathStatBest(List<DeathStat> deathStats) {
            super(null);
            ArrayList<DeathStat> clientDeathList = new ArrayList<DeathStat>(deathStats);
            for (DeathType type : DeathType.values()) {
                clientDeathList.sort(deathTypeComparator.get((Object)type));
                if (clientDeathList.isEmpty()) {
                    this.deaths.put(type, 0);
                    this.messages.put(type, Collections.singletonList(Translator.translatable("hqm.deathStat.noOneDied", new Object[0]).m_130940_(ChatFormatting.DARK_RED)));
                    continue;
                }
                this.deaths.put(type, ((DeathStat)clientDeathList.get(0)).getDeaths(type));
                ImmutableList.Builder builder = ImmutableList.builder();
                int currentValue = 0;
                int standing = 0;
                for (int j = 0; j < clientDeathList.size(); ++j) {
                    int value = ((DeathStat)clientDeathList.get(j)).getDeaths(type);
                    if (value < currentValue) {
                        standing = j;
                        if (value == 0 || standing >= 3) break;
                    }
                    currentValue = value;
                    MutableComponent player = ((DeathStat)clientDeathList.get(j)).getName().m_130946_(": " + ((DeathStat)clientDeathList.get(j)).getDeaths(type)).m_130940_(ChatFormatting.WHITE);
                    builder.add((Object)Translator.translatable("hqm.deathStat." + placePrefixes[standing], new Object[0]).m_130940_(colourPrefixes[standing]).m_130946_(" ").m_7220_((Component)player));
                }
                this.messages.put(type, (List<FormattedText>)builder.build());
            }
        }

        @Override
        public MutableComponent getName() {
            return Translator.translatable("hqm.deathStat.worstPlayers", new Object[0]);
        }

        @Override
        public List<FormattedText> getDescription(DeathType type) {
            ArrayList<FormattedText> description = new ArrayList<FormattedText>();
            description.add((FormattedText)type.getName());
            description.add(FormattedText.f_130760_);
            description.addAll((Collection)this.messages.get((Object)type));
            return description;
        }
    }
}

