/*
 * Decompiled with CFR 0.152.
 */
package hardcorequesting.common.forge.death;

import com.google.common.collect.Lists;
import com.google.gson.reflect.TypeToken;
import hardcorequesting.common.forge.HardcoreQuestingCore;
import hardcorequesting.common.forge.death.DeathStat;
import hardcorequesting.common.forge.death.DeathType;
import hardcorequesting.common.forge.io.SaveHandler;
import hardcorequesting.common.forge.network.NetworkManager;
import hardcorequesting.common.forge.network.message.DeathStatsMessage;
import hardcorequesting.common.forge.quests.QuestLine;
import hardcorequesting.common.forge.quests.SimpleSerializable;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.player.Player;

public class DeathStatsManager
extends SimpleSerializable {
    private static final Comparator<DeathStat> DEATH_COMPARATOR = Comparator.comparingInt(DeathStat::getTotalDeaths).reversed();
    public static final String FILE_PATH = "deaths.json";
    private final Map<UUID, DeathStat> deathMap = new HashMap<UUID, DeathStat>();
    private List<DeathStat> clientDeathList = Collections.emptyList();
    private DeathStat clientBest;
    private DeathStat clientTotal;

    public static DeathStatsManager getInstance() {
        return QuestLine.getActiveQuestLine().deathStatsManager;
    }

    public DeathStat getDeathStat(Player player) {
        return this.getDeathStat(player.m_20148_());
    }

    public DeathStat getDeathStat(UUID uuid) {
        return this.deathMap.computeIfAbsent(uuid, DeathStat::new);
    }

    public List<DeathStat> getDeathStats() {
        return this.clientDeathList;
    }

    private void updateClientDeathList() {
        this.clientDeathList = this.deathMap.values().stream().sorted(DEATH_COMPARATOR).toList();
        this.clientBest = new DeathStat.DeathStatBest(this.clientDeathList);
        this.clientTotal = new DeathStat.DeathStatTotal(this.clientDeathList);
    }

    public DeathStat getBest() {
        return this.clientBest;
    }

    public DeathStat getTotal() {
        return this.clientTotal;
    }

    public void resync() {
        NetworkManager.sendToAllPlayers(new DeathStatsMessage(HardcoreQuestingCore.platform.isClient()));
    }

    public List<DeathStat> getDeathStatsList() {
        return Lists.newArrayList(this.deathMap.values());
    }

    @Override
    public String saveToString() {
        return SaveHandler.save(this.getDeathStatsList(), new TypeToken<List<DeathStat>>(){}.getType());
    }

    public void writeSimplified(FriendlyByteBuf buf) {
        buf.writeInt(this.deathMap.size());
        for (Map.Entry<UUID, DeathStat> entry : this.deathMap.entrySet()) {
            buf.m_130077_(entry.getKey());
            Map<DeathType, Integer> deaths = entry.getValue().deaths;
            int count = 0;
            DeathType[] deathTypeArray = deaths.values().iterator();
            while (deathTypeArray.hasNext()) {
                int death = deathTypeArray.next();
                if (death == 0) continue;
                ++count;
            }
            buf.writeByte(count);
            for (DeathType type : DeathType.values()) {
                int deathCount = deaths.get((Object)type);
                if (deathCount == 0) continue;
                buf.writeByte(type.ordinal());
                buf.writeShort((int)((short)deathCount));
            }
        }
    }

    public Map<UUID, DeathStat> readSimplified(FriendlyByteBuf buf) {
        HashMap<UUID, DeathStat> deathMap = new HashMap<UUID, DeathStat>();
        int length = buf.readInt();
        for (int i = 0; i < length; ++i) {
            UUID uuid = buf.m_130259_();
            DeathStat stat = new DeathStat(uuid);
            int count = buf.readByte();
            for (int j = 0; j < count; ++j) {
                DeathType type = DeathType.getClamped(buf.readByte());
                stat.increaseDeath(type, buf.readShort(), false);
            }
            deathMap.put(uuid, stat);
        }
        return deathMap;
    }

    @Override
    public String filePath() {
        return FILE_PATH;
    }

    @Override
    public boolean isData() {
        return true;
    }

    @Override
    public void clear() {
        this.deathMap.clear();
    }

    @Override
    public void loadFromString(String string) {
        SaveHandler.load(string, new TypeToken<List<DeathStat>>(){}.getType()).ifPresent(list -> list.forEach(stat -> this.deathMap.put(stat.getUuid(), (DeathStat)stat)));
        if (HardcoreQuestingCore.platform.isClient()) {
            this.updateClientDeathList();
        }
    }
}

