/*
 * Decompiled with CFR 0.152.
 */
package hardcorequesting.common.forge.death;

import hardcorequesting.common.forge.death.DeathStatsManager;
import hardcorequesting.common.forge.util.Translator;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public enum DeathType {
    LAVA("lava"){

        @Override
        boolean isSourceValid(DamageSource source) {
            return source.m_276093_(DamageTypes.f_268546_);
        }
    }
    ,
    FIRE("fire"){

        @Override
        boolean isSourceValid(DamageSource source) {
            return source.m_276093_(DamageTypes.f_268468_);
        }
    }
    ,
    SUFFOCATION("suffocation"){

        @Override
        boolean isSourceValid(DamageSource source) {
            return source.m_276093_(DamageTypes.f_268612_);
        }
    }
    ,
    THORNS("thorns"){

        @Override
        boolean isSourceValid(DamageSource source) {
            return source.m_276093_(DamageTypes.f_268440_) || source.m_276093_(DamageTypes.f_268585_);
        }
    }
    ,
    DROWNING("drowning"){

        @Override
        boolean isSourceValid(DamageSource source) {
            return source.m_276093_(DamageTypes.f_268722_);
        }
    }
    ,
    STARVATION("starvation"){

        @Override
        boolean isSourceValid(DamageSource source) {
            return source.m_276093_(DamageTypes.f_268441_);
        }
    }
    ,
    FALL("fall"){

        @Override
        boolean isSourceValid(DamageSource source) {
            return source.m_276093_(DamageTypes.f_268671_);
        }
    }
    ,
    VOID("void"){

        @Override
        boolean isSourceValid(DamageSource source) {
            return source.m_276093_(DamageTypes.f_268724_);
        }
    }
    ,
    CRUSHED("crushed"){

        @Override
        boolean isSourceValid(DamageSource source) {
            return source.m_276093_(DamageTypes.f_268526_) || source.m_276093_(DamageTypes.f_268659_);
        }
    }
    ,
    EXPLOSION("explosions"){

        @Override
        boolean isSourceValid(DamageSource source) {
            return source.m_276093_(DamageTypes.f_268565_);
        }
    }
    ,
    MONSTER("monsters"){

        @Override
        boolean isSourceValid(DamageSource source) {
            return source.m_276093_(DamageTypes.f_268566_) || source.m_276093_(DamageTypes.f_268511_) || source.m_276093_(DamageTypes.f_268534_) || source.m_7639_() instanceof LivingEntity;
        }
    }
    ,
    PLAYER("otherPlayers"){

        @Override
        boolean isSourceValid(DamageSource source) {
            return source.m_276093_(DamageTypes.f_268464_) || source.m_7639_() instanceof Player;
        }
    }
    ,
    MAGIC("magic"){

        @Override
        boolean isSourceValid(DamageSource source) {
            return source.m_276093_(DamageTypes.f_268515_);
        }
    }
    ,
    HQM("rottenHearts"){

        @Override
        boolean isSourceValid(DamageSource source) {
            return false;
        }
    }
    ,
    OTHER("other"){

        @Override
        boolean isSourceValid(DamageSource source) {
            return true;
        }
    };

    private final String name;

    private DeathType(String name) {
        this.name = name;
    }

    public static void onDeath(Player player, DamageSource source) {
        if (source != null) {
            for (DeathType deathType : DeathType.values()) {
                if (!deathType.isSourceValid(source)) continue;
                deathType.onDeath(player);
                break;
            }
        } else {
            OTHER.onDeath(player);
        }
    }

    public void onDeath(Player player) {
        DeathStatsManager.getInstance().getDeathStat(player).increaseDeath(this);
    }

    abstract boolean isSourceValid(DamageSource var1);

    public MutableComponent getName() {
        return Translator.translatable("hqm.deathType." + this.name, new Object[0]);
    }

    public static DeathType getClamped(int i) {
        return DeathType.values()[Mth.m_14045_((int)i, (int)0, (int)DeathType.values().length)];
    }
}

