/*
 * Decompiled with CFR 0.152.
 */
package hardcorequesting.common.forge.event;

import hardcorequesting.common.forge.HardcoreQuestingCore;
import hardcorequesting.common.forge.config.HQMConfig;
import hardcorequesting.common.forge.death.DeathStatsManager;
import hardcorequesting.common.forge.quests.Quest;
import hardcorequesting.common.forge.quests.QuestLine;
import hardcorequesting.common.forge.quests.QuestingDataManager;
import hardcorequesting.common.forge.util.HQMUtil;
import hardcorequesting.common.forge.util.Translator;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;

public class PlayerTracker {
    public static PlayerTracker instance;
    public static final String HQ_TAG = "HardcoreQuesting";
    public static final String RECEIVED_BOOK = "questBook";

    public PlayerTracker() {
        instance = this;
    }

    public int getRemainingLives(Player sender) {
        return QuestingDataManager.getInstance().getQuestingData(sender).getLives();
    }

    public void onPlayerLogin(ServerPlayer player) {
        CompoundTag tags;
        QuestLine.sendDataToClient(player);
        QuestingDataManager questingData = QuestingDataManager.getInstance();
        if (!questingData.hasData((Player)player)) {
            DeathStatsManager.getInstance().resync();
        }
        if (questingData.isHardcoreActive()) {
            this.sendLoginMessage((Player)player);
        } else if (HQMConfig.getInstance().Message.NO_HARDCORE_MESSAGE) {
            player.m_213846_((Component)Translator.translatable("hqm.message.noHardcore", new Object[0]));
        }
        if (!HQMUtil.isSinglePlayerOnly()) {
            Quest.setEditMode(false);
        }
        if ((tags = HardcoreQuestingCore.platform.getPlayerExtraTag((Player)player)).m_128441_(HQ_TAG)) {
            if (tags.m_128469_(HQ_TAG).m_128471_(RECEIVED_BOOK)) {
                questingData.getQuestingData((Player)player).receivedBook = true;
            }
            if (!questingData.isQuestActive()) {
                tags.m_128473_(HQ_TAG);
            }
        }
        questingData.spawnBook((Player)player);
    }

    private void sendLoginMessage(Player player) {
        player.m_213846_((Component)Translator.translatable("hqm.message.hardcore", new Object[0]).m_130946_(" ").m_7220_((Component)Translator.translatable("hqm.message.livesLeft", Translator.lives(this.getRemainingLives(player)))));
    }
}

