/*
 * Decompiled with CFR 0.152.
 */
package hardcorequesting.common.forge.io;

import hardcorequesting.common.forge.io.DataReader;
import hardcorequesting.common.forge.io.DataWriter;
import hardcorequesting.common.forge.io.SaveHandler;
import java.io.IOException;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Optional;
import java.util.stream.Stream;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.level.storage.LevelResource;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class FileDataManager
implements DataReader,
DataWriter {
    private static final Logger LOGGER = LogManager.getLogger((String)"Hardcore Questing Mode");
    private final Path path;

    public static FileDataManager createForWorldData(MinecraftServer server) {
        Path hqm = FileDataManager.getWorldPath(server).resolve("hqm");
        return new FileDataManager(hqm);
    }

    private static Path getWorldPath(MinecraftServer server) {
        return server.m_129843_(LevelResource.f_78182_).toAbsolutePath().normalize();
    }

    public FileDataManager(Path path) {
        this.path = path;
        try {
            if (!Files.exists(this.path, new LinkOption[0])) {
                Files.createDirectories(this.path, new FileAttribute[0]);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public Optional<String> read(String name) {
        return SaveHandler.load(this.path.resolve(name));
    }

    @Override
    public Stream<String> readAll(DirectoryStream.Filter<Path> filter) {
        Stream<String> stream;
        block8: {
            DirectoryStream<Path> stream2 = Files.newDirectoryStream(this.path, filter);
            try {
                ArrayList paths = new ArrayList();
                stream2.forEach(paths::add);
                stream = paths.stream().flatMap(file -> SaveHandler.load(file).stream());
                if (stream2 == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (stream2 != null) {
                        try {
                            stream2.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    LOGGER.warn("File search failed.", (Throwable)e);
                    return Stream.empty();
                }
            }
            stream2.close();
        }
        return stream;
    }

    @Override
    public void write(String name, String text) {
        SaveHandler.save(this.path.resolve(name), text);
    }

    public String toString() {
        return "File data";
    }
}

