/*
 * Decompiled with CFR 0.152.
 */
package hardcorequesting.common.forge.io;

import com.google.gson.FieldNamingPolicy;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonParser;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import hardcorequesting.common.forge.HardcoreQuestingCore;
import hardcorequesting.common.forge.bag.GroupTier;
import hardcorequesting.common.forge.death.DeathStat;
import hardcorequesting.common.forge.io.adapter.DeathAdapter;
import hardcorequesting.common.forge.io.adapter.GroupAdapter;
import hardcorequesting.common.forge.io.adapter.QuestAdapter;
import hardcorequesting.common.forge.io.adapter.QuestingAdapter;
import hardcorequesting.common.forge.io.adapter.ReputationAdapter;
import hardcorequesting.common.forge.io.adapter.TeamAdapter;
import hardcorequesting.common.forge.quests.QuestSet;
import hardcorequesting.common.forge.quests.QuestingData;
import hardcorequesting.common.forge.reputation.Reputation;
import hardcorequesting.common.forge.team.Team;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.lang.reflect.Type;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;

public class SaveHandler {
    public static final Gson GSON = new GsonBuilder().registerTypeAdapter(Reputation.class, ReputationAdapter.REPUTATION_ADAPTER).registerTypeAdapter(QuestSet.class, QuestAdapter.QUEST_SET_ADAPTER).registerTypeAdapter(GroupTier.class, GroupAdapter.GROUP_TIER_ADAPTER).registerTypeAdapter(DeathStat.class, DeathAdapter.DEATH_STATS_ADAPTER).registerTypeAdapter(Team.class, TeamAdapter.TEAM_ADAPTER).registerTypeAdapter(QuestingData.class, QuestingAdapter.QUESTING_DATA_ADAPTER).setFieldNamingPolicy(FieldNamingPolicy.UPPER_CAMEL_CASE_WITH_SPACES).setPrettyPrinting().create();
    public static final JsonParser JSON_PARSER = new JsonParser();
    public static final String QUESTING = "questing";
    public static final String HARDCORE = "hardcore";

    public static void copyFolder(File from, File to) {
        try {
            FileUtils.copyDirectory((File)from, (File)to);
        }
        catch (IOException e) {
            HardcoreQuestingCore.LOGGER.info("Couldn't copy default files");
        }
    }

    public static <T> Optional<T> load(File file, Type type) {
        return SaveHandler.load(file.toPath(), type);
    }

    public static <T> Optional<T> load(Path file, Type type) {
        Optional<Object> optional;
        block9: {
            if (!Files.exists(file, new LinkOption[0])) {
                return Optional.empty();
            }
            BufferedReader reader = Files.newBufferedReader(file);
            try {
                Object o = GSON.fromJson((Reader)reader, type);
                optional = Optional.ofNullable(o);
                if (reader == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (reader != null) {
                        try {
                            reader.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    e.printStackTrace();
                    return Optional.empty();
                }
            }
            reader.close();
        }
        return optional;
    }

    public static <T> Optional<T> load(String str, Type type) {
        Object o = GSON.fromJson(str, type);
        return Optional.ofNullable(o);
    }

    public static <T> Optional<T> load(File file, Class<T> type) {
        return SaveHandler.load(file.toPath(), type);
    }

    public static <T> Optional<T> load(Path file, Class<T> type) {
        Optional<Object> optional;
        block9: {
            if (!Files.exists(file, new LinkOption[0])) {
                return Optional.empty();
            }
            BufferedReader reader = Files.newBufferedReader(file);
            try {
                Object o = GSON.fromJson((Reader)reader, type);
                optional = Optional.ofNullable(o);
                if (reader == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (reader != null) {
                        try {
                            reader.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    e.printStackTrace();
                    return Optional.empty();
                }
            }
            reader.close();
        }
        return optional;
    }

    public static <T> Optional<T> load(String str, Class<T> type) {
        Object o = GSON.fromJson(str, type);
        return Optional.ofNullable(o);
    }

    public static Optional<String> load(File file) {
        return SaveHandler.load(file.toPath());
    }

    public static Optional<String> load(Path file) {
        Optional<String> optional;
        block9: {
            if (!Files.exists(file, new LinkOption[0])) {
                return Optional.empty();
            }
            BufferedReader reader = Files.newBufferedReader(file);
            try {
                optional = Optional.ofNullable(IOUtils.toString((Reader)reader));
                if (reader == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (reader != null) {
                        try {
                            reader.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    e.printStackTrace();
                    return Optional.empty();
                }
            }
            reader.close();
        }
        return optional;
    }

    public static String saveTeam(Team team) {
        return SaveHandler.save(team, new TypeToken<Team>(){}.getType());
    }

    public static List<GroupTier> loadBags(File file) throws IOException {
        if (!file.exists()) {
            return new ArrayList<GroupTier>();
        }
        JsonReader reader = new JsonReader((Reader)new FileReader(file));
        List bags = (List)GSON.fromJson(reader, new TypeToken<List<GroupTier>>(){}.getType());
        reader.close();
        return bags == null ? new ArrayList() : bags;
    }

    public static void save(Path file, Object object, Type type) {
        SaveHandler.save(file.toAbsolutePath().toFile(), SaveHandler.save(object, type));
    }

    public static void save(File file, Object object, Type type) {
        SaveHandler.save(file, SaveHandler.save(object, type));
    }

    public static void save(Path file, String s) {
        SaveHandler.save(file.toAbsolutePath().toFile(), s);
    }

    public static void save(File file, String s) {
        if (!file.getParentFile().exists()) {
            file.getParentFile().mkdirs();
        }
        try (BufferedWriter fileWriter = Files.newBufferedWriter(file.toPath(), StandardOpenOption.CREATE, StandardOpenOption.WRITE, StandardOpenOption.TRUNCATE_EXISTING);){
            fileWriter.write(s);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static String save(Object object, Type type) {
        return GSON.toJson(object, type);
    }
}

