/*
 * Decompiled with CFR 0.152.
 */
package hardcorequesting.common.forge.io.adapter;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonNull;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.TypeAdapter;
import com.google.gson.internal.Streams;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import hardcorequesting.common.forge.HardcoreQuestingCore;
import java.io.IOException;
import java.util.function.Consumer;
import org.jetbrains.annotations.Nullable;

public abstract class Adapter<T>
extends TypeAdapter<T> {
    public abstract JsonElement serialize(T var1);

    @Nullable
    public abstract T deserialize(JsonElement var1);

    public void write(JsonWriter out, T value) throws IOException {
        Streams.write((JsonElement)this.serialize(value), (JsonWriter)out);
    }

    public T read(JsonReader in) {
        try {
            JsonElement jsonElement = Streams.parse((JsonReader)in);
            return this.deserialize(jsonElement);
        }
        catch (JsonParseException e) {
            HardcoreQuestingCore.LOGGER.error("Can't parse JsonReader to JsonElement!", (Throwable)e);
            return null;
        }
    }

    public static JsonObjectBuilder object() {
        return new JsonObjectBuilder(new JsonObject());
    }

    public static JsonArrayBuilder array() {
        return new JsonArrayBuilder(new JsonArray());
    }

    @SafeVarargs
    public static <T> JsonArrayBuilder array(T ... objects) {
        JsonArrayBuilder array = Adapter.array();
        for (T o : objects) {
            array.smartInsert(o);
        }
        return array;
    }

    public static JsonArrayBuilder array(boolean ... objects) {
        JsonArrayBuilder array = Adapter.array();
        for (boolean o : objects) {
            array.add(o);
        }
        return array;
    }

    public static JsonArrayBuilder array(int ... objects) {
        JsonArrayBuilder array = Adapter.array();
        for (int o : objects) {
            array.add(o);
        }
        return array;
    }

    public static JsonArrayBuilder array(float ... objects) {
        JsonArrayBuilder array = Adapter.array();
        for (float o : objects) {
            array.add(Float.valueOf(o));
        }
        return array;
    }

    public static JsonArrayBuilder array(double ... objects) {
        JsonArrayBuilder array = Adapter.array();
        for (double o : objects) {
            array.add(o);
        }
        return array;
    }

    public static JsonArrayBuilder array(long ... objects) {
        JsonArrayBuilder array = Adapter.array();
        for (long o : objects) {
            array.add(o);
        }
        return array;
    }

    public static JsonArrayBuilder array(char ... objects) {
        JsonArrayBuilder array = Adapter.array();
        for (char o : objects) {
            array.add(o);
        }
        return array;
    }

    public static JsonNull nullVal() {
        return JsonNull.INSTANCE;
    }

    public static class JsonObjectBuilder {
        private JsonObject object;

        public JsonObjectBuilder(JsonObject object) {
            this.object = object;
        }

        public JsonObjectBuilder add(String key, JsonElement element) {
            this.object.add(key, element);
            return this;
        }

        public JsonObjectBuilder add(String key, Number element) {
            this.object.addProperty(key, element);
            return this;
        }

        public JsonObjectBuilder add(String key, String element) {
            this.object.addProperty(key, element);
            return this;
        }

        public JsonObjectBuilder add(String key, boolean element) {
            this.object.addProperty(key, Boolean.valueOf(element));
            return this;
        }

        public JsonObjectBuilder add(String key, char element) {
            this.object.addProperty(key, Character.valueOf(element));
            return this;
        }

        public JsonObjectBuilder use(Consumer<JsonObjectBuilder> consumer) {
            consumer.accept(this);
            return this;
        }

        public JsonObject build() {
            return this.object;
        }
    }

    public static class JsonArrayBuilder {
        private JsonArray array;

        public JsonArrayBuilder(JsonArray array) {
            this.array = array;
        }

        public JsonArrayBuilder add(JsonElement element) {
            this.array.add(element);
            return this;
        }

        public JsonArrayBuilder add(Number element) {
            this.array.add(element);
            return this;
        }

        public JsonArrayBuilder add(String element) {
            this.array.add(element);
            return this;
        }

        public JsonArrayBuilder add(boolean element) {
            this.array.add(Boolean.valueOf(element));
            return this;
        }

        public JsonArrayBuilder add(char element) {
            this.array.add(Character.valueOf(element));
            return this;
        }

        public JsonArrayBuilder smartInsert(Object o) {
            if (o instanceof JsonElement) {
                return this.add((JsonElement)o);
            }
            if (o instanceof Number) {
                return this.add((Number)o);
            }
            if (o instanceof String) {
                return this.add((String)o);
            }
            if (o instanceof Boolean) {
                return this.add((Boolean)o);
            }
            if (o instanceof Character) {
                return this.add(((Character)o).charValue());
            }
            return this;
        }

        public JsonArrayBuilder use(Consumer<JsonArrayBuilder> consumer) {
            consumer.accept(this);
            return this;
        }

        public JsonArray build() {
            return this.array;
        }
    }
}

