/*
 * Decompiled with CFR 0.152.
 */
package hardcorequesting.common.forge.io.adapter;

import com.google.common.base.Enums;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import hardcorequesting.common.forge.HardcoreQuestingCore;
import hardcorequesting.common.forge.bag.BagTier;
import hardcorequesting.common.forge.bag.GroupTier;
import hardcorequesting.common.forge.bag.LootGroup;
import hardcorequesting.common.forge.bag.TierColor;
import hardcorequesting.common.forge.io.adapter.Adapter;
import hardcorequesting.common.forge.io.adapter.MinecraftAdapter;
import hardcorequesting.common.forge.util.WrappedText;
import java.util.Arrays;
import java.util.UUID;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.ItemStack;

public class GroupAdapter {
    public static final Adapter<LootGroup> GROUP_ADAPTER = new Adapter<LootGroup>(){
        private static final String ID = "id";
        private static final String ITEMS = "items";
        private static final String NAME = "name";
        private static final String LIMIT = "limit";

        @Override
        public JsonElement serialize(LootGroup src) {
            return 1.object().add(ID, src.getId().toString()).use(builder -> {
                if (src.hasName()) {
                    builder.add(NAME, src.getRawName().toJson());
                }
            }).add(LIMIT, src.getLimit()).add(ITEMS, (JsonElement)1.array().use(builder -> src.getItems().stream().map(MinecraftAdapter.ITEM_STACK::serialize).forEach(builder::add)).build()).build();
        }

        @Override
        public LootGroup deserialize(JsonElement jsonElement) {
            LootGroup group;
            if (!jsonElement.isJsonObject()) {
                HardcoreQuestingCore.LOGGER.error((Object)new JsonParseException("JsonElement for 'Group' is not a JsonObject but '" + jsonElement.getClass().getName() + "'!"));
                return null;
            }
            JsonObject json = jsonElement.getAsJsonObject();
            if (!json.has(ID) || !json.get(ID).isJsonPrimitive()) {
                HardcoreQuestingCore.LOGGER.error((Object)new JsonParseException("JsonElement 'id' for 'Group' is not present or a valid string value!"));
                return null;
            }
            if (!json.has(LIMIT) || !GsonHelper.m_13872_((JsonElement)json.get(LIMIT))) {
                HardcoreQuestingCore.LOGGER.error((Object)new JsonParseException("JsonElement 'limit' for 'Group' is not present or a valid int value!"));
                return null;
            }
            try {
                group = new LootGroup(UUID.fromString(json.get(ID).getAsString()));
            }
            catch (IllegalArgumentException e) {
                HardcoreQuestingCore.LOGGER.error("JsonElement 'id' for 'Group' can't be parsed to UUID!", (Throwable)e);
                return null;
            }
            if (json.has(NAME)) {
                group.setName(WrappedText.fromJson(json.get(NAME), false));
            }
            group.setLimit(json.get(LIMIT).getAsInt());
            if (json.has(ITEMS) && json.get(ITEMS).isJsonArray()) {
                for (JsonElement element : json.get(ITEMS).getAsJsonArray()) {
                    ItemStack stack = MinecraftAdapter.ITEM_STACK.deserialize(element);
                    if (stack == null || stack.m_41619_()) continue;
                    group.getItems().add((Object)stack);
                }
            }
            if (!LootGroup.getGroups().containsKey(group.getId())) {
                LootGroup.add(group);
            }
            return group;
        }
    };
    public static final Adapter<GroupTier> GROUP_TIER_ADAPTER = new Adapter<GroupTier>(){
        private static final String NAME = "name";
        private static final String COLOUR = "colour";
        private static final String WEIGHTS = "weights";
        private static final String GROUPS = "groups";

        @Override
        public JsonElement serialize(GroupTier src) {
            return 2.object().add(NAME, src.getRawName().toJson()).add(COLOUR, src.getColor().name()).add(WEIGHTS, (JsonElement)2.array().use(builder -> Arrays.stream(src.getWeights()).forEach(builder::add)).build()).add(GROUPS, (JsonElement)2.array().use(builder -> LootGroup.getGroups().values().stream().filter(group -> group.getTier().equals(src)).map(GROUP_ADAPTER::serialize).forEach(builder::add)).build()).build();
        }

        @Override
        public GroupTier deserialize(JsonElement jsonElement) {
            if (!jsonElement.isJsonObject()) {
                HardcoreQuestingCore.LOGGER.error((Object)new JsonParseException("JsonElement for 'Group Tier' is not a JsonObject but '" + jsonElement.getClass().getName() + "'!"));
                return null;
            }
            JsonObject json = jsonElement.getAsJsonObject();
            int[] weights = new int[BagTier.values().length];
            WrappedText name = null;
            TierColor color = TierColor.GRAY;
            if (json.has(NAME)) {
                name = WrappedText.fromJson(json.get(NAME), false);
            }
            if (json.has(COLOUR) && json.get(COLOUR).isJsonPrimitive()) {
                if (Enums.getIfPresent(TierColor.class, (String)json.get(COLOUR).getAsString()).isPresent()) {
                    color = TierColor.valueOf(json.get(COLOUR).getAsString());
                } else {
                    HardcoreQuestingCore.LOGGER.error("JsonElement 'colour' of 'Group Tier' cannot be mapped to a color!");
                }
            }
            if (json.has(WEIGHTS) && json.get(WEIGHTS).isJsonArray()) {
                int idx = 0;
                for (JsonElement element : json.get(WEIGHTS).getAsJsonArray()) {
                    if (element.isJsonPrimitive() && element.getAsJsonPrimitive().isNumber()) {
                        weights[idx] = element.getAsJsonPrimitive().getAsInt();
                    } else {
                        HardcoreQuestingCore.LOGGER.error((Object)new JsonParseException("JsonArray 'weights' of 'Group Tier' does contain a invalid value of type '" + element.getClass().getName() + "'!"));
                    }
                    ++idx;
                }
            }
            GroupTier tier = new GroupTier(name, color, weights);
            if (json.has(GROUPS) && json.get(GROUPS).isJsonArray()) {
                for (JsonElement element : json.get(GROUPS).getAsJsonArray()) {
                    LootGroup group = GROUP_ADAPTER.deserialize(element);
                    if (group != null) {
                        group.setTier(tier);
                        continue;
                    }
                    HardcoreQuestingCore.LOGGER.error((Object)new JsonParseException("JsonElement of 'Group Tier' can't be parsed as 'Group'!"));
                }
            }
            return tier;
        }
    };
}

