/*
 * Decompiled with CFR 0.152.
 */
package hardcorequesting.common.forge.io.adapter;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSyntaxException;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import dev.architectury.fluid.FluidStack;
import hardcorequesting.common.forge.io.adapter.Adapter;
import hardcorequesting.common.forge.io.adapter.PatchedNbtOps;
import hardcorequesting.common.forge.util.FluidUtils;
import hardcorequesting.common.forge.util.Fraction;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.TagParser;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.material.Fluid;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MinecraftAdapter {
    public static final Adapter<ItemStack> ITEM_STACK = new Adapter<ItemStack>(){

        @Override
        public JsonElement serialize(ItemStack src) {
            if (src.m_41619_()) {
                return 1.nullVal();
            }
            JsonObject jsonObj = new JsonObject();
            jsonObj.addProperty("id", BuiltInRegistries.f_257033_.m_7981_((Object)src.m_41720_()).toString());
            jsonObj.addProperty("Count", (Number)src.m_41613_());
            CompoundTag tag = src.m_41783_();
            if (tag != null) {
                jsonObj.add("tag", COMPOUND_TAG.serialize(tag));
            }
            return jsonObj;
        }

        @Override
        @NotNull
        public ItemStack deserialize(JsonElement json) {
            if (json.isJsonNull()) {
                return ItemStack.f_41583_;
            }
            JsonObject jsonObj = json.getAsJsonObject();
            Item item = (Item)BuiltInRegistries.f_257033_.m_7745_(new ResourceLocation(GsonHelper.m_13906_((JsonObject)jsonObj, (String)"id")));
            byte count = GsonHelper.m_144790_((JsonObject)jsonObj, (String)"Count");
            ItemStack stack = new ItemStack((ItemLike)item, (int)count);
            if (jsonObj.has("tag")) {
                stack.m_41751_(COMPOUND_TAG.deserialize(jsonObj.get("tag")));
            }
            return stack;
        }
    };
    public static final Adapter<ItemStack> ICON_ITEM_STACK = new Adapter<ItemStack>(){

        @Override
        public JsonElement serialize(ItemStack src) {
            if (src.m_41613_() > 1) {
                src = src.m_41777_();
                src.m_41764_(1);
            }
            return ITEM_STACK.serialize(src);
        }

        @Override
        public ItemStack deserialize(JsonElement json) {
            ItemStack stack = ITEM_STACK.deserialize(json);
            if (stack.m_41613_() > 1) {
                stack.m_41764_(1);
            }
            return stack;
        }
    };
    public static final Adapter<FluidStack> FLUID = new Adapter<FluidStack>(){
        private static final String FLUID = "fluid";
        private static final String VOLUME = "volume";

        @Override
        public JsonElement serialize(FluidStack src) {
            return 3.object().add(FLUID, BuiltInRegistries.f_257020_.m_7981_((Object)src.getFluid()).toString()).add(VOLUME, (JsonElement)Fraction.CODEC.encodeStart((DynamicOps)JsonOps.INSTANCE, (Object)FluidUtils.getAmount(src)).result().orElseThrow()).build();
        }

        @Override
        public FluidStack deserialize(JsonElement json) {
            JsonObject object = json.getAsJsonObject();
            Fluid fluid = (Fluid)BuiltInRegistries.f_257020_.m_7745_(new ResourceLocation(GsonHelper.m_13906_((JsonObject)object, (String)FLUID)));
            Fraction amount = (Fraction)Fraction.CODEC.parse((DynamicOps)JsonOps.INSTANCE, (Object)object.get(VOLUME)).result().orElseThrow();
            return FluidStack.create((Fluid)fluid, (long)amount.intValue());
        }
    };
    public static final Adapter<CompoundTag> COMPOUND_TAG = new Adapter<CompoundTag>(){

        @Override
        public JsonElement serialize(CompoundTag src) {
            return new JsonPrimitive(src.toString());
        }

        @Override
        @Nullable
        public CompoundTag deserialize(JsonElement json) {
            if (json.isJsonObject()) {
                return (CompoundTag)Dynamic.convert((DynamicOps)JsonOps.INSTANCE, (DynamicOps)PatchedNbtOps.INSTANCE, (Object)json);
            }
            try {
                return TagParser.m_129359_((String)GsonHelper.m_13805_((JsonElement)json, (String)"tag"));
            }
            catch (CommandSyntaxException e) {
                throw new JsonSyntaxException(e.getMessage());
            }
        }
    };
}

