/*
 * Decompiled with CFR 0.152.
 */
package hardcorequesting.common.forge.io.adapter;

import java.util.List;
import java.util.stream.Stream;
import net.minecraft.nbt.ByteArrayTag;
import net.minecraft.nbt.ByteTag;
import net.minecraft.nbt.EndTag;
import net.minecraft.nbt.IntArrayTag;
import net.minecraft.nbt.IntTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.LongArrayTag;
import net.minecraft.nbt.LongTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.NumericTag;
import net.minecraft.nbt.ShortTag;
import net.minecraft.nbt.Tag;

public class PatchedNbtOps
extends NbtOps {
    public static final PatchedNbtOps INSTANCE = new PatchedNbtOps();

    public Tag createList(Stream<Tag> stream) {
        List<Tag> elements = stream.toList();
        if (elements.isEmpty()) {
            return new ListTag();
        }
        if (elements.stream().allMatch(this::canBeInByteArray)) {
            return new ByteArrayTag(elements.stream().map(tag -> ((NumericTag)tag).m_7063_()).toList());
        }
        if (elements.stream().allMatch(this::canBeInIntArray)) {
            return new IntArrayTag(elements.stream().map(tag -> ((NumericTag)tag).m_7047_()).toList());
        }
        if (elements.stream().allMatch(this::canBeInLongArray)) {
            return new LongArrayTag(elements.stream().map(tag -> ((NumericTag)tag).m_7046_()).toList());
        }
        ListTag listTag = new ListTag();
        elements.forEach(tag -> {
            if (!(tag instanceof EndTag)) {
                listTag.add(tag);
            }
        });
        return listTag;
    }

    public boolean canBeInLongArray(Tag tag) {
        return tag instanceof LongTag || this.canBeInIntArray(tag);
    }

    public boolean canBeInIntArray(Tag tag) {
        return tag instanceof IntTag || tag instanceof ShortTag || this.canBeInByteArray(tag);
    }

    public boolean canBeInByteArray(Tag tag) {
        return tag instanceof ByteTag;
    }
}

