/*
 * Decompiled with CFR 0.152.
 */
package hardcorequesting.common.forge.io.adapter;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import hardcorequesting.common.forge.io.adapter.Adapter;
import hardcorequesting.common.forge.quests.Quest;
import hardcorequesting.common.forge.quests.data.QuestData;
import hardcorequesting.common.forge.quests.data.TaskData;
import hardcorequesting.common.forge.quests.task.QuestTask;
import java.util.ArrayList;
import java.util.Objects;
import net.minecraft.util.GsonHelper;

public class QuestDataAdapter {
    public static final String REWARDS = "rewards";
    public static final String COMPLETED = "completed";
    public static final String CLAIMED = "claimed";
    public static final String TASKS = "tasks";
    public static final String AVAILABLE = "available";
    public static final String TIME = "time";

    public static JsonElement serialize(QuestData data) {
        JsonObject json = new JsonObject();
        JsonArray rewards = new JsonArray();
        for (boolean canClaim : data.getRewardsForSerialization()) {
            rewards.add(Boolean.valueOf(canClaim));
        }
        json.add(REWARDS, (JsonElement)rewards);
        json.addProperty(COMPLETED, Boolean.valueOf(data.completed));
        json.addProperty(CLAIMED, Boolean.valueOf(data.teamRewardClaimed));
        json.addProperty(AVAILABLE, Boolean.valueOf(data.available));
        json.addProperty(TIME, (Number)data.time);
        JsonArray tasks = new JsonArray();
        for (TaskData taskData : data.getTaskDataForSerialization()) {
            if (taskData != null) {
                Adapter.JsonObjectBuilder builder = Adapter.object();
                taskData.write(builder);
                tasks.add((JsonElement)builder.build());
                continue;
            }
            tasks.add((JsonElement)new JsonObject());
        }
        json.add(TASKS, (JsonElement)tasks);
        return json;
    }

    public static QuestData deserialize(JsonObject json, Quest quest) {
        Objects.requireNonNull(quest);
        QuestData data = new QuestData();
        JsonArray rewardsJson = GsonHelper.m_13933_((JsonObject)json, (String)REWARDS);
        ArrayList<Boolean> claimableRewards = new ArrayList<Boolean>();
        for (JsonElement canClaim : rewardsJson) {
            claimableRewards.add(GsonHelper.m_13877_((JsonElement)canClaim, (String)"reward"));
        }
        data.setRewardsFromSerialization(claimableRewards);
        data.completed = GsonHelper.m_13912_((JsonObject)json, (String)COMPLETED);
        data.teamRewardClaimed = GsonHelper.m_13912_((JsonObject)json, (String)CLAIMED);
        data.available = GsonHelper.m_13912_((JsonObject)json, (String)AVAILABLE);
        data.time = GsonHelper.m_13921_((JsonObject)json, (String)TIME);
        JsonArray tasksJson = GsonHelper.m_13933_((JsonObject)json, (String)TASKS);
        ArrayList<TaskData> taskData = new ArrayList<TaskData>();
        for (int i = 0; i < tasksJson.size() && i < quest.getTasks().size(); ++i) {
            JsonElement taskJson = tasksJson.get(i);
            QuestTask<?> task = quest.getTasks().get(i);
            taskData.add((TaskData)task.loadData(taskJson.getAsJsonObject()));
        }
        data.setTaskDataFromSerialization(taskData);
        return data;
    }
}

