/*
 * Decompiled with CFR 0.152.
 */
package hardcorequesting.common.forge.io.adapter;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.internal.Streams;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import com.mojang.datafixers.util.Either;
import dev.architectury.fluid.FluidStack;
import hardcorequesting.common.forge.io.adapter.Adapter;
import hardcorequesting.common.forge.io.adapter.MinecraftAdapter;
import hardcorequesting.common.forge.io.adapter.QuestAdapter;
import hardcorequesting.common.forge.quests.ItemPrecision;
import hardcorequesting.common.forge.quests.task.CompleteQuestTask;
import hardcorequesting.common.forge.quests.task.QuestTask;
import hardcorequesting.common.forge.quests.task.TaskType;
import hardcorequesting.common.forge.quests.task.icon.GetAdvancementTask;
import hardcorequesting.common.forge.quests.task.icon.KillMobsTask;
import hardcorequesting.common.forge.quests.task.icon.TameMobsTask;
import hardcorequesting.common.forge.quests.task.icon.VisitLocationTask;
import hardcorequesting.common.forge.quests.task.item.ItemRequirementTask;
import hardcorequesting.common.forge.quests.task.reputation.ReputationTask;
import hardcorequesting.common.forge.reputation.Reputation;
import hardcorequesting.common.forge.reputation.ReputationManager;
import hardcorequesting.common.forge.reputation.ReputationMarker;
import hardcorequesting.common.forge.util.WrappedText;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.ItemStack;

public class QuestTaskAdapter {
    public static final TypeAdapter<ItemRequirementTask.Part> ITEM_REQUIREMENT_ADAPTER = new TypeAdapter<ItemRequirementTask.Part>(){
        private static final String ITEM = "item";
        private static final String FLUID = "fluid";
        private static final String REQUIRED = "required";
        private static final String PRECISION = "precision";

        public void write(JsonWriter out, ItemRequirementTask.Part value) throws IOException {
            Optional stack = value.stack.left();
            Optional fluid = value.stack.right();
            int required = value.required;
            ItemPrecision precision = value.getPrecision();
            out.beginObject();
            if (stack.isPresent()) {
                MinecraftAdapter.ICON_ITEM_STACK.write(out.name(ITEM), (ItemStack)stack.get());
            } else if (fluid.isPresent()) {
                MinecraftAdapter.FLUID.write(out.name(FLUID), (FluidStack)fluid.get());
            } else {
                out.nullValue();
                out.endObject();
                return;
            }
            if (required != 1) {
                out.name(REQUIRED).value((long)required);
            }
            if (precision != ItemPrecision.PRECISE) {
                out.name(PRECISION).value(ItemPrecision.getUniqueID(precision));
            }
            out.endObject();
        }

        public ItemRequirementTask.Part read(JsonReader in) throws IOException {
            ItemRequirementTask.Part result;
            in.beginObject();
            ItemStack itemStack = ItemStack.f_41583_;
            FluidStack fluidVolume = null;
            int required = 1;
            ItemPrecision precision = ItemPrecision.PRECISE;
            while (in.hasNext()) {
                ItemPrecision itemPrecision;
                String next = in.nextName();
                if (next.equalsIgnoreCase(ITEM)) {
                    itemStack = MinecraftAdapter.ICON_ITEM_STACK.read(in);
                    continue;
                }
                if (next.equalsIgnoreCase(FLUID)) {
                    fluidVolume = MinecraftAdapter.FLUID.read(in);
                    continue;
                }
                if (next.equalsIgnoreCase(REQUIRED)) {
                    required = Math.max(in.nextInt(), required);
                    continue;
                }
                if (!next.equalsIgnoreCase(PRECISION) || (itemPrecision = ItemPrecision.getPrecisionType(in.nextString())) == null) continue;
                precision = itemPrecision;
            }
            in.endObject();
            if (!itemStack.m_41619_()) {
                result = new ItemRequirementTask.Part(itemStack, required);
            } else if (fluidVolume != null) {
                result = new ItemRequirementTask.Part(fluidVolume, required);
            } else {
                return null;
            }
            result.setPrecision(precision);
            return result;
        }
    };
    public static final Adapter<VisitLocationTask.Part> LOCATION_ADAPTER = new Adapter<VisitLocationTask.Part>(){
        private static final String X = "x";
        private static final String Y = "y";
        private static final String Z = "z";
        private static final String DIM = "dim";
        private static final String ICON = "icon";
        private static final String FLUID_ICON = "fluid_icon";
        private static final String RADIUS = "radius";
        private static final String VISIBLE = "visible";
        private static final String NAME = "name";

        @Override
        public JsonElement serialize(VisitLocationTask.Part src) {
            return 2.object().add(NAME, src.getRawName().toJson()).add(X, src.getPosition().m_123341_()).add(Y, src.getPosition().m_123342_()).add(Z, src.getPosition().m_123343_()).add(DIM, src.getDimension()).add(RADIUS, src.getRadius()).add(VISIBLE, src.getVisibility().name()).use(builder -> {
                Optional item = src.getIconStack().left();
                Optional fluid = src.getIconStack().right();
                item.ifPresent(itemStack -> builder.add(ICON, MinecraftAdapter.ICON_ITEM_STACK.serialize((ItemStack)itemStack)));
                fluid.ifPresent(fluidStack -> builder.add(FLUID_ICON, MinecraftAdapter.FLUID.serialize((FluidStack)fluidStack)));
            }).build();
        }

        @Override
        public VisitLocationTask.Part deserialize(JsonElement json) {
            JsonObject object = json.getAsJsonObject();
            VisitLocationTask.Part result = new VisitLocationTask.Part();
            if (object.has(NAME)) {
                result.setName(WrappedText.fromJson(object.get(NAME), false));
            }
            result.setPosition(new BlockPos(GsonHelper.m_13927_((JsonObject)object, (String)X), GsonHelper.m_13927_((JsonObject)object, (String)Y), GsonHelper.m_13927_((JsonObject)object, (String)Z)));
            result.setDimension(GsonHelper.m_13906_((JsonObject)object, (String)DIM));
            result.setRadius(GsonHelper.m_13927_((JsonObject)object, (String)RADIUS));
            result.setVisibility(VisitLocationTask.Visibility.valueOf(GsonHelper.m_13851_((JsonObject)object, (String)VISIBLE, (String)result.getVisibility().name())));
            if (object.has(ICON)) {
                result.setIconStack((Either<ItemStack, FluidStack>)Either.left((Object)MinecraftAdapter.ICON_ITEM_STACK.deserialize(object.get(ICON))));
            }
            if (object.has(FLUID_ICON)) {
                result.setIconStack((Either<ItemStack, FluidStack>)Either.right((Object)MinecraftAdapter.FLUID.deserialize(object.get(FLUID_ICON))));
            }
            return result;
        }
    };
    public static final Adapter<ReputationTask.Part> REPUTATION_TASK_ADAPTER = new Adapter<ReputationTask.Part>(){
        private static final String REPUTATION = "reputation";
        private static final String LOWER = "lower";
        private static final String UPPER = "upper";
        private static final String INVERTED = "inverted";

        @Override
        public JsonElement serialize(ReputationTask.Part src) {
            Adapter.JsonObjectBuilder builder = 3.object().add(REPUTATION, src.getReputation().getId()).add(INVERTED, src.isInverted());
            if (src.getLower() != null) {
                builder.add(LOWER, src.getLower().getId());
            }
            if (src.getUpper() != null) {
                builder.add(UPPER, src.getUpper().getId());
            }
            return builder.build();
        }

        @Override
        public ReputationTask.Part deserialize(JsonElement json) {
            JsonObject object = json.getAsJsonObject();
            Reputation reputation = ReputationManager.getInstance().getReputation(GsonHelper.m_13851_((JsonObject)object, (String)REPUTATION, null));
            ReputationMarker lower = null;
            ReputationMarker upper = null;
            if (object.has(LOWER)) {
                lower = reputation.getMarker(GsonHelper.m_13927_((JsonObject)object, (String)LOWER));
            }
            if (object.has(UPPER)) {
                upper = reputation.getMarker(GsonHelper.m_13927_((JsonObject)object, (String)UPPER));
            }
            if (reputation == null) {
                return null;
            }
            return new ReputationTask.Part(reputation, lower, upper, GsonHelper.m_13855_((JsonObject)object, (String)INVERTED, (boolean)false));
        }
    };
    public static final TypeAdapter<TameMobsTask.Part> TAME_ADAPTER = new TypeAdapter<TameMobsTask.Part>(){
        private static final String TAMES = "tames";
        private static final String TAME = "tame";
        private static final String ICON = "icon";
        private static final String FLUID_ICON = "fluid_icon";
        private static final String NAME = "name";

        public void write(JsonWriter out, TameMobsTask.Part value) throws IOException {
            out.beginObject();
            Streams.write((JsonElement)value.getRawName().toJson(), (JsonWriter)out.name(NAME));
            Optional item = value.getIconStack().left();
            Optional fluid = value.getIconStack().right();
            if (item.isPresent()) {
                MinecraftAdapter.ICON_ITEM_STACK.write(out.name(ICON), (ItemStack)item.get());
            }
            if (fluid.isPresent()) {
                MinecraftAdapter.FLUID.write(out.name(FLUID_ICON), (FluidStack)fluid.get());
            }
            out.name(TAME).value(value.getTame());
            out.name(TAMES).value((long)value.getCount());
            out.endObject();
        }

        public TameMobsTask.Part read(JsonReader in) throws IOException {
            in.beginObject();
            TameMobsTask.Part result = new TameMobsTask.Part();
            while (in.hasNext()) {
                String name = in.nextName();
                if (name.equalsIgnoreCase(NAME)) {
                    result.setName(WrappedText.fromJson(Streams.parse((JsonReader)in), false));
                    continue;
                }
                if (name.equalsIgnoreCase(ICON)) {
                    ItemStack icon = MinecraftAdapter.ICON_ITEM_STACK.read(in);
                    if (icon == null) continue;
                    result.setIconStack((Either<ItemStack, FluidStack>)Either.left((Object)icon));
                    continue;
                }
                if (name.equalsIgnoreCase(FLUID_ICON)) {
                    FluidStack fluid = MinecraftAdapter.FLUID.read(in);
                    if (fluid == null) continue;
                    result.setIconStack((Either<ItemStack, FluidStack>)Either.right((Object)fluid));
                    continue;
                }
                if (name.equalsIgnoreCase(TAME)) {
                    result.setTame(in.nextString());
                    continue;
                }
                if (!name.equalsIgnoreCase(TAMES)) continue;
                result.setCount(in.nextInt());
            }
            in.endObject();
            return result;
        }
    };
    public static final TypeAdapter<GetAdvancementTask.Part> ADVANCEMENT_TASK_ADAPTER = new TypeAdapter<GetAdvancementTask.Part>(){
        private final String ICON = "icon";
        private static final String FLUID_ICON = "fluid_icon";
        private final String NAME = "name";
        private final String ADV_NAME = "adv_name";

        public void write(JsonWriter out, GetAdvancementTask.Part value) throws IOException {
            out.beginObject();
            Streams.write((JsonElement)value.getRawName().toJson(), (JsonWriter)out.name("name"));
            Optional item = value.getIconStack().left();
            Optional fluid = value.getIconStack().right();
            if (item.isPresent()) {
                MinecraftAdapter.ICON_ITEM_STACK.write(out.name("icon"), (ItemStack)item.get());
            }
            if (fluid.isPresent()) {
                MinecraftAdapter.FLUID.write(out.name(FLUID_ICON), (FluidStack)fluid.get());
            }
            if (value.getAdvancement() != null) {
                out.name("adv_name").value(value.getAdvancement());
            }
            out.endObject();
        }

        public GetAdvancementTask.Part read(JsonReader in) throws IOException {
            in.beginObject();
            GetAdvancementTask.Part result = new GetAdvancementTask.Part();
            while (in.hasNext()) {
                String name = in.nextName();
                if (name.equalsIgnoreCase("name")) {
                    result.setName(WrappedText.fromJson(Streams.parse((JsonReader)in), false));
                    continue;
                }
                if (name.equalsIgnoreCase("icon")) {
                    ItemStack icon = MinecraftAdapter.ICON_ITEM_STACK.read(in);
                    if (icon == null) continue;
                    result.setIconStack((Either<ItemStack, FluidStack>)Either.left((Object)icon));
                    continue;
                }
                if (name.equalsIgnoreCase(FLUID_ICON)) {
                    FluidStack fluid = MinecraftAdapter.FLUID.read(in);
                    if (fluid == null) continue;
                    result.setIconStack((Either<ItemStack, FluidStack>)Either.right((Object)fluid));
                    continue;
                }
                if (!name.equalsIgnoreCase("adv_name")) continue;
                result.setAdvancement(in.nextString());
            }
            in.endObject();
            return result;
        }
    };
    public static final TypeAdapter<CompleteQuestTask.Part> QUEST_COMPLETED_ADAPTER = new TypeAdapter<CompleteQuestTask.Part>(){
        private final String QUEST_UUID = "quest_uuid";

        public void write(JsonWriter out, CompleteQuestTask.Part value) throws IOException {
            out.beginObject();
            if (value.getQuest() != null) {
                out.name("quest_uuid").value(value.getQuestId().toString());
            }
            out.endObject();
        }

        public CompleteQuestTask.Part read(JsonReader in) throws IOException {
            in.beginObject();
            CompleteQuestTask.Part result = new CompleteQuestTask.Part();
            while (in.hasNext()) {
                String name = in.nextName();
                if (!name.equalsIgnoreCase("quest_uuid")) continue;
                result.setQuest(UUID.fromString(in.nextString()));
            }
            in.endObject();
            return result;
        }
    };
    public static final Adapter<KillMobsTask.Part> MOB_ADAPTER = new Adapter<KillMobsTask.Part>(){
        private static final String KILLS = "kills";
        private static final String MOB = "mob";
        private static final String ICON = "icon";
        private static final String FLUID_ICON = "fluid_icon";
        private static final String NAME = "name";

        @Override
        public JsonElement serialize(KillMobsTask.Part src) {
            return 7.object().add(NAME, src.getRawName().toJson()).use(builder -> {
                Optional item = src.getIconStack().left();
                Optional fluid = src.getIconStack().right();
                item.ifPresent(itemStack -> builder.add(ICON, MinecraftAdapter.ICON_ITEM_STACK.toJsonTree(itemStack)));
                fluid.ifPresent(fluidStack -> builder.add(FLUID_ICON, MinecraftAdapter.FLUID.toJsonTree(fluidStack)));
            }).add(MOB, src.getMob().toString()).add(KILLS, src.getCount()).build();
        }

        @Override
        public KillMobsTask.Part deserialize(JsonElement json) {
            JsonObject object = json.getAsJsonObject();
            KillMobsTask.Part result = new KillMobsTask.Part();
            if (object.has(NAME)) {
                result.setName(WrappedText.fromJson(object.get(NAME), false));
            }
            result.setMob(new ResourceLocation(GsonHelper.m_13851_((JsonObject)object, (String)MOB, (String)result.getMob().toString())));
            result.setCount(GsonHelper.m_13824_((JsonObject)object, (String)KILLS, (int)result.getCount()));
            if (object.has(ICON)) {
                ItemStack icon = MinecraftAdapter.ICON_ITEM_STACK.deserialize((JsonElement)GsonHelper.m_13930_((JsonObject)object, (String)ICON));
                result.setIconStack((Either<ItemStack, FluidStack>)Either.left((Object)icon));
            }
            if (object.has(FLUID_ICON)) {
                FluidStack fluid = MinecraftAdapter.FLUID.deserialize((JsonElement)GsonHelper.m_13930_((JsonObject)object, (String)FLUID_ICON));
                result.setIconStack((Either<ItemStack, FluidStack>)Either.right((Object)fluid));
            }
            return result;
        }
    };
    public static Map<ReputationTask<?>, List<ReputationSettingConstructor>> taskReputationListMap = new HashMap();
    protected static final Adapter<QuestTask<?>> TASK_ADAPTER = new Adapter<QuestTask<?>>(){
        private static final String TYPE = "type";
        private static final String NAME = "description";
        private static final String DESCRIPTION = "longDescription";

        @Override
        public JsonElement serialize(QuestTask<?> src) {
            TaskType<?> type = src.getType();
            Adapter.JsonObjectBuilder builder = 8.object().add(TYPE, type.toDataName());
            if (!src.getRawName().equals(WrappedText.createTranslated(type.getLangKeyName()))) {
                builder.add(NAME, src.getRawName().toJson());
            }
            if (!src.getRawDescription().equals(WrappedText.createTranslated(type.getLangKeyDescription()))) {
                builder.add(DESCRIPTION, src.getRawDescription().toJson());
            }
            src.write(builder);
            return builder.build();
        }

        @Override
        public QuestTask<?> deserialize(JsonElement json) {
            JsonObject object = json.getAsJsonObject();
            TaskType<?> type = TaskType.fromDataName(GsonHelper.m_13906_((JsonObject)object, (String)TYPE));
            Object TASK = type.addTask(QuestAdapter.QUEST);
            if (object.has(NAME)) {
                ((QuestTask)TASK).setName(WrappedText.fromJson(object.get(NAME), true));
            }
            if (object.has(DESCRIPTION)) {
                ((QuestTask)TASK).setDescription(WrappedText.fromJson(object.get(DESCRIPTION), true));
            }
            ((QuestTask)TASK).read(object);
            return TASK;
        }
    };

    public static class ReputationSettingConstructor {
        private static final String REPUTATION = "reputation";
        private static final String LOWER = "lower";
        private static final String UPPER = "upper";
        private static final String INVERTED = "inverted";
        String reputation;
        boolean inverted;
        private final int upper;
        private final int lower;

        private ReputationSettingConstructor(String reputation, int lower, int upper, boolean inverted) {
            this.reputation = reputation;
            this.lower = lower;
            this.upper = upper;
            this.inverted = inverted;
        }

        public static ReputationSettingConstructor read(JsonElement in) {
            JsonObject object = in.getAsJsonObject();
            String reputation = GsonHelper.m_13851_((JsonObject)object, (String)REPUTATION, null);
            if (reputation == null) {
                return null;
            }
            return new ReputationSettingConstructor(reputation, GsonHelper.m_13824_((JsonObject)object, (String)LOWER, (int)Integer.MIN_VALUE), GsonHelper.m_13824_((JsonObject)object, (String)UPPER, (int)Integer.MIN_VALUE), GsonHelper.m_13855_((JsonObject)object, (String)INVERTED, (boolean)false));
        }

        public ReputationTask.Part constructReputationSetting() {
            Reputation reputation = ReputationManager.getInstance().getReputations().get(this.reputation);
            if (reputation != null) {
                ReputationMarker lower = null;
                ReputationMarker upper = null;
                if (this.lower >= 0 && this.lower < reputation.getMarkerCount()) {
                    lower = reputation.getMarker(this.lower);
                }
                if (this.upper >= 0 && this.upper < reputation.getMarkerCount()) {
                    upper = reputation.getMarker(this.upper);
                }
                return new ReputationTask.Part(reputation, lower, upper, this.inverted);
            }
            return null;
        }
    }
}

