/*
 * Decompiled with CFR 0.152.
 */
package hardcorequesting.common.forge.io.adapter;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import hardcorequesting.common.forge.io.adapter.Adapter;
import hardcorequesting.common.forge.io.adapter.QuestDataAdapter;
import hardcorequesting.common.forge.quests.Quest;
import hardcorequesting.common.forge.quests.data.QuestData;
import hardcorequesting.common.forge.reputation.Reputation;
import hardcorequesting.common.forge.reputation.ReputationManager;
import hardcorequesting.common.forge.team.LifeSetting;
import hardcorequesting.common.forge.team.PlayerEntry;
import hardcorequesting.common.forge.team.RewardSetting;
import hardcorequesting.common.forge.team.Team;
import hardcorequesting.common.forge.team.TeamManager;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.stream.StreamSupport;
import net.minecraft.Util;
import net.minecraft.util.GsonHelper;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class TeamAdapter {
    private static final Logger LOGGER = LogManager.getLogger((String)"Hardcore Questing Mode");
    private static Map<Team, List<UUID>> invitesMap = new HashMap<Team, List<UUID>>();
    public static final Adapter<Team> TEAM_ADAPTER = new Adapter<Team>(){
        private static final String ID = "id";
        private static final String NAME = "name";
        private static final String LIFE_SETTING = "lifeSetting";
        private static final String REWARD_SETTING = "rewardSetting";
        private static final String PLAYERS = "players";
        private static final String REPUTATIONS = "reputations";
        private static final String REP_ID = "reputationId";
        private static final String REP_VAL = "reputationValue";
        private static final String QUEST_DATA_LIST = "questDataList";
        private static final String QUEST_ID = "questId";
        private static final String QUEST_DATA = "questData";
        private static final String INVITES = "invites";

        @Override
        public JsonElement serialize(Team src) {
            return 1.object().add(ID, src.getId().toString()).add(NAME, src.getName()).add(LIFE_SETTING, src.getLifeSetting().name()).add(REWARD_SETTING, src.getRewardSetting().name()).add(PLAYERS, (JsonElement)1.array().use(builder -> {
                for (PlayerEntry entry : src.getPlayers()) {
                    builder.add(entry.toJson());
                }
            }).build()).add(REPUTATIONS, (JsonElement)1.array().use(builder -> {
                for (Reputation reputation : ReputationManager.getInstance().getReputations().values()) {
                    builder.add((JsonElement)1.object().add(REP_ID, reputation.getId()).add(REP_VAL, src.getReputation(reputation)).build());
                }
            }).build()).add(QUEST_DATA_LIST, (JsonElement)1.array().use(builder -> {
                for (Map.Entry<UUID, QuestData> data : src.getQuestData().entrySet()) {
                    builder.add((JsonElement)1.object().add(QUEST_ID, data.getKey().toString()).add(QUEST_DATA, QuestDataAdapter.serialize(data.getValue())).build());
                }
            }).build()).add(INVITES, (JsonElement)1.array().use(builder -> {
                for (Team team : src.getInvites()) {
                    builder.add(team.getId().toString());
                }
            }).build()).build();
        }

        @Override
        public Team deserialize(JsonElement json) throws JsonParseException {
            ArrayList<UUID> invites = new ArrayList<UUID>();
            JsonObject object = json.getAsJsonObject();
            Team team = Team.empty();
            if (object.has(ID) && object.get(ID).getAsJsonPrimitive().isString()) {
                team.setId(UUID.fromString(GsonHelper.m_13906_((JsonObject)object, (String)ID)));
            }
            if (!team.getId().equals(Util.f_137441_)) {
                team.setName(GsonHelper.m_13906_((JsonObject)object, (String)NAME));
            }
            team.setLifeSetting(LifeSetting.valueOf(GsonHelper.m_13906_((JsonObject)object, (String)LIFE_SETTING)));
            team.setRewardSetting(RewardSetting.valueOf(GsonHelper.m_13906_((JsonObject)object, (String)REWARD_SETTING)));
            for (JsonElement element : GsonHelper.m_13933_((JsonObject)object, (String)PLAYERS)) {
                team.addPlayer(PlayerEntry.read(element));
            }
            for (JsonElement element : GsonHelper.m_13933_((JsonObject)object, (String)REPUTATIONS)) {
                JsonObject reputationObject = element.getAsJsonObject();
                team.setReputation(GsonHelper.m_13906_((JsonObject)reputationObject, (String)REP_ID), (Integer)GsonHelper.m_13927_((JsonObject)reputationObject, (String)REP_VAL));
            }
            for (JsonElement element : GsonHelper.m_13933_((JsonObject)object, (String)QUEST_DATA_LIST)) {
                JsonObject questDataObject = element.getAsJsonObject();
                UUID questId = UUID.fromString(GsonHelper.m_13906_((JsonObject)questDataObject, (String)QUEST_ID));
                Quest quest = Quest.getQuest(questId);
                if (quest != null) {
                    QuestData questData = QuestDataAdapter.deserialize(GsonHelper.m_13930_((JsonObject)questDataObject, (String)QUEST_DATA), quest);
                    team.getQuestData().put(questId, questData);
                    continue;
                }
                LOGGER.error("Couldn't find quest with id {} while loading quest progress data. Discarding data.", (Object)questId);
            }
            for (JsonElement element : GsonHelper.m_13933_((JsonObject)object, (String)INVITES)) {
                if (!element.getAsJsonPrimitive().isString()) continue;
                invites.add(UUID.fromString(element.getAsString()));
            }
            if (!invites.isEmpty()) {
                invitesMap.put(team, invites);
            }
            return team;
        }
    };

    public static void clearInvitesMap() {
        invitesMap.clear();
    }

    public static void commitInvitesMap() {
        if (invitesMap.size() > 0) {
            HashMap tempMap = new HashMap();
            StreamSupport.stream(TeamManager.getInstance().getNamedTeams().spliterator(), false).filter(Objects::nonNull).forEach(team -> tempMap.put(team.getId(), team));
            for (Team team2 : TeamManager.getInstance().getTeams()) {
                List<UUID> invites = invitesMap.get(team2);
                if (invites == null) continue;
                invites.forEach(id -> {
                    if (tempMap.containsKey(id)) {
                        team2.getInvites().add((Team)tempMap.get(id));
                    }
                });
            }
        }
        TeamAdapter.clearInvitesMap();
    }
}

