/*
 * Decompiled with CFR 0.152.
 */
package hardcorequesting.common.forge.items;

import hardcorequesting.common.forge.bag.BagTier;
import hardcorequesting.common.forge.bag.LootGroup;
import hardcorequesting.common.forge.client.sounds.Sounds;
import hardcorequesting.common.forge.network.GeneralUsage;
import java.util.List;
import java.util.UUID;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.apache.commons.lang3.ArrayUtils;

public class BagItem
extends Item {
    public static boolean displayGui;
    public BagTier tier;
    public int tierOrdinal;

    public BagItem(BagTier tier) {
        super(new Item.Properties().m_41503_(0).m_41487_(64));
        this.tier = tier;
        this.tierOrdinal = tier.ordinal();
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level world, Player player, InteractionHand hand) {
        if (!world.f_46443_) {
            int totalWeight = 0;
            for (LootGroup group : LootGroup.getGroups().values()) {
                if (!group.isValid(player)) continue;
                totalWeight += group.getTier().getWeights()[this.tierOrdinal];
            }
            if (totalWeight > 0) {
                int rng = (int)(Math.random() * (double)totalWeight);
                for (LootGroup group : LootGroup.getGroups().values()) {
                    if (!group.isValid(player)) continue;
                    int weight = group.getTier().getWeights()[this.tierOrdinal];
                    if (rng < weight) {
                        group.open(player);
                        player.m_150109_().m_6596_();
                        this.openClientInterface(player, group.getId(), this.tierOrdinal);
                        world.m_5594_(null, player.m_20183_(), Sounds.BAG.getSound(), SoundSource.MASTER, 1.0f, 1.0f);
                        break;
                    }
                    rng -= weight;
                }
            }
            ItemStack stack = player.m_21120_(hand).m_41777_();
            stack.m_41774_(1);
            player.m_21008_(hand, stack);
            return InteractionResultHolder.m_19090_((Object)stack);
        }
        return InteractionResultHolder.m_19096_((Object)player.m_21120_(hand));
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_7373_(ItemStack stack, Level world, List<Component> tooltip, TooltipFlag context) {
        super.m_7373_(stack, world, tooltip, context);
        tooltip.add(this.tier.getColoredName());
    }

    private void openClientInterface(Player player, UUID groupId, int bag) {
        GeneralUsage.sendOpenBagUpdate(player, groupId, bag, ArrayUtils.toPrimitive((Integer[])((Integer[])LootGroup.getGroups().values().stream().filter(group -> group.getLimit() != 0).map(group -> group.getRetrievalCount(player)).toArray(Integer[]::new))));
    }
}

