/*
 * Decompiled with CFR 0.152.
 */
package hardcorequesting.common.forge.items;

import hardcorequesting.common.forge.client.sounds.SoundHandler;
import hardcorequesting.common.forge.client.sounds.Sounds;
import hardcorequesting.common.forge.config.HQMConfig;
import hardcorequesting.common.forge.death.DeathType;
import hardcorequesting.common.forge.items.ModItems;
import hardcorequesting.common.forge.quests.QuestingDataManager;
import hardcorequesting.common.forge.util.Translator;
import java.util.List;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class ItemHeart
extends Item {
    private int value;

    public ItemHeart(int value) {
        super(new Item.Properties().m_41487_(64));
        this.value = value;
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level world, Player player, InteractionHand hand) {
        if (!world.f_46443_) {
            QuestingDataManager questingDataManager = QuestingDataManager.getInstance();
            ItemStack stack = player.m_21120_(hand);
            if (this.value == 3) {
                if (!questingDataManager.isHardcoreActive()) {
                    player.m_213846_((Component)Translator.translatable("hqm.message.noHardcoreYet", new Object[0]));
                } else if (questingDataManager.getQuestingData(player).getRawLives() < HQMConfig.getInstance().Hardcore.MAX_LIVES) {
                    questingDataManager.getQuestingData(player).addLives(player, 1);
                    player.m_213846_((Component)Translator.translatable("hqm.message.addOne", new Object[0]));
                    int lives = questingDataManager.getQuestingData(player).getLives();
                    player.m_213846_((Component)Translator.translatable("hqm.message.haveRemaining", lives));
                    SoundHandler.play(Sounds.LIFE, player);
                    if (!player.m_150110_().f_35937_) {
                        stack.m_41774_(1);
                    }
                } else {
                    player.m_213846_((Component)Translator.translatable("hqm.message.haveMaxLives", new Object[0]));
                }
            }
            if (this.value == 4) {
                if (!questingDataManager.isHardcoreActive()) {
                    player.m_213846_((Component)Translator.translatable("hqm.message.noHardcoreYet", new Object[0]));
                } else {
                    SoundHandler.play(Sounds.ROTTEN, player);
                    player.m_213846_((Component)Translator.translatable("hqm.message.eatRottenHearth", new Object[0]));
                    questingDataManager.getQuestingData(player).removeLifeAndSendMessage(player);
                    DeathType.HQM.onDeath(player);
                    if (!player.m_150110_().f_35937_) {
                        stack.m_41769_(1);
                    }
                }
            }
            return InteractionResultHolder.m_19090_((Object)stack);
        }
        return super.m_7203_(world, player, hand);
    }

    public void m_6883_(ItemStack stack, Level world, Entity entity, int slot, boolean selected) {
        if (entity instanceof Player) {
            Player entityPlayer = (Player)entity;
            if (this.value == 3 && HQMConfig.getInstance().Hardcore.HEART_ROT_ENABLE) {
                CompoundTag tagCompound = stack.m_41783_();
                if (tagCompound == null) {
                    tagCompound = new CompoundTag();
                    stack.m_41751_(tagCompound);
                }
                if (!tagCompound.m_128441_("RotTime")) {
                    int rot = HQMConfig.getInstance().Hardcore.HEART_ROT_TIME * 20;
                    tagCompound.m_128405_("MaxRot", rot);
                    tagCompound.m_128405_("RotTime", rot);
                } else {
                    int newRot = tagCompound.m_128451_("RotTime");
                    if (newRot <= 0) {
                        stack = new ItemStack((ItemLike)ModItems.rottenHeart.get());
                        entityPlayer.m_213846_((Component)Translator.translatable("hqm.message.hearthDecay", new Object[0]));
                    } else {
                        tagCompound.m_128405_("RotTime", newRot - 1);
                    }
                }
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_7373_(ItemStack stack, Level world, List<Component> tooltip, TooltipFlag context) {
        super.m_7373_(stack, world, tooltip, context);
        if (this.value == 3) {
            tooltip.add((Component)Translator.translatable("item.hqm:hearts_heart.tooltip", new Object[0]));
            if (HQMConfig.getInstance().Hardcore.HEART_ROT_ENABLE) {
                CompoundTag tagCompound = stack.m_41783_();
                if (tagCompound == null) {
                    tagCompound = new CompoundTag();
                    stack.m_41751_(tagCompound);
                }
                if (tagCompound.m_128441_("RotTime")) {
                    int rot = tagCompound.m_128451_("RotTime");
                    int maxRot = tagCompound.m_128451_("MaxRot");
                    float percentage = rot * 100 / maxRot;
                    tooltip.add((Component)Translator.translatable("item.hqm:hearts_heart.freshness", Float.valueOf(percentage)));
                }
            }
        }
        if (this.value == 4) {
            tooltip.add((Component)Translator.translatable("item.hqm:hearts_rottenheart.tooltip", new Object[0]));
        }
    }

    public boolean m_5812_(ItemStack stack) {
        return this.value == 3 || this.value == 4;
    }
}

